/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.homology;

import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.enumeration.homology.HomologyProperties;
import chemaxon.struc.MolAtom;
import chemaxon.util.IntRange;
import java.util.ArrayList;

public final class HomologyPropertyTypes {
    public static String[] getApplicableReservedPropertyNames(MolAtom atom) {
        ArrayList<String> reservedPropertiesList = new ArrayList<String>();
        if (Branching.isApplicableOnAtom(atom)) {
            reservedPropertiesList.add("BRANCHING");
        }
        if (Saturation.isApplicableOnAtom(atom)) {
            reservedPropertiesList.add("SATURATION");
        }
        if (RingType.isApplicableOnAtom(atom)) {
            reservedPropertiesList.add("RINGTYPE");
        }
        if (Size.isApplicableOnAtom(atom)) {
            reservedPropertiesList.add("SIZE");
        }
        if (DeuteriumTritium.isApplicableOnAtom(atom)) {
            reservedPropertiesList.add("DTCOUNT");
        }
        if (Textnotes.isApplicableOnAtom(atom)) {
            reservedPropertiesList.add("TEXTNOTES");
        }
        return reservedPropertiesList.toArray(new String[0]);
    }

    public static String[] getAllReservedPropertyNames() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("BRANCHING");
        res.add("SATURATION");
        res.add("RINGTYPE");
        res.add("SIZE");
        res.add("DTCOUNT");
        res.add("TEXTNOTES");
        return res.toArray(new String[res.size()]);
    }

    public static final class Textnotes {
        public static final String ATOM_PROPERTY_NAME = "TEXTNOTES";
        public static final String SEPARATOR = ",";

        public static final boolean isApplicableOnAtom(MolAtom atom) {
            return atom.isPseudo() && HomologyConstants.isHomology(atom.getAliasstr()) && !HomologyConstants.isAtomicHomology(atom.getAliasstr());
        }

        public static final boolean isValidPropertyString(String value) {
            MolAtom atom = new MolAtom(136);
            atom.setAliasstr("CHK");
            atom.putProperty(ATOM_PROPERTY_NAME, value);
            try {
                HomologyProperties prop = new HomologyProperties(atom);
                return prop.hasPropertyErrorWithoutException();
            }
            catch (Exception exc) {
                return false;
            }
        }
    }

    public static final class DeuteriumTritium {
        public static final String ATOM_PROPERTY_NAME = "DTCOUNT";

        public static final boolean isApplicableOnAtom(MolAtom atom) {
            return atom.isPseudo() && HomologyConstants.isHomology(atom.getAliasstr()) && !HomologyConstants.isAtomicHomology(atom.getAliasstr());
        }

        public static final String getPropertyString(String deuterium, String tritium) {
            return "D" + deuterium + "T" + tritium;
        }

        public static final boolean isValidPropertyString(String value) {
            String[] split1;
            for (String s1 : split1 = value.split("D|T|d|t")) {
                if (s1.length() == 0 || IntRange.isValidRangeString(s1)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class Size {
        public static final String ATOM_PROPERTY_NAME = "SIZE";
        public static final String SEPARATOR = " ";
        public static final String HIGH = "HI";
        public static final String MIDDLE = "MID";
        public static final String LOW = "LO";

        public static final String getPropertyString(boolean low, boolean middle, boolean high) {
            if (!(low || middle || high)) {
                return null;
            }
            if (low && middle && high) {
                return null;
            }
            StringBuffer size = new StringBuffer();
            if (low) {
                size.append(LOW);
            }
            if (middle) {
                if (size.length() > 0) {
                    size.append(SEPARATOR);
                }
                size.append(MIDDLE);
            }
            if (high) {
                if (size.length() > 0) {
                    size.append(SEPARATOR);
                }
                size.append(HIGH);
            }
            return new String(size);
        }

        public static final boolean isApplicableOnAtom(MolAtom atom) {
            return Branching.isApplicableOnAtom(atom);
        }
    }

    public static final class RingType {
        public static final String ATOM_PROPERTY_NAME = "RINGTYPE";
        public static final String FUSED = "FU";
        public static final String MONOCYCLIC = "MON";

        public static final boolean isApplicableOnAtom(MolAtom atom) {
            if (!atom.isPseudo()) {
                return false;
            }
            String alias = atom.getAliasstr();
            return HomologyConstants.isCycloAlkyl(alias) || HomologyConstants.isAryl(alias) || HomologyConstants.isAnyCycle(alias) || HomologyConstants.isAnyGroup(alias);
        }
    }

    public static final class Saturation {
        public static final String ATOM_PROPERTY_NAME = "SATURATION";
        public static final String SATURATED = "SAT";
        public static final String UNSATURATED = "UNS";

        public static final boolean isApplicableOnAtom(MolAtom atom) {
            if (!atom.isPseudo()) {
                return false;
            }
            String alias = atom.getAliasstr();
            return HomologyConstants.isCycloAlkyl(alias) || HomologyConstants.isAliphaticHeteroCyclyl(alias) || HomologyConstants.isFusedHetero(alias) || HomologyConstants.isAnyCycle(alias) || HomologyConstants.isAnyGroup(alias);
        }
    }

    public static final class Branching {
        public static final String ATOM_PROPERTY_NAME = "BRANCHING";
        public static final String BRANCHED = "BRA";
        public static final String STRAIGHT = "STR";

        public static final boolean isApplicableOnAtom(MolAtom atom) {
            if (!atom.isPseudo()) {
                return false;
            }
            String alias = atom.getAliasstr();
            return HomologyConstants.isAlkyl(alias) || HomologyConstants.isAlkenyl(alias) || HomologyConstants.isAlkynyl(alias) || HomologyConstants.isCarbonTree(alias) || HomologyConstants.isAnyGroup(alias);
        }
    }
}

