/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.homology;

import chemaxon.common.util.IntVector;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import java.util.HashMap;

public final class StaticRgMoleculeUtil {
    private RgMolecule rgMolecule = null;
    private int[][] memberFirstAtomIndexes = null;
    private IntVector[] parentIndexes = null;
    private HashMap<Integer, Integer> rgIdIndexMap = null;

    public StaticRgMoleculeUtil(RgMolecule rgm) {
        this.rgMolecule = rgm;
        this.fillMemberIndexes();
    }

    private void fillMemberIndexes() {
        this.memberFirstAtomIndexes = new int[this.rgMolecule.getRgroupCount()][];
        int atomIndex = this.rgMolecule.getRoot().getAtomCount();
        int n = this.rgMolecule.getRgroupCount();
        for (int rgInd = 0; rgInd < n; ++rgInd) {
            int memberCount = this.rgMolecule.getRgroupMemberCount(rgInd);
            this.memberFirstAtomIndexes[rgInd] = new int[memberCount];
            for (int memberInd = 0; memberInd < memberCount; ++memberInd) {
                this.memberFirstAtomIndexes[rgInd][memberInd] = atomIndex;
                atomIndex += this.rgMolecule.getRgroupMember(rgInd, memberInd).getAtomCount();
            }
        }
    }

    int[][] getMemberFirstAtomIndexes() {
        return (int[][])this.memberFirstAtomIndexes.clone();
    }

    public final int getMemberFirstAtomIndex(int rgIndex, int memberIndex) {
        return this.memberFirstAtomIndexes[rgIndex][memberIndex];
    }

    private void fillParentIndexes() {
        if (this.parentIndexes != null) {
            return;
        }
        MoleculeGraph union = this.rgMolecule.getGraphUnion();
        int atomCount = union.getAtomCount();
        this.parentIndexes = new IntVector[atomCount];
        for (int i = 0; i < this.parentIndexes.length; ++i) {
            this.parentIndexes[i] = new IntVector();
        }
        if (this.rgIdIndexMap == null) {
            this.rgIdIndexMap = this.calculateRgIdIndexMap();
        }
        for (int rAtomIndex = 0; rAtomIndex < atomCount; ++rAtomIndex) {
            int rID;
            Integer rIndexVal;
            MolAtom rgAtom = union.getAtom(rAtomIndex);
            if (rgAtom.getAtno() != 134 || (rIndexVal = this.rgIdIndexMap.get(rID = rgAtom.getRgroup())) == null) continue;
            int rIndex = rIndexVal;
            int firstIndex = this.getMemberFirstAtomIndex(rIndex, 0);
            int lastMemberIndex = this.rgMolecule.getRgroupMemberCount(rIndex) - 1;
            int lastIndex = this.getMemberFirstAtomIndex(rIndex, lastMemberIndex) + this.rgMolecule.getRgroupMember(rIndex, lastMemberIndex).getAtomCount() - 1;
            for (int rgDefAtomIndex = firstIndex; rgDefAtomIndex <= lastIndex; ++rgDefAtomIndex) {
                this.parentIndexes[rgDefAtomIndex].add(rAtomIndex);
            }
        }
    }

    private HashMap<Integer, Integer> calculateRgIdIndexMap() {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        int rgCount = this.rgMolecule.getRgroupCount();
        for (int rgInd = 0; rgInd < rgCount; ++rgInd) {
            result.put(this.rgMolecule.getRgroupId(rgInd), rgInd);
        }
        return result;
    }

    public IntVector getParentIndexes(int atomInd) {
        if (this.parentIndexes == null) {
            this.fillMemberIndexes();
            this.fillParentIndexes();
        }
        return this.parentIndexes[atomInd];
    }

    public int getRgIndexFromId(int rgroupId) {
        Integer index;
        if (this.rgIdIndexMap == null) {
            this.rgIdIndexMap = this.calculateRgIdIndexMap();
        }
        return (index = this.rgIdIndexMap.get(rgroupId)) == null ? -1 : index;
    }

    public final int getRgroupMemberCount(int rgInd) {
        return this.memberFirstAtomIndexes[rgInd].length;
    }

    public RgroupMemberShip getRgroupMemberShip(int indexOfAtomToProcess) {
        if (this.memberFirstAtomIndexes.length < 1 || indexOfAtomToProcess < this.memberFirstAtomIndexes[0][0]) {
            return new RgroupMemberShip(-1, -1);
        }
        int rgCount = this.memberFirstAtomIndexes.length;
        for (int rgIndex = 0; rgIndex < rgCount; ++rgIndex) {
            int memberCount = this.memberFirstAtomIndexes[rgIndex].length;
            for (int memberIndex = 0; memberIndex < memberCount; ++memberIndex) {
                if (indexOfAtomToProcess >= this.memberFirstAtomIndexes[rgIndex][memberIndex]) continue;
                if (memberIndex > 0) {
                    return new RgroupMemberShip(rgIndex, memberIndex - 1);
                }
                return new RgroupMemberShip(rgIndex - 1, this.memberFirstAtomIndexes[rgIndex - 1].length - 1);
            }
        }
        return new RgroupMemberShip(rgCount - 1, this.memberFirstAtomIndexes[rgCount - 1].length - 1);
    }

    public class RgroupMemberShip {
        int rgIndex;
        int rgMemberIndex;

        RgroupMemberShip(int rgIndex, int rgMemberIndex) {
            this.rgIndex = rgIndex;
            this.rgMemberIndex = rgMemberIndex;
        }

        public final int getRgIndex() {
            return this.rgIndex;
        }

        public final int getRgMemberIndex() {
            return this.rgMemberIndex;
        }
    }
}

