/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.supergraph;

import chemaxon.sss.search.MarkushFeature;

public class ExpansionRecord {
    private MarkushFeature feature = null;
    private int value = -1;

    ExpansionRecord(MarkushFeature feature, int value) {
        this.feature = feature;
        this.value = value;
    }

    ExpansionRecord(int ... data) {
        int featureType = data[0];
        int[] featureData = new int[data.length - 2];
        System.arraycopy(data, 1, featureData, 0, featureData.length);
        this.feature = new MarkushFeature(featureType, featureData);
        this.value = data[data.length - 1];
    }

    public MarkushFeature getFeature() {
        return this.feature;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        int type = this.feature.getType();
        int s = type == 6 || type == 4 ? this.value + 1 : this.value;
        return this.feature.toString() + " " + s;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExpansionRecord)) {
            return false;
        }
        ExpansionRecord er = (ExpansionRecord)o;
        return this.feature.equals(er.feature) && this.value == er.value;
    }
}

