/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.supergraph;

import chemaxon.core.calculations.FindAllRings;
import chemaxon.enumeration.supergraph.Supergraph;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.BitSet;

public class SupergraphFindAllRings
extends FindAllRings {
    private Supergraph supergraph = null;

    public SupergraphFindAllRings() {
    }

    public SupergraphFindAllRings(MoleculeGraph a) {
        super(a);
        this.setSupergraph(a);
    }

    @Override
    public void setGraph(MoleculeGraph a) {
        super.setGraph(a);
        this.setSupergraph(a);
    }

    private void setSupergraph(MoleculeGraph a) {
        this.supergraph = a instanceof Supergraph ? (Supergraph)a : null;
    }

    @Override
    protected boolean checkEdgeCompatibility(BitSet labelN1, BitSet labelN2, int idx, int e1OtherIdx, int e2OtherIdx) {
        if (this.supergraph == null) {
            return super.checkEdgeCompatibility(labelN1, labelN2, idx, e1OtherIdx, e2OtherIdx);
        }
        int idx1 = this.getOriginalNeighbour(labelN1, idx, e1OtherIdx);
        int idx2 = this.getOriginalNeighbour(labelN2, idx, e2OtherIdx);
        return this.supergraph.isCompatible(idx1, idx2);
    }

    private int getOriginalNeighbour(BitSet labelN, int idx, int otherIdx) {
        if (labelN == null) {
            return otherIdx;
        }
        MolAtom atom = this.supergraph.getAtom(idx);
        int count = atom.getBondCount();
        for (int j = 0; j < count; ++j) {
            int nindex = this.supergraph.indexOf(atom.getLigand(j));
            if (!labelN.get(nindex)) continue;
            return nindex;
        }
        return -1;
    }

    public int[][] getNonAromRings() {
        ArrayList<int[]> list = new ArrayList<int[]>(this.ringIdxes.length);
        for (int i = 0; i < this.ringIdxes.length; ++i) {
            if (this.isAromatic(this.ringIdxes[i])) continue;
            list.add(this.ringIdxes[i]);
        }
        int[][] nonAromRingIdxes = new int[list.size()][];
        list.toArray((T[])nonAromRingIdxes);
        return nonAromRingIdxes;
    }

    public int[][] getAromRings() {
        ArrayList<int[]> list = new ArrayList<int[]>(this.ringIdxes.length);
        for (int i = 0; i < this.ringIdxes.length; ++i) {
            if (!this.isAromatic(this.ringIdxes[i])) continue;
            list.add(this.ringIdxes[i]);
        }
        int[][] aromRingIdxes = new int[list.size()][];
        list.toArray((T[])aromRingIdxes);
        return aromRingIdxes;
    }

    @Override
    protected MoleculeGraph getGraph() {
        return this.supergraph == null ? super.getGraph() : this.supergraph;
    }
}

