/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.enumeration.supergraph.util;

import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;
import chemaxon.util.DFS;
import chemaxon.util.DFSVisitor;

class MarkushBetweenConnsClassifier
extends DFS {
    private boolean[] atomBetween;
    private int startingAtt = 0;

    MarkushBetweenConnsClassifier() {
    }

    public void classify(MoleculeGraph graph) {
        this.setCgraph(graph);
        if (this.visitors == null) {
            this.addVisitor(new MBCCVisitor(this));
        }
        this.traverseAll();
    }

    @Override
    public void traverseAll() {
        this.setAllPathMode(true);
        for (int index = 0; index < this.ctab.length; ++index) {
            if (this.visited[index] != 0 || !this.hasAttachment(index)) continue;
            int[] attV = this.getAttach(index);
            if (attV.length == 2) {
                this.visited[index] = 2;
                this.atomBetween[index] = true;
                continue;
            }
            this.startingAtt = attV[0];
            this.dfsroot = this.dfsindex;
            this.traverse(index);
        }
    }

    public boolean isAtomBetween(int index) {
        return this.atomBetween[index];
    }

    private int[] getAttach(int index) {
        MolAtom ma = this.cgraph.getAtom(index);
        return MolImportUtil.getAttachmentOrders(ma);
    }

    private boolean hasAttachment(int index) {
        return this.getAttach(index).length != 0;
    }

    @Override
    public void init() {
        for (int i = 0; i < this.atomBetween.length; ++i) {
            this.atomBetween[i] = false;
        }
        super.init();
    }

    @Override
    protected void alloc(int capacity) {
        int n = this.getPreferredSize(capacity);
        this.atomBetween = new boolean[n];
        super.alloc(capacity);
    }

    class MBCCVisitor
    extends DFSVisitor {
        MBCCVisitor(DFS d) {
            super(d);
        }

        @Override
        public void visit(int index) {
            int[] attV;
            if (MarkushBetweenConnsClassifier.this.hasAttachment(index) && (attV = MarkushBetweenConnsClassifier.this.getAttach(index))[0] != MarkushBetweenConnsClassifier.this.startingAtt) {
                for (int i = MarkushBetweenConnsClassifier.this.pathlen - 1; i >= 0; --i) {
                    ((MarkushBetweenConnsClassifier)MarkushBetweenConnsClassifier.this).atomBetween[((MarkushBetweenConnsClassifier)MarkushBetweenConnsClassifier.this).path[i]] = true;
                }
                ((MarkushBetweenConnsClassifier)MarkushBetweenConnsClassifier.this).atomBetween[index] = true;
            }
        }
    }
}

