/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;

@Fixes(value={StructureCheckerErrorType.INVALID_CHIRAL_FLAG})
@FixerInfo(name="Fix Chiral Flag", description="Removes the chiral flag of a non-stereo compound.", actionStringToken="clearabsstereo")
public class AbsoluteStereoFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        result.getMolecule().setAbsStereo(!result.getMolecule().isAbsStereo());
        return true;
    }
}

