/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.StructureCheckerHelper;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.sgroup.SgroupAtom;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@Fixes(value={StructureCheckerErrorType.PSEUDO})
@FixerInfo(name="Convert Pseudo Atom to Group", description="Converts pseudo atoms to abbreviated groups.", actionStringToken="pseudotogroup")
public class ConvertPseudoToGroupFixer
extends AbstractStructureFixer {
    private Map<String, Molecule> abbrevGroups;

    @Override
    public boolean fix(StructureCheckerResult result) {
        if (this.abbrevGroups == null) {
            try {
                this.abbrevGroups = StructureCheckerHelper.getDefaultAbbrevgroups();
            }
            catch (IOException e) {
                this.abbrevGroups = new HashMap<String, Molecule>();
            }
        }
        Molecule mol = result.getMolecule();
        int count = mol.getAtomCount();
        for (int i = count - 1; i >= 0; --i) {
            MolAtom atom = mol.getAtom(i);
            if (!atom.isPseudo() || atom.getBondCount() != 1 || atom.getAliasstr() == null || !this.abbrevGroups.containsKey(atom.getAliasstr())) continue;
            Molecule abbrevGroupMol = this.abbrevGroups.get(atom.getAliasstr()).cloneMolecule();
            if (mol.getDim() != 0 && abbrevGroupMol.getDim() != mol.getDim()) {
                abbrevGroupMol.clean(mol.getDim(), null);
                this.abbrevGroups.put(atom.getAliasstr(), abbrevGroupMol);
            }
            SgroupAtom sgroupAtom = (SgroupAtom)abbrevGroupMol.getAtom(0);
            mol.add(sgroupAtom);
            mol.add(new MolBond(sgroupAtom, atom.getLigand(0), atom.getBond(0).getFlags()));
            sgroupAtom.setLocation(atom.getLocation());
            mol.removeBond(atom.getBond(0));
            mol.removeAtom(atom);
        }
        return true;
    }
}

