/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;
import chemaxon.struc.PeriodicSystem;

@Fixes(value={StructureCheckerErrorType.ALIAS, StructureCheckerErrorType.ALIAS_ATOM})
@FixerInfo(name="Convert to Atom", description="Converts to an atom.", actionStringToken="aliastoatom")
public class ConvertToAtomFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        for (MolAtom atom : result.getAtoms()) {
            int atno = atom.getAliasstr().equals("*") ? 133 : PeriodicSystem.getAtomicNumber(atom.getAliasstr());
            if (atno == -1) continue;
            atom.setAliasstr(null);
            atom.setAtno(atno);
        }
        return true;
    }
}

