/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;

@Fixes(value={StructureCheckerErrorType.STAR, StructureCheckerErrorType.PSEUDO, StructureCheckerErrorType.PSEUDO_NO_GROUP})
@FixerInfo(name="Convert to Carbon", description="Converts atom to carbon atom.", actionStringToken="aliastocarbon")
public class ConvertToCarbonFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        for (MolAtom atom : result.getAtoms()) {
            atom.setAliasstr(null);
            atom.setAtno(6);
        }
        return true;
    }
}

