/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.Molecule;

@Fixes(value={StructureCheckerErrorType.CROSSED_DOUBLE_BOND})
@FixerInfo(name="Convert to Wiggly Double Bond", description="Converts unspecified double bond representation from crossed double bond symbol to wiggly bonded ligand bond.", actionStringToken="crossedtowiggly")
public class CrossedDoubleBondFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        Molecule molecule = result.getMolecule();
        if (molecule.getDim() == 0) {
            molecule.clean(2, null);
        }
        CleanUtil.setCTWigglyBond(molecule);
        return true;
    }
}

