/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.ExplicitHydrogenResult;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;

@Fixes(value={StructureCheckerErrorType.EXPLICIT_H})
@FixerInfo(name="Remove Explicit Hydrogen", description="Removes explicit hydrogens.", actionStringToken="removeexplicith")
public class ExplicitHydrogenFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        if (result instanceof ExplicitHydrogenResult) {
            result.getMolecule().implicitizeHydrogens(((ExplicitHydrogenResult)result).getImplicitizeFlag());
        } else {
            result.getMolecule().implicitizeHydrogens(2047);
        }
        return true;
    }
}

