/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.Molecule;

@Fixes(value={StructureCheckerErrorType.MISSING_ATOM_MAP})
@FixerInfo(name="Map Atoms", description="Maps the atoms of the structure.", actionStringToken="mapmolecule")
public class MapMoleculeFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        Molecule molecule = result.getMolecule();
        for (int i = 0; i < molecule.getAtomCount(); ++i) {
            molecule.getAtom(i).setAtomMap(i + 1);
        }
        return true;
    }
}

