/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.marvin.modules.AutoMapper;
import chemaxon.marvin.modules.AutoMapperException;
import chemaxon.struc.RxnMolecule;

@Fixes(value={StructureCheckerErrorType.INVALID_REACTION_MAP})
@FixerInfo(name="Map Reaction", description="Maps the corresponding atoms of the reaction scheme.", actionStringToken="mapreaction")
public class MapReactionFixer
extends AbstractStructureFixer {
    private final AutoMapper mapper = new AutoMapper();

    public MapReactionFixer() {
        this.mapper.setMappingStyle(2);
    }

    @Override
    public boolean fix(StructureCheckerResult result) {
        try {
            RxnMolecule reaction = RxnMolecule.getReaction(result.getMolecule());
            if (reaction != null) {
                this.mapper.map(reaction);
            }
        }
        catch (AutoMapperException e) {
            return false;
        }
        return true;
    }
}

