/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;

@Fixes(value={StructureCheckerErrorType.MOLECULE_CHARGE})
@FixerInfo(name="Neutralize", description="Neutralizes the structure by removing the corresponding explicit hydrogens or modifying charges.", actionStringToken="neutralize")
public class NeutralizeChargeFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        for (MolAtom atom : result.getAtoms()) {
            int oldCharge = atom.getCharge();
            atom.setCharge(0);
            atom.valenceCheck();
            if (!atom.hasValenceError()) continue;
            atom.setCharge(oldCharge);
            return false;
        }
        return true;
    }
}

