/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;

@Fixes(value={StructureCheckerErrorType.ALIAS, StructureCheckerErrorType.ALIAS_ATOM, StructureCheckerErrorType.ALIAS_GROUP, StructureCheckerErrorType.ALIAS_NONE})
@FixerInfo(name="Remove Alias", description="Removes atom alias.", actionStringToken="removealias")
public class RemoveAliasFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        boolean succed = true;
        for (MolAtom atom : result.getAtoms()) {
            atom.setAliasstr(null);
            atom.valenceCheck();
            succed &= !atom.hasValenceError();
        }
        return succed;
    }
}

