/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;

@Fixes(value={StructureCheckerErrorType.QUERY_BOND, StructureCheckerErrorType.INVALID_COORD_SYSTEM})
@FixerInfo(name="Delete Bond", description="Deletes bond.", actionStringToken="removebond")
public class RemoveBondFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        Molecule molecule = result.getMolecule();
        for (MolBond molBond : result.getBonds()) {
            molecule.removeBond(molBond);
        }
        return true;
    }
}

