/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;

@Fixes(value={StructureCheckerErrorType.RADICAL})
@FixerInfo(name="Remove Radical", description="Removes radical atom.", actionStringToken="removeradical")
public class RemoveRadicalFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        for (MolAtom atom : result.getAtoms()) {
            int oldRadical = atom.getRadical();
            atom.setRadical(0);
            atom.valenceCheck();
            if (!atom.hasValenceError()) continue;
            atom.setRadical(oldRadical);
            return false;
        }
        return true;
    }
}

