/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolBond;
import java.util.List;

@Fixes(value={StructureCheckerErrorType.STEREO_CARE_BOX, StructureCheckerErrorType.QUERY_BOND})
@FixerInfo(name="Remove Stereo Care Box", description="Removes stereo care box from bond", actionStringToken="removestereocarebox")
public class RemoveStereoCareBoxFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        List<MolBond> bonds = result.getBonds();
        for (MolBond bond : bonds) {
            bond.setFlags(bond.getFlags() & 0xFFFFFDFF);
        }
        return true;
    }
}

