/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;

@Fixes(value={StructureCheckerErrorType.VALENCE_PROPERTY})
@FixerInfo(name="Remove Valence Property", description="Removes valence property.", actionStringToken="removevalenceproperty")
public class RemoveValencePropertyFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        for (MolAtom atom : result.getAtoms()) {
            atom.setValenceProp(-1);
        }
        return false;
    }
}

