/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

@Fixes(value={StructureCheckerErrorType.VALENCE})
@FixerInfo(name="Fix Valence", description="Sets hydrogens and charges to correct valence error.", actionStringToken="fixvalence")
public class ValenceFixer
extends AbstractStructureFixer {
    private static final int CHARGE_CORRECTION_LIMIT = 2;

    @Override
    public boolean fix(StructureCheckerResult result) {
        boolean fixSucceed = true;
        Molecule mol = result.getMolecule();
        ArrayList<MolAtom> removableAtoms = new ArrayList<MolAtom>();
        for (MolAtom atom : result.getAtoms()) {
            Integer index = mol.indexOf(atom);
            int[][] ctab = mol.getCtab();
            for (int i = 0; i < ctab[index].length; ++i) {
                if (mol.getAtom(ctab[index][i]).getAtno() != 1) continue;
                removableAtoms.add(mol.getAtom(ctab[index][i]));
            }
        }
        for (MolAtom molAtom : removableAtoms) {
            mol.removeAtom(molAtom);
        }
        for (MolAtom molAtom : result.getAtoms()) {
            if (molAtom.getAtno() != 7) continue;
            molAtom.valenceCheck();
            int originalCharge = molAtom.getCharge();
            for (int i = 1; i < 2 && molAtom.hasValenceError(); ++i) {
                if (molAtom.hasValenceError()) {
                    molAtom.setCharge(originalCharge + 1 * i);
                    molAtom.valenceCheck();
                }
                if (!molAtom.hasValenceError()) continue;
                molAtom.setCharge(originalCharge - 1 * i);
                molAtom.valenceCheck();
            }
            if (!molAtom.hasValenceError()) continue;
            molAtom.setCharge(originalCharge);
        }
        for (MolAtom molAtom : result.getAtoms()) {
            molAtom.valenceCheck();
            fixSucceed &= !mol.hasValenceError();
        }
        return fixSucceed;
    }
}

