/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.struc.MolBond;

@Fixes(value={StructureCheckerErrorType.INVALID_WEDGE})
@FixerInfo(name="Clean Wedge", description="Recalculates the layout of stereo wedge bonds.", actionStringToken="wedgeclean")
public class WedgeCleanFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        for (MolBond bond : result.getBonds()) {
            if ((result.getMolecule().getParity(result.getMolecule().indexOf(bond.getAtom1())) & 7) != 0) continue;
            bond.swap();
        }
        return result.getMolecule().stereoClean();
    }
}

