/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fixers;

import chemaxon.checkers.StructureCheckerErrorType;
import chemaxon.checkers.result.StructureCheckerResult;
import chemaxon.fixers.AbstractStructureFixer;
import chemaxon.fixers.FixerInfo;
import chemaxon.fixers.Fixes;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.struc.Molecule;

@Fixes(value={StructureCheckerErrorType.WIGGLY})
@FixerInfo(name="Convert to Crossed Double Dond", description="Converts unspecified double bond representation from bonded ligand symbol to crossed double bond.", actionStringToken="converttocrosseddoublebond")
public class WigglyDoubleBondFixer
extends AbstractStructureFixer {
    @Override
    public boolean fix(StructureCheckerResult result) {
        Molecule molecule = result.getMolecule();
        if (molecule.getDim() == 0) {
            molecule.clean(2, null);
        }
        CleanUtil.setCTCrossedBond(molecule);
        return true;
    }
}

