/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.struc.Molecule;

public class FastMdlImport {
    private byte[] moldata;
    private StringBuffer mysbuf = new StringBuffer();
    private int offset;
    private int eolen;

    public synchronized void initMolImport(byte[] data) {
        this.moldata = data;
        this.offset = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean readMol(Molecule mol) {
        byte[] data = this.moldata;
        byte eol = 10;
        mol.clearForImport("mol");
        this.eolen = 1;
        byte[] byArray = data;
        synchronized (data) {
            int pos;
            for (pos = this.offset; pos < data.length && data[pos] != 10 && data[pos] != 13; ++pos) {
            }
            if (pos >= data.length) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return false;
            }
            eol = data[pos];
            if ((data[pos + 1] == 10 || data[pos + 1] == 13) && data[pos + 1] != eol) {
                this.eolen = 2;
            }
            mol.setName(new String(data, 0, this.offset, pos - this.offset));
            while (pos < data.length && data[pos] != eol) {
                ++pos;
            }
            if (pos >= data.length) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return false;
            }
            while (pos < data.length && data[pos] != eol) {
                ++pos;
            }
            if (pos >= data.length) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return false;
            }
            this.offset = pos + this.eolen;
            int na = this.rdcount();
            int nb = this.rdcount();
            int nl = this.rdcount();
            if (na < 0 || nb < 0 || nl < 0) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return false;
            }
            pos = this.offset;
            while (data[pos] != eol) {
                ++pos;
            }
            this.offset = pos + this.eolen;
            this.atomblock(mol, na, eol);
            this.bondblock(mol, nb, eol);
            this.propsblock(mol, eol);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return true;
        }
    }

    private void atomblock(Molecule mol, int na, int eol) {
        byte[] data = this.moldata;
        for (int i = 0; i < na; ++i) {
            int pos = this.offset;
            while (data[pos] != eol) {
            }
            int nextlineoff = ++pos + this.eolen;
            int linelen = pos - this.offset;
            pos = this.offset;
            if (linelen == 10 || linelen == 14) {
                // empty if block
            }
            this.offset = nextlineoff;
        }
    }

    private void bondblock(Molecule mol, int nb, int eol) {
        byte[] data = this.moldata;
        for (int i = 0; i < nb; ++i) {
            int pos = this.offset;
            while (data[pos] != eol) {
            }
            int nextlineoff = ++pos + this.eolen;
            pos = pos == this.offset + 5 ? this.offset : this.offset;
            this.offset = nextlineoff;
        }
    }

    private void propsblock(Molecule mol, int eol) {
        byte[] data = this.moldata;
    }

    private int rdcount() {
        int n = -48;
        int i = this.offset;
        byte[] data = this.moldata;
        if (i >= data.length) {
            return -1;
        }
        if (data[i] >= 48 && data[i] < 58) {
            n = 100 * (data[i] - 48);
        } else if (data[i] != 32) {
            return -1;
        }
        if (++i >= data.length) {
            return -1;
        }
        if (data[i] >= 48 && data[i] < 58) {
            n += 10 * (data[i] - 48);
        } else if (data[i] != 32) {
            return -1;
        }
        if (++i >= data.length || data[i] < 48 || data[i] >= 58) {
            return -1;
        }
        this.offset = i + 1;
        return n += data[i];
    }

    private int rdint() {
        int n = -48;
        byte[] data = this.moldata;
        int i = this.offset;
        if (data[i] >= 48) {
            n = 100 * (data[i] - 48);
        }
        if (data[++i] >= 48) {
            n += 10 * (data[i] - 48);
        }
        this.offset = i + 1;
        return n + data[++i];
    }
}

