/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.formats.recognizer.Recognizer;
import chemaxon.license.LicenseException;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.util.text.LocaleUtil;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class MFileFormat {
    public static final MFileFormat MRV;
    public static final MFileFormat CML;
    public static final MFileFormat MOL;
    public static final MFileFormat MOL_V3_OUT;
    public static final MFileFormat RXN;
    public static final MFileFormat RXN_V3_OUT;
    public static final MFileFormat SDF;
    public static final MFileFormat RDF;
    public static final MFileFormat CHIME;
    public static final MFileFormat JTF;
    public static final MFileFormat CSMDL_IN;
    public static final MFileFormat CSMOL_OUT;
    public static final MFileFormat CSRXN_OUT;
    public static final MFileFormat CSSDF_OUT;
    public static final MFileFormat CSRDF;
    public static final MFileFormat SMILES;
    public static final MFileFormat SMARTS;
    public static final MFileFormat CXSMILES;
    public static final MFileFormat CXSMARTS;
    public static final MFileFormat ABBREVGROUP;
    public static final MFileFormat INCHI;
    public static final MFileFormat INCHIKEY;
    public static final MFileFormat NAME;
    public static final MFileFormat PEPTIDE_IN;
    public static final MFileFormat PEPTIDE1_OUT;
    public static final MFileFormat PEPTIDE3_OUT;
    public static final MFileFormat RNA;
    public static final MFileFormat DNA;
    public static final MFileFormat XYZ;
    public static final MFileFormat GAUSSIAN_CUBE;
    public static final MFileFormat GAUSSIAN_INPUT;
    public static final MFileFormat GAUSSIAN_INPUTZ;
    public static final MFileFormat GAUSSIAN_OUTPUT;
    public static final MFileFormat SYBYLMOL;
    public static final MFileFormat MOL2;
    public static final MFileFormat PDB;
    public static final MFileFormat GZIP;
    public static final MFileFormat BASE64;
    public static final MFileFormat AWT_IMAGE;
    public static final MFileFormat JPEG;
    public static final MFileFormat PNG;
    public static final MFileFormat PPM;
    public static final MFileFormat MSBMP;
    public static final MFileFormat PDF;
    public static final MFileFormat SVG;
    public static final MFileFormat EMF;
    public static final MFileFormat POVRAY;
    public static final MFileFormat OSRA;
    public static final MFileFormat CDX;
    public static final MFileFormat CDXML;
    public static final MFileFormat VMN;
    public static final MFileFormat D2S;
    public static final long F_EXPORT = 1L;
    public static final long F_IMPORT = 2L;
    public static final long F_RECOGNIZER = 4L;
    public static final long F_BINARY = 8L;
    public static final long F_OBJECT = 16L;
    public static final long F_MOLECULE = 32L;
    public static final long F_REACTION = 64L;
    public static final long F_ARCHIVE = 128L;
    public static final long F_GRAPHICS = 256L;
    public static final long F_IMAGE = 512L;
    public static final long F_COORDS = 1024L;
    public static final long F_MULTIPLE_RECORDS_LEGAL = 2048L;
    public static final long F_MULTIPLE_RECORDS_POSSIBLE = 4096L;
    public static final long F_MIXED = 8192L;
    public static final long F_XML = 16384L;
    public static final long F_USER_DEFINED = 32768L;
    public static final long F_SINGLE_LINE = 65536L;
    private static final long DEFAULT_0D_FLAGS = 6179L;
    private static final long DEFAULT_MOL_FLAGS = 7203L;
    private static final long DEFAULT_RXN_FLAGS = 7235L;
    private static final long DEFAULT_IMAGE_FLAGS = 1897L;
    private String[] formats;
    private String description;
    private String[] extensions;
    private String mimeType;
    private String recordReaderName;
    private String importModuleName;
    private String exportModuleName;
    private String recognizerModuleName;
    private MFileFormat queryFormat;
    private MFileFormat nonQueryFormat;
    private Map<String, Integer> subformatPriorities;
    long flags;

    public MFileFormat(String desc, String format2, String mime, String exts, String rrname, String impname, String expname, String recogn, long f) {
        this.description = desc;
        StringTokenizer st = new StringTokenizer(format2);
        this.formats = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            this.formats[i] = st.nextToken();
            ++i;
        }
        if (exts != null) {
            st = new StringTokenizer(exts, " ");
            this.extensions = new String[st.countTokens()];
            for (i = 0; i < this.extensions.length; ++i) {
                this.extensions[i] = st.nextToken();
            }
        } else {
            this.extensions = new String[0];
        }
        this.recordReaderName = rrname;
        this.importModuleName = impname;
        this.exportModuleName = expname;
        this.subformatPriorities = new HashMap<String, Integer>();
        if (recogn != null) {
            st = new StringTokenizer(recogn, " ");
            this.recognizerModuleName = st.nextToken();
            while (st.hasMoreTokens()) {
                int p;
                String tok = st.nextToken();
                String subfmt = this.formats[0];
                int eq = tok.lastIndexOf(61);
                if (eq >= 0) {
                    subfmt = tok.substring(0, eq);
                    if (!this.matches(subfmt, 0L, 0L)) {
                        throw new IllegalArgumentException("Unknown subformat \"" + subfmt + "\"");
                    }
                    p = Integer.parseInt(tok.substring(eq + 1));
                } else {
                    p = Integer.parseInt(tok);
                }
                this.subformatPriorities.put(subfmt, new Integer(p));
            }
        } else {
            this.recognizerModuleName = null;
            this.subformatPriorities.put(format2, new Integer(10));
        }
        if (recogn != null) {
            f |= 4L;
        }
        this.flags = f;
    }

    private MFileFormat(ResourceBundle rc, String format2, String mime, String exts, String rrname, String impname, String expname, String recogn, long f) {
        this(rc.getString(MFileFormat.formatKey(format2) + ".name"), format2, mime, exts, rrname, impname, expname, recogn, f);
    }

    public String getName() {
        return this.formats[0];
    }

    public String[] getNames() {
        String[] arr = new String[this.formats.length];
        System.arraycopy(this.formats, 0, arr, 0, arr.length);
        return arr;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getExtensions() {
        String[] exts = this.extensions;
        String[] x = new String[exts.length];
        System.arraycopy(exts, 0, x, 0, x.length);
        return x;
    }

    public String getMIMEType() {
        return this.mimeType;
    }

    public long getFlags() {
        return this.flags;
    }

    public MFileFormat getAssociatedQueryFormat() {
        return this.queryFormat;
    }

    public MFileFormat getAssociatedNonQueryFormat() {
        return this.nonQueryFormat;
    }

    public int getPriority(String subfmt) {
        Integer p;
        if (subfmt == null) {
            subfmt = this.getName();
        }
        if ((p = this.subformatPriorities.get(subfmt)) == null) {
            throw new IllegalArgumentException("Priority of subformat \"" + subfmt + "\" not defined in " + this.toString());
        }
        return p;
    }

    public boolean matches(String fmt, long f, long mask) {
        if ((this.flags & mask) != (f & mask)) {
            return false;
        }
        if (fmt == null) {
            return true;
        }
        assert (fmt != null);
        for (String format2 : this.formats) {
            if (!fmt.equalsIgnoreCase(format2)) continue;
            return true;
        }
        return false;
    }

    public boolean isFlagSet(long flag) {
        return (this.flags & flag) == flag;
    }

    public MRecordReader createRecordReader(MolInputStream mis, String opts) throws MolFormatException {
        Constructor<?> constr;
        Class<?> cl = null;
        try {
            cl = this.recordReaderName != null ? Class.forName(this.recordReaderName) : null;
        }
        catch (ClassNotFoundException ex) {
            throw new MolFormatException("Cannot create record reader for " + this.description + ": class " + this.recordReaderName + " not found", ex);
        }
        if (cl == null) {
            return null;
        }
        try {
            constr = cl.getConstructor(InputStream.class, String.class);
        }
        catch (NoSuchMethodException ex) {
            throw new MolFormatException("Cannot create record reader for " + this.description + ": class " + cl.getName() + " has no valid constructor", ex);
        }
        try {
            return (MRecordReader)constr.newInstance(mis, opts);
        }
        catch (InstantiationException ex) {
            throw new MolFormatException("Cannot create record reader for " + this.description + ": class " + cl.getName() + " cannot be instantiated", ex);
        }
        catch (IllegalAccessException ex) {
            throw new MolFormatException("Cannot create record reader for " + this.description + ": access to the constructor of " + "class " + cl.getName() + " is illegal", ex);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getTargetException();
            if (t instanceof IllegalCharsetNameException) {
                throw (IllegalCharsetNameException)t;
            }
            if (t instanceof UnsupportedCharsetException) {
                throw (UnsupportedCharsetException)t;
            }
            if (t instanceof LicenseException) {
                throw (LicenseException)t;
            }
            throw new MolFormatException("Cannot create record reader for " + this.description, ex.getTargetException());
        }
    }

    public MolImportModule createImportModule() throws MolFormatException {
        Class<?> cl = null;
        try {
            cl = this.importModuleName != null ? Class.forName(this.importModuleName) : null;
        }
        catch (ClassNotFoundException ex) {
            throw new MolFormatException("Cannot import " + this.description + ": class " + this.importModuleName + " not found", ex);
        }
        if (cl == null) {
            return null;
        }
        try {
            return (MolImportModule)cl.newInstance();
        }
        catch (InstantiationException ex) {
            throw new MolFormatException("Cannot import " + this.description + ": class " + cl.getName() + " cannot be instantiated", ex);
        }
        catch (IllegalAccessException ex) {
            throw new MolFormatException("Cannot import " + this.description + ": access to the constructor of " + "class " + cl.getName() + " is illegal", ex);
        }
    }

    public MolExportModule createExportModule() throws MolExportException {
        Class<?> cl = null;
        try {
            cl = this.exportModuleName != null ? Class.forName(this.exportModuleName) : null;
        }
        catch (ClassNotFoundException ex) {
            throw new MolExportException("Cannot export " + this.description + ": class " + this.exportModuleName + " not found", ex);
        }
        if (cl == null) {
            return null;
        }
        try {
            return (MolExportModule)cl.newInstance();
        }
        catch (InstantiationException ex) {
            throw new MolExportException("Cannot export " + this.description + ": class " + cl.getName() + " cannot be instantiated", ex);
        }
        catch (IllegalAccessException ex) {
            throw new MolExportException("Cannot export " + this.description + ": access to the constructor of " + "class " + cl.getName() + " is illegal", ex);
        }
    }

    public Recognizer createRecognizer(String fmt) throws MolFormatException {
        Class<?> cl;
        if (this.recognizerModuleName == null) {
            return null;
        }
        String clname = this.recognizerModuleName;
        try {
            cl = Class.forName(clname);
        }
        catch (ClassNotFoundException ex) {
            throw new MolFormatException("Cannot create recognizer for " + this.description + ": class " + this.recognizerModuleName + " not found", ex);
        }
        try {
            Constructor<?> constr = cl.getConstructor(String.class);
            return (Recognizer)constr.newInstance(fmt);
        }
        catch (NoSuchMethodException ex) {
            throw new MolFormatException("Cannot create recognizer for " + this.description + ": class " + cl.getName() + " has no valid constructor", ex);
        }
        catch (InstantiationException ex) {
            throw new MolFormatException("Cannot create recognizer for " + this.description + ": class " + cl.getName() + " cannot be instantiated", ex);
        }
        catch (IllegalAccessException ex) {
            throw new MolFormatException("Cannot create recognizer for " + this.description + ": access to the constructor of " + "class " + cl.getName() + " is illegal", ex);
        }
        catch (InvocationTargetException ex) {
            throw new MolFormatException("Cannot create recognizer for " + this.description, ex.getTargetException());
        }
    }

    public String toString() {
        String s = super.toString();
        int i = s.lastIndexOf(46);
        StringBuffer sb = new StringBuffer(i >= 0 ? s.substring(i + 1) : s);
        sb.append('[');
        for (int j = 0; j < this.formats.length; ++j) {
            if (j != 0) {
                sb.append(',');
            }
            sb.append(this.formats[j]);
        }
        sb.append(']');
        return sb.toString();
    }

    private static String formatKey(String format2) {
        int i = format2.indexOf(32);
        if (i > 0) {
            format2 = format2.substring(0, i);
        }
        return format2.replaceAll(":", "_");
    }

    static {
        ResourceBundle rc = LocaleUtil.getResourceBundle(MFileFormat.class.getName(), null);
        MRV = new MFileFormat(rc, "mrv", null, "mrv", "chemaxon.marvin.io.formats.cml.CMLRecordReader", "chemaxon.marvin.io.formats.cml.MrvImport", "chemaxon.marvin.io.formats.cml.MrvExport", "chemaxon.formats.recognizer.CMLRecognizer 10", 23651L);
        CML = new MFileFormat(rc, "cml", "chemical/x-cml", "cml", "chemaxon.marvin.io.formats.cml.CMLRecordReader", "chemaxon.marvin.io.formats.cml.CMLImport", "chemaxon.marvin.io.formats.cml.CMLExport", "chemaxon.formats.recognizer.CMLRecognizer 10", 23651L);
        MOL = new MFileFormat(rc, "mol rgf mol:V3", "chemical/x-mdl-molfile", "mol", "chemaxon.marvin.io.formats.mdl.MolRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", "chemaxon.formats.recognizer.MDLRecognizer mol=10 rgf=10 mol:V3=14", 5155L);
        MOL_V3_OUT = new MFileFormat(rc, "mol:V3", "chemical/x-mdl-molfile", "mol", "chemaxon.marvin.io.formats.mdl.MolRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", null, 5153L);
        RXN = new MFileFormat(rc, "rxn rxn:V3", "chemical/x-mdl-rxnfile", "rxn", "chemaxon.marvin.io.formats.mdl.MolRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", "chemaxon.formats.recognizer.MDLRecognizer rxn=10 rxn:V3=14", 5187L);
        RXN_V3_OUT = new MFileFormat(rc, "rxn:V3", "chemical/x-mdl-rxnfile", "rxn", "chemaxon.marvin.io.formats.mdl.MolRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", null, 5185L);
        SDF = new MFileFormat(rc, "sdf", "chemical/x-mdl-sdfile", "sdf sd", "chemaxon.marvin.io.formats.mdl.MolRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", "chemaxon.formats.recognizer.MDLRecognizer sdf=11", 15395L);
        RDF = new MFileFormat(rc, "rdf", "chemical/x-mdl-rdfile", "rdf rd", "chemaxon.marvin.io.formats.mdl.RDfileRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", "chemaxon.formats.recognizer.RDfileRecognizer 10", 15459L);
        CHIME = new MFileFormat(rc, "chime", null, "chime", null, null, null, "chemaxon.formats.recognizer.ChimeRecognizer 40", 1056L);
        JTF = new MFileFormat(rc, "jtf", null, "jtf", "chemaxon.marvin.io.formats.jtf.JTFRecordReader", "chemaxon.marvin.io.formats.jtf.JTFImport", null, "chemaxon.formats.recognizer.JTFRecognizer 10", 80994L);
        CSMDL_IN = new MFileFormat(rc, "csmdl csmol csrxn cssdf", null, "csmol csrxn cssdf t", "chemaxon.marvin.io.formats.mdl.MolRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", "chemaxon.formats.recognizer.MDLRecognizer csmol=12 csrxn=12 cssdf=13 csmdl=14", 7202L);
        CSMOL_OUT = new MFileFormat(rc, "csmol", null, "csmol", "chemaxon.marvin.io.formats.mdl.MolRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", null, 5153L);
        CSRXN_OUT = new MFileFormat(rc, "csrxn", null, "csrxn", "chemaxon.marvin.io.formats.mdl.MolRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", null, 5185L);
        CSSDF_OUT = new MFileFormat(rc, "cssdf", null, "cssdf t", "chemaxon.marvin.io.formats.mdl.MolRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", null, 15393L);
        CSRDF = new MFileFormat(rc, "csrdf", null, "csrdf", "chemaxon.marvin.io.formats.mdl.RDfileRecordReader", "chemaxon.marvin.io.formats.mdl.MolImport", "chemaxon.marvin.io.formats.mdl.MolExport", "chemaxon.formats.recognizer.RDfileRecognizer 11", 15459L);
        SMILES = new MFileFormat(rc, "smiles", "chemical/x-daylight-smiles", "smiles smi", "chemaxon.marvin.io.formats.smiles.SMILESRecordReader", "chemaxon.marvin.io.formats.smiles.SmilesImport", "chemaxon.marvin.io.formats.smiles.SmilesExport", "chemaxon.formats.recognizer.SMILESRecognizer 0", 71779L);
        MFileFormat.SMILES.queryFormat = SMARTS = new MFileFormat(rc, "smarts", null, "smarts sma", "chemaxon.marvin.io.formats.smiles.SMILESRecordReader", "chemaxon.marvin.io.formats.smiles.SmilesImport", "chemaxon.marvin.io.formats.smiles.SmilesExport", "chemaxon.formats.recognizer.SMILESRecognizer 1", 71779L);
        MFileFormat.SMARTS.nonQueryFormat = SMILES;
        CXSMILES = new MFileFormat(rc, "cxsmiles", null, "cxsmiles cxsmi", "chemaxon.marvin.io.formats.smiles.SMILESRecordReader", "chemaxon.marvin.io.formats.smiles.CxsmilesImport", "chemaxon.marvin.io.formats.smiles.CxsmilesExport", "chemaxon.formats.recognizer.SMILESRecognizer 2", 71779L);
        MFileFormat.CXSMILES.queryFormat = CXSMARTS = new MFileFormat(rc, "cxsmarts", null, "cxsmarts cxsma", "chemaxon.marvin.io.formats.smiles.SMILESRecordReader", "chemaxon.marvin.io.formats.smiles.CxsmilesImport", "chemaxon.marvin.io.formats.smiles.CxsmilesExport", "chemaxon.formats.recognizer.SMILESRecognizer 3", 71779L);
        MFileFormat.CXSMARTS.nonQueryFormat = CXSMILES;
        ABBREVGROUP = new MFileFormat(rc, "abbrevgroup", null, "abbrevgroup", "chemaxon.marvin.io.formats.SingleLineRecordReader", "chemaxon.marvin.io.formats.abbrevgroup.AbbrevGroupImport", "chemaxon.marvin.io.formats.abbrevgroup.AbbrevGroupExport", "chemaxon.formats.recognizer.AbbrevGroupRecognizer 10", 71715L);
        INCHI = new MFileFormat(rc, "inchi", "chemical/x-inchi", "inchi", "chemaxon.marvin.io.formats.inchi.InchiRecordReader", "chemaxon.marvin.io.formats.inchi.InchiImport", "chemaxon.marvin.io.formats.inchi.InchiExport", "chemaxon.formats.recognizer.InchiRecognizer 10", 71715L);
        INCHIKEY = new MFileFormat(rc, "inchikey", null, "inchikey", null, null, "chemaxon.marvin.io.formats.inchi.InchikeyExport", null, 7201L);
        NAME = new MFileFormat(rc, "name", null, "name", "chemaxon.marvin.io.formats.SingleLineRecordReader", "chemaxon.marvin.io.formats.name.NameImport", "chemaxon.marvin.io.formats.name.NameExport", "chemaxon.formats.recognizer.NameRecognizer 30", 71715L);
        PEPTIDE_IN = new MFileFormat(rc, "peptide peptide:1 peptide:3", null, "seq", "chemaxon.marvin.io.formats.SingleLineRecordReader", "chemaxon.marvin.io.formats.peptide.PeptideImport", "chemaxon.marvin.io.formats.peptide.PeptideExport", "chemaxon.formats.recognizer.PeptideRecognizer peptide:1=10 peptide:3=10 peptide=11", 71714L);
        PEPTIDE1_OUT = new MFileFormat(rc, "peptide:1", null, "seq", "chemaxon.marvin.io.formats.SingleLineRecordReader", "chemaxon.marvin.io.formats.peptide.PeptideImport", "chemaxon.marvin.io.formats.peptide.PeptideExport", null, 71713L);
        PEPTIDE3_OUT = new MFileFormat(rc, "peptide:3", null, "seq", "chemaxon.marvin.io.formats.SingleLineRecordReader", "chemaxon.marvin.io.formats.peptide.PeptideImport", "chemaxon.marvin.io.formats.peptide.PeptideExport", null, 71713L);
        RNA = new MFileFormat(rc, "rna", null, "rna", "chemaxon.marvin.io.formats.SingleLineRecordReader", "chemaxon.marvin.io.formats.NucleicAcidImport", null, "chemaxon.formats.recognizer.NucleicAcidRecognizer 10", 71714L);
        DNA = new MFileFormat(rc, "dna", null, "dna", "chemaxon.marvin.io.formats.SingleLineRecordReader", "chemaxon.marvin.io.formats.NucleicAcidImport", null, "chemaxon.formats.recognizer.NucleicAcidRecognizer 10", 71714L);
        XYZ = new MFileFormat(rc, "xyz", "chemical/x-xyz", "xyz", "chemaxon.marvin.io.formats.xyz.XYZRecordReader", "chemaxon.marvin.io.formats.xyz.XYZImport", "chemaxon.marvin.io.formats.xyz.XYZExport", "chemaxon.formats.recognizer.XYZRecognizer 10", 7203L);
        GAUSSIAN_CUBE = new MFileFormat(rc, "cube", "chemical/x-gaussian-cube", "cube cub", "chemaxon.marvin.io.formats.gaussian.CubeRecordReader", "chemaxon.marvin.io.formats.gaussian.CubeImport", "chemaxon.marvin.io.formats.gaussian.CubeExport", "chemaxon.formats.recognizer.CubeRecognizer 10", 5155L);
        GAUSSIAN_INPUT = new MFileFormat(rc, "gjf", "chemical/x-gaussian-input", "gjf com", null, null, "chemaxon.marvin.io.formats.gaussian.GjfExport", null, 7201L);
        GAUSSIAN_INPUTZ = new MFileFormat(rc, "gjfz", "chemical/x-gaussian-input", "gjfz", null, null, "chemaxon.marvin.io.formats.gaussian.GjfZExport", null, 7201L);
        GAUSSIAN_OUTPUT = new MFileFormat(rc, "gout", "chemical/x-gaussian-output", "log out gout", "chemaxon.marvin.io.formats.gaussian.GoutRecordReader", "chemaxon.marvin.io.formats.gaussian.GoutImport", null, "chemaxon.formats.recognizer.GoutRecognizer 20", 7202L);
        SYBYLMOL = new MFileFormat(rc, "sybyl", null, "mol sybyl syb", "chemaxon.marvin.io.formats.tripos.SybylRecordReader", "chemaxon.marvin.io.formats.tripos.SybylImport", "chemaxon.marvin.io.formats.tripos.SybylExport", "chemaxon.formats.recognizer.SybylRecognizer 10", 7203L);
        MOL2 = new MFileFormat(rc, "mol2", "chemical/x-mol2", "mol2", "chemaxon.marvin.io.formats.tripos.Mol2RecordReader", "chemaxon.marvin.io.formats.tripos.Mol2Import", "chemaxon.marvin.io.formats.tripos.Mol2Export", "chemaxon.formats.recognizer.Mol2Recognizer 10", 7203L);
        PDB = new MFileFormat(rc, "pdb", "chemical/x-pdb", "pdb", "chemaxon.marvin.io.formats.pdb.PDBRecordReader", "chemaxon.marvin.io.formats.pdb.PDBImport", "chemaxon.marvin.io.formats.pdb.PDBExport", "chemaxon.formats.recognizer.PDBRecognizer 10", 7203L);
        GZIP = new MFileFormat(rc, "gzip", "application/x-gzip", "gz", "chemaxon.marvin.io.formats.GzipRecordReader", "chemaxon.marvin.io.formats.GzipImport", "chemaxon.marvin.io.formats.GzipExport", null, 139L);
        BASE64 = new MFileFormat(rc, "base64", null, "b64 base64", "chemaxon.marvin.io.formats.base64.Base64RecordReader", "chemaxon.marvin.io.formats.base64.Base64Import", "chemaxon.marvin.io.formats.base64.Base64Export", "chemaxon.formats.recognizer.Base64Recognizer 40", 131L);
        AWT_IMAGE = new MFileFormat(rc, "image", null, null, null, null, "chemaxon.marvin.io.image.exporter.ImageExport", null, 1905L);
        JPEG = new MFileFormat(rc, "jpeg", "image/jpeg", "jpg jpeg", "chemaxon.marvin.io.image.recordreader.ImageRecordReader", "chemaxon.marvin.io.image.importer.JpegImport", "chemaxon.marvin.io.image.exporter.JpegExport", null, 1897L);
        PNG = new MFileFormat(rc, "png", "image/png", "png", "chemaxon.marvin.io.image.recordreader.ImageRecordReader", "chemaxon.marvin.io.image.importer.PngImport", "chemaxon.marvin.io.image.exporter.PngExport", null, 1897L);
        PPM = new MFileFormat(rc, "ppm", "image/x-portable-pixmap", "ppm", null, null, "chemaxon.marvin.io.image.exporter.PpmExport", null, 1897L);
        MSBMP = new MFileFormat(rc, "msbmp", "image/x-ms-bmp", "bmp", null, null, "chemaxon.marvin.io.image.exporter.MsbmpExport", null, 1897L);
        SVG = new MFileFormat(rc, "svg", "image/svg+xml", "svg svgz", "chemaxon.marvin.io.image.recordreader.ImageRecordReader", "chemaxon.marvin.io.image.importer.SvgImport", "chemaxon.marvin.io.formats.vectgraphics.SvgExport", "chemaxon.formats.recognizer.CMLRecognizer 10", 18273L);
        PDF = new MFileFormat(rc, "pdf", "application/pdf", "pdf", "chemaxon.marvin.io.formats.d2s.D2SRecordReader", "chemaxon.marvin.io.formats.d2s.D2SImportModule", "chemaxon.marvin.io.formats.vectgraphics.PdfExport", null, 6179L);
        EMF = new MFileFormat(rc, "emf", "image/emf", "emf", null, null, "chemaxon.marvin.io.formats.vectgraphics.EmfExport", null, 1897L);
        POVRAY = new MFileFormat(rc, "pov", null, "pov", null, null, "chemaxon.marvin.io.formats.PovExport", null, 1385L);
        OSRA = new MFileFormat(rc, "osraimage", null, "pdf ps gif bmp", "chemaxon.marvin.io.image.recordreader.ImageRecordReader", "chemaxon.marvin.io.image.importer.ImageImportModule", null, null, 1896L);
        CDX = new MFileFormat(rc, "cdx", "chemical/chemdraw", "cdx", "chemaxon.marvin.io.formats.cdx.CDXRecordReader", "chemaxon.marvin.io.formats.cdx.CDXImport", "chemaxon.marvin.io.formats.cdx.CDXExport", "chemaxon.formats.recognizer.CDXRecognizer 10", 1135L);
        CDXML = new MFileFormat(rc, "cdxml", "chemical/x-cdxml", "cdxml", "chemaxon.marvin.io.formats.cdxml.CDXMLRecordReader", "chemaxon.marvin.io.formats.cdxml.CDXMLImport", null, "chemaxon.formats.recognizer.CDXMLRecognizer 10", 17506L);
        VMN = new MFileFormat(rc, "vmn", "chemical/x-vmn", "vmn", "chemaxon.marvin.io.formats.vmn.VMNRecordReader", "chemaxon.marvin.io.formats.vmn.VMNImport", null, null, 10L);
        D2S = new MFileFormat(rc, "d2s", null, "doc docx odt ppt pptx xls xlsx html xhtml xml", "chemaxon.marvin.io.formats.d2s.D2SRecordReader", "chemaxon.marvin.io.formats.d2s.D2SImportModule", null, "chemaxon.marvin.io.formats.d2s.D2SRecognizer 50", 6178L);
    }
}

