/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.formats.MolFormatException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MdlCompressor {
    public static int DECOMPRESS = 0;
    public static int COMPRESS = 1;
    public static int SDF = 2;
    public static int TEXTMODE = 4;
    private static final int[] ATNO_SYM = new int[729];
    private static final String[] ATSYM_DECODE = new String[116];
    private static final int[] DIGITS64U = new int[128];
    private static final char[] CHARS64 = new char[64];
    private LineNumberReader theReader;
    private int compressionFlags;
    private Writer theWriter = null;
    private List<String> head = new ArrayList<String>(1);
    private static String strhelp = "Fast MDL MOL/SDF/RGF/RXN compressor, (C) 1998-2012 ChemAxon Ltd.\n\nThis program converts MDL V1.0-V2.0 molfiles (*.mol, *.sdf, *.rgf) to\nMarvin's Compressed Molfile format (*.csmol, *.cssdf, *.csrgf). Examples:\n\nCompression\n    mdlcompress c file.mol > file.csmol           # read input from file\n    mdlcompress c < file.mol > file.csmol         # read input from STDIN\n\nDecompression\n    mdlcompress d file.csmol > file.mol           # read input from file\n    mdlcompress d < file.csmol > file.mol         # read input from STDIN\n\nNote that extended molfiles (V3.0) cannot be compressed.";

    public MdlCompressor(InputStream in, OutputStream out, int flags) {
        InputStreamReader isr = new InputStreamReader(in);
        this.theReader = new LineNumberReader(isr);
        this.compressionFlags = flags;
        this.theWriter = new BufferedWriter(new OutputStreamWriter(out));
    }

    private static int atoi(String s, int start, int end) {
        if (start >= s.length()) {
            return 0;
        }
        if (end > s.length()) {
            end = s.length();
        }
        return (s = s.substring(start, end).trim()).length() == 0 ? 0 : Integer.parseInt(s);
    }

    private static final void mitoa(int x, Writer out) throws IOException {
        String s = "  " + x;
        out.write(s.substring(s.length() - 3));
    }

    private static final int m6toi(String s, int l, int m) {
        int i = 0;
        for (int j = l; j < m; ++j) {
            char c = s.charAt(j);
            i |= DIGITS64U[c] << (j - l) * 6;
        }
        return i;
    }

    private static final void mftoa(double x, Writer out) throws IOException {
        double y = Math.abs(x);
        int a = (int)Math.round(y - 0.5);
        int b = (int)Math.round(10000.0 * (y - (double)a));
        String sb = "0000" + b;
        StringBuffer sbuf = new StringBuffer(String.valueOf(a));
        sbuf.append('.');
        sbuf.append(sb.substring(sb.length() - 4));
        String r = sbuf.toString();
        r = x < 0.0 ? "    -" + r : "     " + r;
        out.write(r.substring(r.length() - 10));
    }

    public boolean convert() throws IOException {
        String s;
        if (this.head.size() == 0) {
            s = this.theReader.readLine();
            if (s == null) {
                return false;
            }
            this.head.add(s);
        }
        s = this.head.get(0);
        boolean ret = true;
        if (s.startsWith("$MDL  REV")) {
            ret = this.convertRgf();
        } else if (s.equals("$RXN")) {
            ret = this.convertRxn();
        } else {
            Boolean[] args = new Boolean[1];
            if (!this.convertHeader()) {
                return false;
            }
            if (!this.convertCtab(args)) {
                return false;
            }
            this.convertEnd(args);
        }
        this.theWriter.flush();
        return ret;
    }

    private boolean convertRgf() throws IOException {
        int i;
        String[] lines = new String[3];
        for (i = 0; i < 3; ++i) {
            String s;
            if (i < this.head.size()) {
                s = this.head.get(0);
                this.head.remove(0);
            } else {
                s = this.theReader.readLine();
            }
            lines[i] = s;
            if (lines[i] != null) continue;
            return false;
        }
        if (!lines[0].startsWith("$MDL  REV")) {
            return false;
        }
        if (!lines[1].equals("$MOL") || !lines[2].equals("$HDR")) {
            throw new IOException("Not in MDL RGfile format");
        }
        for (i = 0; i < 3; ++i) {
            this.theWriter.write(lines[i]);
            this.theWriter.write(10);
        }
        this.convertHeader();
        for (i = 0; i < 2; ++i) {
            lines[i] = this.theReader.readLine();
            if (lines[i] != null) continue;
            throw new IOException("Unexpected end of RGfile");
        }
        if (!lines[0].equals("$END HDR") || !lines[1].equals("$CTAB")) {
            throw new IOException("Bad RGfile");
        }
        this.theWriter.write("$END HDR\n$CTAB\n");
        Boolean[] args = new Boolean[1];
        this.convertCtab(args);
        String l = this.theReader.readLine();
        if (l == null) {
            throw new IOException("Unexpected end of RGfile");
        }
        if (!l.equals("$END CTAB")) {
            throw new IOException("Bad RGfile");
        }
        this.theWriter.write("$END CTAB\n");
        l = this.theReader.readLine();
        while (l != null && l.equals("$RGP")) {
            this.theWriter.write("$RGP\n");
            l = this.theReader.readLine();
            if (l == null) {
                throw new IOException("Unexpected end of RGfile");
            }
            this.theWriter.write(l);
            this.theWriter.write(10);
            l = this.theReader.readLine();
            while (l != null && l.equals("$CTAB")) {
                this.theWriter.write("$CTAB\n");
                this.convertCtab(args);
                l = this.theReader.readLine();
                if (l != null && !l.equals("$END CTAB")) {
                    throw new IOException("Bad RGfile");
                }
                this.theWriter.write("$END CTAB\n");
                l = this.theReader.readLine();
            }
            if (l == null) {
                throw new IOException("Unexpected end of RGfile");
            }
            if (!l.equals("$END RGP")) {
                throw new IOException("Bad RGfile");
            }
            this.theWriter.write("$END RGP\n");
            l = this.theReader.readLine();
        }
        if (l == null) {
            throw new IOException("Unexpected end of RGfile");
        }
        this.theWriter.write(l);
        this.theWriter.write(10);
        return true;
    }

    private boolean convertRxn() throws IOException {
        int i;
        String[] lines = new String[4];
        for (i = 0; i < 4; ++i) {
            String s;
            if (i < this.head.size()) {
                s = this.head.get(0);
                this.head.remove(0);
            } else {
                s = this.theReader.readLine();
            }
            lines[i] = s;
            if (lines[i] != null) continue;
            return false;
        }
        if (!lines[0].startsWith("$RXN")) {
            return false;
        }
        for (i = 0; i < 4; ++i) {
            this.theWriter.write(lines[i]);
            this.theWriter.write(10);
        }
        String s = this.theReader.readLine();
        if (s == null) {
            return false;
        }
        this.theWriter.write(s);
        this.theWriter.write(10);
        int[] nc = new int[3];
        try {
            nc[0] = MdlCompressor.atoi(s, 0, 3);
            nc[1] = MdlCompressor.atoi(s, 3, 6);
        }
        catch (NumberFormatException e) {
            return false;
        }
        try {
            nc[2] = MdlCompressor.atoi(s, 6, 9);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        for (int i2 = 0; i2 < nc[0] + nc[1] + nc[2]; ++i2) {
            s = this.theReader.readLine();
            if (s == null || !s.startsWith("$MOL")) {
                return false;
            }
            this.theWriter.write(s);
            this.theWriter.write(10);
            if (!this.convertHeader()) {
                return false;
            }
            Boolean[] args = new Boolean[1];
            if (this.convertCtab(args)) continue;
            return false;
        }
        return true;
    }

    private boolean convertHeader() throws IOException {
        int headsize = this.head.size();
        for (int i = 0; i < 3; ++i) {
            String s;
            if (i < headsize) {
                s = this.head.get(0);
                this.head.remove(0);
            } else {
                s = this.theReader.readLine();
                if (s == null) {
                    return false;
                }
            }
            this.theWriter.write(s);
            this.theWriter.write(10);
        }
        return true;
    }

    private boolean convertCtab(Boolean[] args) throws IOException {
        int stereo;
        int i;
        double A = 10000.0;
        double B = 8388608.0;
        boolean compressed = false;
        args[0] = new Boolean(false);
        String s = this.theReader.readLine();
        if (s == null) {
            return false;
        }
        this.theWriter.write(s);
        this.theWriter.write(10);
        int na = -1;
        int nb = -1;
        try {
            na = MdlCompressor.atoi(s, 0, 3);
            nb = MdlCompressor.atoi(s, 3, 6);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (na < 0 || nb < 0) {
            throw new MolFormatException("Cannot convert molfile: bad atom and bond numbers in line " + this.theReader.getLineNumber());
        }
        int nchg = 0;
        int[] chg = new int[na];
        int nrad = 0;
        int[] rad = new int[na];
        boolean hasmchg = false;
        boolean hasmrad = false;
        ArrayList<String> tmpvec = new ArrayList<String>();
        boolean eof = false;
        while ((s = this.theReader.readLine()) != null) {
            int a;
            int k;
            int j;
            int n;
            tmpvec.add(s);
            if (s.length() <= 5) continue;
            String s6 = s.substring(0, 6);
            if (s6.equals("M  END")) break;
            if (s6.equals("M  CHG")) {
                n = MdlCompressor.atoi(s, 6, 9);
                for (j = 0; j < n; ++j) {
                    k = 9 + 8 * j;
                    a = MdlCompressor.atoi(s, k, k + 4);
                    chg[a - 1] = MdlCompressor.atoi(s, k + 4, k + 8);
                    if (chg[a - 1] == 0) continue;
                    ++nchg;
                }
                hasmchg = true;
                continue;
            }
            if (!s6.equals("M  RAD")) continue;
            n = MdlCompressor.atoi(s, 6, 9);
            for (j = 0; j < n; ++j) {
                k = 9 + 8 * j;
                a = MdlCompressor.atoi(s, k, k + 4);
                rad[a - 1] = MdlCompressor.atoi(s, k + 4, k + 8);
                if (rad[a - 1] == 0) continue;
                ++nrad;
            }
            hasmrad = true;
        }
        for (i = 0; i < na; ++i) {
            s = (String)tmpvec.get(i);
            int l = s.length();
            if (l == 10 || l == 14) {
                compressed = true;
                if ((this.compressionFlags & COMPRESS) != 0) {
                    this.theWriter.write(s);
                } else {
                    MdlCompressor.mftoa(((double)MdlCompressor.m6toi(s, 0, 4) - B) / A, this.theWriter);
                    MdlCompressor.mftoa(((double)MdlCompressor.m6toi(s, 4, 8) - B) / A, this.theWriter);
                    int offset = 8;
                    if (l == 14) {
                        MdlCompressor.mftoa(((double)MdlCompressor.m6toi(s, 8, 12) - B) / A, this.theWriter);
                        offset += 4;
                    } else {
                        this.theWriter.write("    0.0000");
                    }
                    this.theWriter.write(32);
                    int a = MdlCompressor.m6toi(s, offset, offset + 2);
                    String atsym = ATSYM_DECODE[a & 0x7F] + "   ";
                    stereo = a >> 7 & 3;
                    this.theWriter.write(atsym.substring(0, 3));
                    this.theWriter.write(" 0  ");
                    int charge = chg[i];
                    if (charge != 0 && charge > -4 && charge < 4) {
                        this.theWriter.write(52 - chg[i]);
                    } else if (rad[i] == 2) {
                        this.theWriter.write(52);
                    } else {
                        this.theWriter.write(48);
                    }
                    MdlCompressor.mitoa(stereo, this.theWriter);
                    this.theWriter.write("  0  0  0  0  0  0  0  0  0");
                }
            } else if ((this.compressionFlags & COMPRESS) != 0) {
                int stereo2;
                char c0;
                boolean unknown = false;
                int x = (int)Math.round(MdlCompressor.parseDouble(s, 0) * A + B);
                int y = (int)Math.round(MdlCompressor.parseDouble(s, 10) * A + B);
                int z = (int)Math.round(MdlCompressor.parseDouble(s, 20) * A + B);
                String atsym = s.substring(31, 34).trim();
                int atno = 0;
                if (atsym.length() == 3) {
                    unknown = true;
                } else if (atsym.length() > 0 && (c0 = atsym.charAt(0)) >= '@' && c0 <= 'Z') {
                    int c1 = 96;
                    if (atsym.length() > 1) {
                        c1 = atsym.charAt(1);
                    }
                    if (c1 >= 96 && c1 <= 122) {
                        atno = ATNO_SYM[27 * (c0 + '\u0001' - 65) + c1 + 1 - 97];
                    }
                }
                if (atno == 0) {
                    unknown = true;
                }
                if ((stereo2 = MdlCompressor.atoi(s, 39, 42)) < 0 || stereo2 > 3) {
                    unknown = true;
                }
                int a = atno & 0x7F;
                a |= (stereo2 & 3) << 7;
                int chargecode = MdlCompressor.atoi(s, 36, 39);
                if (chargecode == 4) {
                    if (rad[i] == 0) {
                        ++nrad;
                        rad[i] = 2;
                    }
                } else if (chargecode != 0 && chg[i] == 0) {
                    ++nchg;
                    chg[i] = 4 - chargecode;
                }
                if (s.length() >= 36 && !s.substring(34, 36).equals(" 0")) {
                    unknown = true;
                } else if (!unknown) {
                    char c;
                    int j;
                    int n56 = Math.min(s.length(), 56);
                    for (j = 42; j < n56; ++j) {
                        c = s.charAt(j);
                        if (c == ' ' || c == '0') continue;
                        unknown = true;
                        break;
                    }
                    for (j = 57; j < s.length(); ++j) {
                        c = s.charAt(j);
                        if (c == ' ' || c == '0') continue;
                        unknown = true;
                        break;
                    }
                }
                if (unknown) {
                    this.theWriter.write(s);
                } else {
                    char[] c64 = CHARS64;
                    this.theWriter.write(c64[x & 0x3F]);
                    this.theWriter.write(c64[x >> 6 & 0x3F]);
                    this.theWriter.write(c64[x >> 12 & 0x3F]);
                    this.theWriter.write(c64[x >> 18 & 0x3F]);
                    this.theWriter.write(c64[y & 0x3F]);
                    this.theWriter.write(c64[y >> 6 & 0x3F]);
                    this.theWriter.write(c64[y >> 12 & 0x3F]);
                    this.theWriter.write(c64[y >> 18 & 0x3F]);
                    if ((double)z != B) {
                        this.theWriter.write(c64[z & 0x3F]);
                        this.theWriter.write(c64[z >> 6 & 0x3F]);
                        this.theWriter.write(c64[z >> 12 & 0x3F]);
                        this.theWriter.write(c64[z >> 18 & 0x3F]);
                    }
                    this.theWriter.write(c64[a & 0x3F]);
                    this.theWriter.write(c64[a >> 6 & 0x3F]);
                }
            } else {
                this.theWriter.write(s);
            }
            this.theWriter.write(10);
        }
        for (i = 0; i < nb; ++i) {
            int type;
            s = (String)tmpvec.get(na + i);
            if (s.length() == 5) {
                compressed = true;
                if ((this.compressionFlags & COMPRESS) != 0) {
                    this.theWriter.write(s);
                } else {
                    int i1 = MdlCompressor.m6toi(s, 0, 2);
                    int i2 = MdlCompressor.m6toi(s, 2, 4);
                    int t = MdlCompressor.m6toi(s, 4, 5);
                    type = t & 7;
                    stereo = t >> 3 & 7;
                    if (type == 0) {
                        type = 8;
                    }
                    MdlCompressor.mitoa(i1, this.theWriter);
                    MdlCompressor.mitoa(i2, this.theWriter);
                    MdlCompressor.mitoa(type, this.theWriter);
                    MdlCompressor.mitoa(stereo, this.theWriter);
                    this.theWriter.write("  0  0  0");
                }
            } else if ((this.compressionFlags & COMPRESS) != 0) {
                boolean unknown = false;
                int i1 = MdlCompressor.atoi(s, 0, 3);
                int i2 = MdlCompressor.atoi(s, 3, 6);
                type = MdlCompressor.atoi(s, 6, 9);
                stereo = MdlCompressor.atoi(s, 9, 12);
                if (type < 1 || type > 8 || stereo != (stereo & 7)) {
                    unknown = true;
                }
                int t = type & 7 | (stereo &= 7) << 3;
                if (!unknown) {
                    for (int j = 12; j < s.length(); ++j) {
                        char c = s.charAt(j);
                        if (c == ' ' || c == '0') continue;
                        unknown = true;
                        break;
                    }
                }
                if (unknown) {
                    this.theWriter.write(s);
                } else {
                    char[] c64 = CHARS64;
                    this.theWriter.write(c64[i1 & 0x3F]);
                    this.theWriter.write(c64[i1 >> 6 & 0x3F]);
                    this.theWriter.write(c64[i2 & 0x3F]);
                    this.theWriter.write(c64[i2 >> 6 & 0x3F]);
                    this.theWriter.write(c64[t & 0x3F]);
                }
            } else {
                this.theWriter.write(s);
            }
            this.theWriter.write(10);
            args[0] = new Boolean(compressed);
        }
        if (nchg != 0 && !hasmchg) {
            i = 0;
            int count = 0;
            while (count < nchg) {
                int n;
                int n2 = n = nchg - count < 8 ? nchg - count : 8;
                if (n == 0) {
                    n = 8;
                }
                this.theWriter.write("M  CHG");
                MdlCompressor.mitoa(n, this.theWriter);
                int j = 0;
                while (j < n) {
                    if (chg[i] != 0) {
                        this.theWriter.write(32);
                        MdlCompressor.mitoa(i + 1, this.theWriter);
                        this.theWriter.write(chg[i] < 0 ? "  " : "   ");
                        this.theWriter.write(String.valueOf(chg[i]));
                        ++j;
                        ++count;
                    }
                    ++i;
                }
                this.theWriter.write(10);
            }
        }
        for (i = na + nb; i < tmpvec.size(); ++i) {
            s = (String)tmpvec.get(i);
            this.theWriter.write(s);
            this.theWriter.write(10);
        }
        return true;
    }

    private void convertEnd(Boolean[] args) throws IOException {
        boolean compressed = args[0];
        boolean issdf = false;
        String s = this.theReader.readLine();
        if (s != null) {
            while (s != null && s.length() > 3 && s.startsWith("> ")) {
                issdf = true;
                int i1 = s.indexOf(60, 1);
                int i2 = s.indexOf(62, i1 + 1);
                if (i1 < 0 || i2 < 0) {
                    throw new IOException("Bad properties in SD file");
                }
                if ((this.compressionFlags & SDF) != 0) {
                    this.theWriter.write(s);
                    this.theWriter.write(10);
                    String propName = s.substring(i1 + 1, i2);
                    while ((s = this.theReader.readLine()) != null && !s.startsWith("$$$$") && !s.startsWith("> ")) {
                        this.theWriter.write(s);
                        this.theWriter.write(10);
                    }
                } else {
                    while ((s = this.theReader.readLine()) != null && !s.startsWith("$$$$") && !s.startsWith("> ")) {
                    }
                }
                if (!s.startsWith("$$$$")) continue;
                break;
            }
            if (s != null) {
                if (s.startsWith("$$$$")) {
                    issdf = true;
                } else {
                    this.head.add(s);
                }
            }
        }
        if ((this.compressionFlags & SDF) != 0) {
            this.theWriter.write("$$$$\n");
        }
    }

    public static byte[] convert(byte[] mol, int flags) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(mol);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        MdlCompressor mc = new MdlCompressor(is, os, flags);
        while (mc.convert()) {
        }
        is.close();
        os.close();
        return os.toByteArray();
    }

    public static String convert(String mol, int flags) throws IOException {
        byte[] csmol = MdlCompressor.convert(mol.getBytes(), flags);
        return new String(csmol);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(strhelp);
            return;
        }
        String arg = args[0];
        try {
            InputStream istream = args.length == 1 ? System.in : new FileInputStream(args[1]);
            if (arg.equals("c") || arg.equals("d")) {
                MdlCompressor mc = new MdlCompressor(istream, System.out, arg.equals("c") ? COMPRESS : 0);
                while (mc.convert()) {
                }
            } else if (arg.equals("js")) {
                String line;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                MdlCompressor mc = new MdlCompressor(istream, baos, COMPRESS);
                while (mc.convert()) {
                }
                byte[] arr = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(arr);
                InputStreamReader isr = new InputStreamReader(bais);
                BufferedReader br = new BufferedReader(isr);
                System.out.println("\"" + br.readLine() + "\\n\"+");
                StringBuffer sbuf = new StringBuffer();
                while ((line = br.readLine()) != null) {
                    if (sbuf.length() + line.length() > 74) {
                        System.out.println("\"" + sbuf.toString() + "\"+");
                        sbuf.setLength(0);
                    }
                    sbuf.append(line);
                    sbuf.append("\\n");
                }
                System.out.println("\"" + sbuf.toString() + "\";");
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    private static double parseDouble(String s, int offset) {
        double x = 1.0E-4 * (double)(s.charAt(offset + 9) - 48) + 0.001 * (double)(s.charAt(offset + 8) - 48) + 0.01 * (double)(s.charAt(offset + 7) - 48) + 0.1 * (double)(s.charAt(offset + 6) - 48);
        double w = 1.0;
        int i = 4;
        do {
            char c;
            if ((c = s.charAt(offset + i)) < '0' || c > '9') {
                return c == '-' ? -x : x;
            }
            x += (double)(c - 48) * w;
            w *= 10.0;
        } while (--i >= 0);
        return x;
    }

    static {
        StringTokenizer st = new StringTokenizer(" ,H,He,Li,Be,B,C,N,O,F,Ne,Na,Mg,Al,Si,P,S,Cl,Ar,K,Ca,Sc,Ti,V,Cr,Mn,Fe,Co,Ni,Cu,Zn,Ga,Ge,As,Se,Br,Kr,Rb,Sr,Y,Zr,Nb,Mo,Tc,Ru,Rh,Pd,Ag,Cd,In,Sn,Sb,Te,I,Xe,Cs,Ba,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu,Hf,Ta,W,Re,Os,Ir,Pt,Au,Hg,Tl,Pb,Bi,Po,At,Rn,Fr,Ra,Ac,Th,Pa,U,Np,Pu,Am,Cm,Bk,Cf,Es,Fm,Md,No,Lr,Rf,Db,Sg,Bh,Hs,Mt,L,LP,A,Q,*,R#", ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int l = s.length();
            MdlCompressor.ATSYM_DECODE[i] = s;
            if (l > 0) {
                int c1;
                char c0 = s.charAt(0);
                int n = c1 = l > 1 ? (int)s.charAt(1) : 96;
                if (!s.equals(" ") && !s.equals("*")) {
                    MdlCompressor.ATNO_SYM[27 * (c0 - 65 + 1) + c1 + 1 - 97] = i;
                }
            }
            ++i;
        }
        for (i = 0; i < 64; ++i) {
            char c = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz+-".charAt(i);
            MdlCompressor.DIGITS64U[c] = i;
            MdlCompressor.CHARS64[i] = c;
        }
    }
}

