/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.calculations.clean.Cleaner;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.cml.MrvExport;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.graphics.MMoleculeMovie;
import chemaxon.util.ErrorProcessor;
import chemaxon.util.MolFilter;
import chemaxon.util.concurrent.ConcurrentProcessor;
import chemaxon.util.concurrent.InputProducer;
import chemaxon.util.concurrent.WorkUnit;
import chemaxon.util.concurrent.WorkUnitFactory;
import chemaxon.util.concurrent.processors.ConcurrentProcessors;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

public class MolExporter {
    public static final int TEXT = 1;
    public static final int MULTIPLE = 2;
    public static final int C_CLOSE_STREAM = 1;
    public static final int C_FLUSH_STREAM = 2;
    public static final MolFilter FILTER_DIM0 = new MolFilter(){

        @Override
        public boolean accept(Molecule mol) {
            return mol.getDim() == 0;
        }
    };
    private String outputFilename;
    private OutputStream outputStream;
    private long outputStreamCount;
    private OutputStreamWriter printWriter;
    private MolExportModule exportModule;
    private ObjectOutputStream objectOutputStream;
    private String format;
    private int threadCount = 1;
    private int cleanDim = 0;
    private String cleanOpts = null;
    private MolFilter cleanFilter = null;
    private long writeCount;
    private int outputFlags;
    private ErrorProcessor errorProcessor = null;
    private volatile MolExportException error = null;
    private static final int QUEUE_CAPACITY = 100;
    private static final Object POISON = new Object();
    private static final Object VOID = new Object();
    private ConcurrentProcessor concurrentProcessor = null;
    private MInputProducer inputProducer = null;
    private MWorkUnitFactory workUnitFactory = null;
    private FutureTask writerTask = null;
    private Thread writerThread = null;
    private String fmtopts1 = null;
    private String fmtopts2 = null;
    private String encoding = null;

    public MolExporter(String fname, String fmtWithOpts, int outflags, String[] incFields, String enc) throws MolExportException, IOException, IllegalArgumentException {
        this.init(null, fname, fmtWithOpts, outflags, incFields, enc);
    }

    public MolExporter(String fname, String fmtWithOpts) throws MolExportException, IOException, IllegalArgumentException {
        this.init(null, fname, fmtWithOpts, 1, null, null);
    }

    public MolExporter(OutputStream out, String fmtWithOpts, boolean text, String[] incFields, String enc) throws MolExportException, IOException, IllegalArgumentException {
        this.init(out, null, fmtWithOpts, text ? 1 : 0, incFields, enc);
    }

    public MolExporter(OutputStream out, String fmtWithOpts) throws MolExportException, IOException, IllegalArgumentException {
        this.init(out, null, fmtWithOpts, 0, null, null);
    }

    public MolExporter(OutputStream out, String fmtWithOpts, boolean text, String[] incFields) throws MolExportException, IOException, IllegalArgumentException {
        this.init(out, null, fmtWithOpts, text ? 1 : 0, incFields, null);
    }

    public MolExporter(OutputStream out, String fmtWithOpts, String enc) throws MolExportException, IOException, IllegalArgumentException {
        this.init(out, null, fmtWithOpts, 0, null, enc);
    }

    private void init(OutputStream out, String fname, String fmtopts, int outflags, String[] incFields, String enc) throws MolExportException, IOException, IllegalArgumentException {
        this.outputStream = out;
        this.outputFilename = fname;
        this.outputFlags = outflags;
        int i = fmtopts.indexOf(58);
        this.format = fmtopts.substring(0, i >= 0 ? i : fmtopts.length());
        if (this.format.equals("chemaxon.struc.Molecule")) {
            this.exportModule = null;
        } else if (this.format.equals("null")) {
            this.exportModule = null;
        } else {
            this.exportModule = MFileFormatUtil.createExportModule(fmtopts);
            if (this.exportModule == null) {
                throw new MolExportException("Cannot export in \"" + this.format + "\" format.");
            }
        }
        if (this.exportModule != null) {
            this.fmtopts1 = fmtopts;
            this.encoding = enc;
            String e = null;
            fmtopts = this.exportModule.setEncoding(fmtopts, enc);
            e = this.exportModule.getEncoding();
            if (e != null) {
                this.encoding = e;
            }
            if (incFields != null && (fmtopts.startsWith("smiles") || fmtopts.startsWith("smarts") || fmtopts.startsWith("cxsmiles") || fmtopts.startsWith("cxsmarts"))) {
                StringBuffer sbuf = new StringBuffer();
                sbuf.append(fmtopts.indexOf(58) >= 0 ? ",T" : ":T");
                for (i = 0; i < incFields.length; ++i) {
                    sbuf.append(":");
                    sbuf.append(incFields[i]);
                }
                fmtopts = fmtopts + sbuf.toString();
            }
            this.fmtopts2 = fmtopts;
        }
        this.writeCount = 0L;
        this.outputStreamCount = -1L;
        if ((this.outputFlags & 2) == 0) {
            this.ensureOpen();
        }
    }

    private void ensureOpen() throws MolExportException, IOException {
        if (this.outputStreamCount == this.writeCount) {
            return;
        }
        if (this.writeCount != 0L && (this.outputFlags & 2) == 0) {
            return;
        }
        if (this.outputFilename != null) {
            String fname = this.outputFilename;
            if ((this.outputFlags & 2) != 0) {
                String ext = MFileFormatUtil.getKnownExtension(this.outputFilename);
                if (ext != null) {
                    int i = this.outputFilename.length() - ext.length() + 1;
                    fname = this.outputFilename.substring(0, i - 1) + String.valueOf(this.outputStreamCount + 2L) + this.outputFilename.substring(i - 1);
                } else {
                    fname = this.outputFilename + String.valueOf(this.outputStreamCount + 2L);
                }
            }
            FileOutputStream out = new FileOutputStream(fname);
            this.outputStream = new BufferedOutputStream(out);
        }
        if (this.format.equals("chemaxon.struc.Molecule")) {
            this.objectOutputStream = new ObjectOutputStream(this.outputStream);
        } else if (this.format.equals("null")) {
            this.objectOutputStream = null;
        } else if (this.exportModule != null) {
            this.printWriter = this.encoding == null ? new OutputStreamWriter(this.outputStream) : new OutputStreamWriter(this.outputStream, this.encoding);
            Object o = this.exportModule.open(this.fmtopts2);
            this.writeObject(o);
        } else {
            this.printWriter = null;
        }
        this.outputStreamCount = this.writeCount;
    }

    private void closeIfNeeded() throws IOException {
        if (this.writeCount != 0L && (this.outputFlags & 2) != 0) {
            if (this.exportModule != null) {
                Object o = this.exportModule.close();
                this.writeObject(o);
            }
            if (this.objectOutputStream != null) {
                this.objectOutputStream.close();
                this.objectOutputStream = null;
            } else if (this.printWriter != null) {
                this.printWriter.close();
                this.printWriter = null;
            }
            this.outputStream = null;
        }
    }

    public void setThreadCount(int threadCount) throws IllegalStateException {
        if (this.concurrentProcessor != null) {
            throw new IllegalStateException("setThreadCount() should be called before write().");
        }
        this.threadCount = threadCount;
    }

    public void setClean(int cleanDim, String cleanOpts) throws IllegalStateException {
        this.setClean(cleanDim, cleanOpts, null);
    }

    public void setClean(int cleanDim, String cleanOpts, MolFilter cleanFilter) throws IllegalStateException {
        if (this.concurrentProcessor != null) {
            throw new IllegalStateException("setClean() should be called before write().");
        }
        if (this.isCleanable()) {
            this.cleanDim = cleanDim;
            this.cleanOpts = cleanOpts;
            this.cleanFilter = cleanFilter;
        }
    }

    public void setErrorProcessor(ErrorProcessor errorProcessor) throws IllegalStateException {
        if (this.concurrentProcessor != null) {
            throw new IllegalStateException("setErrorHandler() should be called before write().");
        }
        this.errorProcessor = errorProcessor;
    }

    private void startConcurrentProcessor() throws ExecutionException {
        int processorType = 1;
        this.inputProducer = new MInputProducer();
        this.workUnitFactory = new MWorkUnitFactory(this.cleanDim, this.cleanOpts, this.cleanFilter, this.fmtopts1, this.fmtopts2, this.encoding);
        if (this.errorProcessor == null) {
            this.errorProcessor = new InterruptingErrorProcessor();
        }
        this.writerTask = new FutureTask(new Writer());
        this.writerThread = new Thread(this.writerTask);
        this.writerThread.setDaemon(true);
        try {
            this.concurrentProcessor = ConcurrentProcessors.create(processorType, this.inputProducer, this.workUnitFactory);
            if (this.threadCount > 0) {
                this.concurrentProcessor.setWorkerThreadCount(this.threadCount);
            }
            this.concurrentProcessor.start();
            this.writerThread.start();
        }
        catch (ExecutionException e) {
            if (this.concurrentProcessor != null) {
                try {
                    this.concurrentProcessor.cleanup();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.concurrentProcessor = null;
            throw e;
        }
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isCleanable() {
        return this.exportModule != null ? this.exportModule.isCleanable() : true;
    }

    public boolean write(Molecule m) throws MolExportException, IOException {
        if (this.exportModule != null) {
            if (this.concurrentProcessor == null && this.threadCount != 1) {
                try {
                    this.startConcurrentProcessor();
                }
                catch (ExecutionException e) {
                    System.err.println("MolExporter could not start concurrent processor: " + e);
                }
            }
            if (this.concurrentProcessor != null) {
                if (this.error != null) {
                    return false;
                }
                try {
                    this.inputProducer.put(m);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                if (this.cleanDim > 0 && (this.cleanFilter == null || this.cleanFilter.accept(m))) {
                    Cleaner.clean(m, this.cleanDim, this.cleanOpts);
                }
                this.ensureOpen();
                Object o = this.exportModule.convert(m);
                this.writeRecordObject(o);
            }
        } else if (this.objectOutputStream != null) {
            m = m.cloneMolecule();
            if (this.cleanDim > 0 && (this.cleanFilter == null || this.cleanFilter.accept(m))) {
                Cleaner.clean(m, this.cleanDim, this.cleanOpts);
            }
            this.ensureOpen();
            this.objectOutputStream.writeObject(m);
            ++this.writeCount;
            this.closeIfNeeded();
        } else if (!this.format.equals("null")) {
            throw new IOException("MolExporter cannot write into closed file");
        }
        return true;
    }

    public void close() throws MolExportException, IOException {
        this.close(1);
    }

    public void close(int opts) throws MolExportException, IOException {
        if (this.concurrentProcessor != null) {
            this.flushConcurrentProcessor();
        }
        if (this.exportModule != null) {
            if ((this.outputFlags & 2) == 0) {
                Object o = this.exportModule.close();
                this.writeObject(o);
            }
            this.exportModule = null;
        }
        if (this.objectOutputStream != null) {
            if ((opts & 1) != 0) {
                this.objectOutputStream.close();
            } else if ((opts & 2) != 0) {
                this.objectOutputStream.flush();
            }
        } else if (this.printWriter != null) {
            if ((opts & 1) != 0) {
                this.printWriter.close();
            } else if ((opts & 2) != 0) {
                this.printWriter.flush();
            }
        }
        if ((opts & 1) != 0) {
            this.objectOutputStream = null;
            this.printWriter = null;
            this.outputStream = null;
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    public void flush() throws MolExportException, IOException {
        if (this.concurrentProcessor != null) {
            this.flushConcurrentProcessor();
        }
        if (this.objectOutputStream != null) {
            this.objectOutputStream.flush();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    private void flushConcurrentProcessor() throws MolExportException {
        this.inputProducer.close();
        try {
            this.writerTask.get();
            this.writerThread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.concurrentProcessor.cleanup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.workUnitFactory.close();
        this.inputProducer = null;
        this.workUnitFactory = null;
        this.writerTask = null;
        this.writerThread = null;
        this.concurrentProcessor = null;
    }

    protected void finalize() throws MolExportException, IOException {
        if (this.concurrentProcessor != null) {
            this.flushConcurrentProcessor();
        }
        if (this.exportModule != null) {
            if ((this.outputFlags & 2) == 0) {
                Object o = this.exportModule.close();
                this.writeObject(o);
            }
            this.exportModule = null;
        }
        if (this.objectOutputStream != null) {
            this.objectOutputStream.flush();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    private void writeRecordObject(Object o) throws IOException {
        this.writeObject(o);
        ++this.writeCount;
        this.closeIfNeeded();
    }

    private void writeObject(Object o) throws IOException {
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            String s = (String)o;
            if ((this.outputFlags & 1) != 0 && !"\n".equals(System.getProperty("line.separator"))) {
                int eolindex;
                int index = 0;
                String separator = "\n";
                String NL = System.getProperty("line.separator");
                do {
                    if ((eolindex = s.indexOf(separator, index)) >= 0) {
                        this.printWriter.write(s, index, eolindex - index);
                        this.printWriter.write(NL, 0, NL.length());
                        continue;
                    }
                    this.printWriter.write(s, index, s.length() - index);
                    eolindex = s.length();
                } while ((index = eolindex + separator.length()) < s.length());
                this.printWriter.flush();
            } else {
                this.printWriter.write(s, 0, s.length());
                if (!s.endsWith("\n")) {
                    this.printWriter.write(10);
                }
                this.printWriter.flush();
            }
        } else if (o instanceof byte[]) {
            byte[] d = (byte[])o;
            this.outputStream.write(d);
            this.outputStream.flush();
        }
    }

    public static Object exportToObject(MDocument document, String fmt) throws IOException {
        MoleculeGraph molg;
        MMoleculeMovie mmm;
        MolExportModule cv = MFileFormatUtil.createExportModule(fmt);
        if (cv == null) {
            throw new IOException("Cannot export document in unknown format \"" + fmt + "\"");
        }
        Molecule[] mols = null;
        if (!cv.isDocumentExport() && (mmm = document.getMoleculeMovie()) != null) {
            mols = mmm.getMolecules();
        }
        if (mols == null && (molg = document.getMainMoleculeGraph()) instanceof Molecule) {
            mols = new Molecule[]{(Molecule)molg};
        }
        if (mols != null) {
            if (fmt.equals("mrv")) {
                ((MrvExport)cv).setGlobalGUIProperties(document.getGUIPropertyContainer());
            }
            return MolExporter.exportToObject(mols, fmt, cv);
        }
        throw new IOException("Main molecule graph is not a real Molecule");
    }

    public static String convertToString(MDocument document, String fmt, int flags) throws IOException {
        String s = MolExporter.exportToFormat(document, fmt == null ? "mrv" : fmt);
        if (s.startsWith("<?xml") || s.startsWith("<?XML")) {
            int i = s.indexOf("?>");
            return s.substring(i + 2).trim();
        }
        return s;
    }

    public static final String exportToFormat(MDocument document, String fmt) throws IOException {
        Object o = MolExporter.exportToObject(document, fmt);
        if (o != null && o instanceof String) {
            String s = (String)o;
            int l = s.length();
            if (l > 0 && s.indexOf(10) == l - 1) {
                s = s.substring(0, l - 1);
            }
            return s;
        }
        return null;
    }

    public static final byte[] exportToBinFormat(MDocument document, String fmt) throws IOException {
        Object o = MolExporter.exportToObject(document, fmt);
        if (o != null) {
            if (o instanceof String) {
                String s = (String)o;
                int len = s.length();
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = (byte)s.charAt(i);
                }
                return data;
            }
            if (o instanceof byte[]) {
                return (byte[])o;
            }
        }
        return null;
    }

    public static final String exportToFormat(Molecule molecule, String fmt) throws IOException {
        Object o = MolExporter.exportToObject(molecule, fmt);
        if (o != null && o instanceof String) {
            String s = (String)o;
            int l = s.length();
            if (l > 0 && s.indexOf(10) == l - 1) {
                s = s.substring(0, l - 1);
            }
            return s;
        }
        return null;
    }

    public static final byte[] exportToBinFormat(Molecule molecule, String fmt) throws IOException {
        Object o = MolExporter.exportToObject(molecule, fmt);
        if (o != null) {
            if (o instanceof String) {
                String s = (String)o;
                int len = s.length();
                byte[] data = new byte[len];
                for (int i = 0; i < len; ++i) {
                    data[i] = (byte)s.charAt(i);
                }
                return data;
            }
            if (o instanceof byte[]) {
                return (byte[])o;
            }
        }
        return null;
    }

    public static Object exportToObject(Molecule molecule, String fmt) throws IOException {
        MolExportModule cv = MFileFormatUtil.createExportModule(fmt);
        if (cv == null) {
            throw new IOException("Cannot export in unknown format \"" + fmt + "\"");
        }
        Molecule[] mols = new Molecule[]{molecule};
        MPropertyContainer guiProperties = null;
        if (molecule.getDocument() != null) {
            guiProperties = molecule.getDocument().getGUIPropertyContainer();
        }
        return MolExporter.exportToObject(mols, fmt, cv, guiProperties);
    }

    public static Object exportToObject(Molecule[] mols, String fmt, MolExportModule cv) throws IOException {
        return MolExporter.exportToObject(mols, fmt, cv, null);
    }

    static Object exportToObject(Molecule[] mols, String fmt, MolExportModule cv, MPropertyContainer guiProperties) throws IOException {
        Object o = null;
        o = guiProperties == null ? cv.open(fmt) : cv.open(fmt, guiProperties);
        StringBuffer sb = null;
        ByteArrayOutputStream baos = null;
        if (o != null) {
            if (o instanceof String) {
                sb = new StringBuffer((String)o);
            } else if (o instanceof byte[]) {
                baos = new ByteArrayOutputStream();
                try {
                    baos.write((byte[])o);
                }
                catch (IOException ex) {
                    throw new IOException("Cannot write byte array output stream");
                }
            }
        }
        for (int i = 0; i < mols.length; ++i) {
            o = cv.convert(mols[i]);
            if (o != null) {
                if (o instanceof String) {
                    if (sb != null) {
                        sb.append((String)o);
                        continue;
                    }
                    sb = new StringBuffer((String)o);
                    continue;
                }
                if (!(o instanceof byte[])) continue;
                if (baos == null) {
                    baos = new ByteArrayOutputStream();
                }
                try {
                    baos.write((byte[])o);
                    continue;
                }
                catch (IOException ex) {
                    throw new IOException("Cannot write byte array output stream");
                }
            }
            throw new IOException("" + cv + ".convert returns null");
        }
        Object o2 = cv.close();
        if (o2 != null) {
            if (o2 instanceof String) {
                if (sb == null) {
                    sb = new StringBuffer();
                }
                sb.append((String)o2);
            } else if (o2 instanceof byte[]) {
                if (baos == null) {
                    baos = new ByteArrayOutputStream();
                }
                try {
                    baos.write((byte[])o2);
                }
                catch (IOException ex) {
                    throw new IOException("Cannot write byte array output stream");
                }
            }
        }
        if (sb != null) {
            o = sb.toString();
        } else if (baos != null) {
            o = baos.toByteArray();
        }
        return o;
    }

    static class InterruptingErrorProcessor
    implements ErrorProcessor {
        InterruptingErrorProcessor() {
        }

        @Override
        public boolean processError(Throwable error) {
            return false;
        }
    }

    private class Writer
    implements Callable {
        private Writer() {
        }

        public Object call() throws Exception {
            int molIndex = -1;
            while (MolExporter.this.concurrentProcessor.hasNext()) {
                Object o = MolExporter.this.concurrentProcessor.getNext();
                if (o == null || MolExporter.this.error != null) continue;
                ++molIndex;
                if (o instanceof MolExportException) {
                    MolExportException e = (MolExportException)o;
                    e.setMolIndex(molIndex);
                    if (!MolExporter.this.errorProcessor.processError(e)) {
                        MolExporter.this.error = e;
                        continue;
                    }
                    o = MolExporter.this.exportModule.convert(new Molecule());
                }
                if (o == null) continue;
                MolExporter.this.writeRecordObject(o);
            }
            return null;
        }
    }

    private static class MWorkUnitFactory
    implements WorkUnitFactory {
        private int cleanDim = 0;
        private String cleanOpts = null;
        private MolFilter cleanFilter = null;
        private String fmtopts1 = null;
        private String fmtopts2 = null;
        private String encoding = null;
        private ArrayList workUnits = new ArrayList();

        public MWorkUnitFactory(int cleanDim, String cleanOpts, MolFilter cleanFilter, String fmtopts1, String fmtopts2, String encoding) {
            this.cleanDim = cleanDim;
            this.cleanOpts = cleanOpts;
            this.cleanFilter = cleanFilter;
            this.fmtopts1 = fmtopts1;
            this.fmtopts2 = fmtopts2;
            this.encoding = encoding;
        }

        @Override
        public WorkUnit createWorkUnit() throws Exception {
            MolExportModule exportMod = MFileFormatUtil.createExportModule(this.fmtopts1);
            exportMod.setEncoding(this.fmtopts1, this.encoding);
            exportMod.open(this.fmtopts2);
            MWorkUnit workUnit = new MWorkUnit(this.cleanDim, this.cleanOpts, this.cleanFilter, exportMod);
            this.workUnits.add(workUnit);
            return workUnit;
        }

        public void close() throws MolExportException {
            for (int i = this.workUnits.size() - 1; i >= 0; --i) {
                ((MWorkUnit)this.workUnits.get(i)).close();
            }
            this.workUnits.clear();
        }
    }

    private static class MWorkUnit
    implements WorkUnit {
        private MolExportModule exportMod = null;
        private int cleanDim = 0;
        private String cleanOpts = null;
        private MolFilter cleanFilter = null;
        private Molecule mol = null;

        public MWorkUnit(int cleanDim, String cleanOpts, MolFilter cleanFilter, MolExportModule exportMod) throws MolExportException {
            this.cleanDim = cleanDim;
            this.cleanOpts = cleanOpts;
            this.cleanFilter = cleanFilter;
            this.exportMod = exportMod;
        }

        @Override
        public void setInput(Object obj) throws ExecutionException {
            this.mol = (Molecule)obj;
        }

        public Object call() throws Exception {
            if (this.cleanDim > 0 && this.mol != null && (this.cleanFilter == null || this.cleanFilter.accept(this.mol))) {
                Cleaner.clean(this.mol, this.cleanDim, this.cleanOpts);
            }
            try {
                return this.mol == null ? null : this.exportMod.convert(this.mol);
            }
            catch (MolExportException e) {
                return e;
            }
        }

        public void close() throws MolExportException {
            this.exportMod.close();
        }
    }

    private class MInputProducer
    implements InputProducer {
        private ArrayBlockingQueue<Object> molQueue = new ArrayBlockingQueue(100);
        private Object next = MolExporter.access$000();

        private MInputProducer() {
        }

        @Override
        public boolean hasNext() throws InterruptedException, ExecutionException {
            if (this.next == VOID) {
                this.next = this.molQueue.take();
            }
            return this.next != POISON;
        }

        @Override
        public Object getNext() throws InterruptedException, ExecutionException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object tmp = this.next;
            this.next = VOID;
            return tmp;
        }

        public void put(Molecule mol) throws InterruptedException {
            this.molQueue.put(mol);
        }

        public void close() {
            InterruptedException ie = null;
            while (true) {
                try {
                    this.molQueue.put(POISON);
                }
                catch (InterruptedException e) {
                    ie = e;
                    continue;
                }
                break;
            }
            if (ie != null) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

