/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MFileFormat;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.license.LicenseException;
import chemaxon.marvin.io.MDocSource;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordImporter;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.MonitorableInputStream;
import chemaxon.marvin.io.SeekableInputStream;
import chemaxon.marvin.io.formats.MoleculeImporterIface;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

public class MolImporter
extends MDocSource
implements MoleculeImporterIface {
    @Deprecated
    public static final int F_MOLMOVIE = 1;
    private MRecordImporter recordImporter = null;
    private boolean molImportModuleInitialized = false;
    private long molInputStreamOffset0;
    private int molInputStreamLineCount0;
    private boolean seekSupportInitialized = false;
    private ObjectInputStream objectInputStream = null;
    private File moleculeFile = null;
    private String inputFormat = null;
    private String importOptions = null;
    private int importMetaOptions = 0;
    private int optionFlags = 0;
    private boolean queryMode = false;
    private boolean grabbingEnabled = false;
    private String encoding = null;
    private int recordCountMax;
    private int recordCountReadMax;
    private int nextRecordIndex;
    private long filePositionMax;
    private boolean endReached;
    private long[] positions = null;
    private int[] lineCounts = null;
    private String fileName = null;

    @Deprecated
    public MolImporter() {
    }

    public MolImporter(InputStream is) throws IOException, MolFormatException {
        this.init(is, null, null, null);
    }

    public MolImporter(InputStream is, String opts) throws IOException, MolFormatException {
        this.init(is, opts, null, null);
    }

    public MolImporter(InputStream is, String opts, String enc) throws IOException, MolFormatException {
        this.init(is, opts, null, enc);
    }

    public MolImporter(InputStream is, String opts, String enc, String fileName) throws IOException, MolFormatException {
        this.init(is, opts, fileName, enc);
    }

    public MolImporter(File f, String opts) throws IOException, MolFormatException {
        this.init(new SeekableInputStream(f), opts, f.getPath(), null);
    }

    public MolImporter(String fname) throws IOException, MolFormatException {
        this(fname, null, null);
    }

    public MolImporter(String fname, Object component, String msg) throws IOException, MolFormatException {
        this.importOptions = null;
        this.init(fname, component, msg, null);
    }

    public String getFileName() {
        return this.fileName;
    }

    @Deprecated
    public void setFileName(String fname) throws IOException, MolFormatException {
        if (this.recordImporter != null || this.objectInputStream != null) {
            this.close();
            this.recordImporter = null;
            this.objectInputStream = null;
        }
        this.init(fname, null, null, null);
        this.molImportModuleInitialized = false;
        this.seekSupportInitialized = false;
    }

    public File getFile() {
        return this.moleculeFile;
    }

    public String getOptions() {
        return this.importOptions;
    }

    @Deprecated
    public void setOptions(String opts) {
        this.importOptions = opts;
    }

    public MolImportModule getMolImportModule() {
        if (this.recordImporter == null) {
            return null;
        }
        return this.recordImporter.getMolImportModule();
    }

    public boolean isGrabbingEnabled() {
        return this.grabbingEnabled;
    }

    public void setGrabbingEnabled(boolean v) {
        this.grabbingEnabled = v;
    }

    public String getGrabbedMoleculeString() {
        return this.recordImporter.getMoleculeString();
    }

    @Deprecated
    public int getOptionFlags() {
        return this.optionFlags;
    }

    @Deprecated
    public void setOptionFlags(int f) {
        this.optionFlags = f;
    }

    public boolean isMultiSet() {
        return (this.importMetaOptions & 1) != 0;
    }

    public boolean isMolMovie() {
        int f = this.importMetaOptions & 6;
        return f == 2 || f != 4 && this.inputFormat.equals("xyz");
    }

    private InputStream createProgressMonitorInputStream(String fname, Object component, String msg, InputStream is) {
        int i = msg.indexOf("%p");
        if (i >= 0) {
            msg = msg.substring(0, i).concat(fname).concat(msg.substring(i + 2));
        }
        if (!(is instanceof SeekableInputStream)) {
            try {
                Class<?> cl = Class.forName("javax.swing.ProgressMonitorInputStream");
                Class<?> componentClass = Class.forName("java.awt.Component");
                Constructor<?> cons = cl.getConstructor(componentClass, Object.class, InputStream.class);
                is = (InputStream)cons.newInstance(component, msg, is);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return is;
    }

    private void init(String fname, Object component, String msg, String enc) throws IOException, MolFormatException {
        InputStream is;
        String[] s = MFileFormatUtil.splitFileAndOptions(fname);
        if (s[0].startsWith("http:/") || s[0].startsWith("ftp:/") || s[0].startsWith("https:/")) {
            URLConnection conn = new URL(s[0]).openConnection();
            is = conn.getInputStream();
            is = new MonitorableInputStream(is, conn.getContentLength());
        } else {
            File f = new File(s[0]);
            is = new SeekableInputStream(f);
            this.moleculeFile = f;
        }
        this.fileName = s[0];
        if (msg != null) {
            is = this.createProgressMonitorInputStream(s[0], component, msg, is);
        }
        if (s[1] == null) {
            s[1] = this.getOptions();
        }
        this.init(is, s[1], fname, enc);
    }

    private void init(InputStream is, String opts, String fname, String enc) throws IOException, MolFormatException {
        this.molInputStreamOffset0 = 0L;
        this.molInputStreamLineCount0 = 0;
        this.recordCountMax = 0;
        this.recordCountReadMax = 0;
        this.nextRecordIndex = 0;
        this.filePositionMax = 0L;
        this.endReached = false;
        this.encoding = enc;
        this.importOptions = opts = this.parseEncodingOption(opts);
        String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(opts);
        this.importMetaOptions = MFileFormatUtil.preprocessFormatAndOptions(fmtopts);
        String fmt = fmtopts[0];
        if (fmt == null) {
            fmt = MFileFormatUtil.getUnguessableFormat(fname);
        }
        MolInputStream mis = is instanceof MolInputStream ? (MolInputStream)is : new MolInputStream(is, fmt, this.encoding, fname);
        this.fileName = fname;
        fmt = mis.getFormat();
        if (fmt.equals("chemaxon.struc.Molecule")) {
            this.objectInputStream = new ObjectInputStream(mis);
            mis = null;
            this.recordImporter = null;
        } else {
            int i = fmt.indexOf(58);
            if (i >= 0) {
                fmt = fmt.substring(0, i);
            }
            try {
                this.recordImporter = new MRecordImporter(mis, fmtopts[1]);
            }
            catch (IllegalCharsetNameException ex) {
                throw ex;
            }
            catch (UnsupportedCharsetException ex) {
                throw ex;
            }
            catch (MolFormatException ex) {
                throw ex;
            }
            catch (LicenseException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new MolFormatException("Internal error: cannot create new instance for the " + fmt + " importer module", ex);
            }
            MFileFormat[] formats = MFileFormatUtil.findFormats(fmt, 0L, 0L);
            for (int j = 0; j < formats.length; ++j) {
                MFileFormat f = formats[j];
                if (f.getAssociatedQueryFormat() != null) {
                    this.queryMode = false;
                    break;
                }
                if (f.getAssociatedNonQueryFormat() == null) continue;
                this.queryMode = true;
                break;
            }
            this.recordImporter.setQueryMode(this.queryMode);
            this.inputFormat = this.recordImporter.getFormat();
        }
    }

    private String parseEncodingOption(String opts) {
        if (opts == null) {
            return null;
        }
        String[] e = MFileFormatUtil.getEncodingFromOptions(opts);
        if (this.encoding == null) {
            this.encoding = e[0];
        }
        return e[1];
    }

    private void initMolImportIfNeeded() {
        if (!this.molImportModuleInitialized) {
            this.molImportModuleInitialized = true;
            this.molInputStreamOffset0 = this.recordImporter.getFilePointer();
            this.molInputStreamLineCount0 = this.recordImporter.getLineCount();
        }
    }

    private void initSeekSupportIfNeeded() {
        if (this.seekSupportInitialized) {
            return;
        }
        this.initMolImportIfNeeded();
        if (this.recordImporter != null && this.recordImporter.isSeekable()) {
            this.positions = new long[1];
            this.positions[0] = this.molInputStreamOffset0;
            this.lineCounts = new int[1];
            this.lineCounts[0] = this.molInputStreamLineCount0;
        } else {
            this.positions = null;
            this.lineCounts = null;
        }
        this.seekSupportInitialized = true;
    }

    public void setThreadCount(int threadCount) throws IllegalStateException {
        if (this.recordImporter == null) {
            throw new IllegalStateException("Concurrent processing is not available for import with object input stream.");
        }
        this.recordImporter.setThreadCount(threadCount);
    }

    public boolean getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(boolean q) {
        this.queryMode = q;
        if (this.recordImporter != null) {
            this.recordImporter.setQueryMode(q);
            this.inputFormat = this.recordImporter.getFormat();
        }
    }

    @Override
    public Molecule read() throws IOException {
        Molecule mol = null;
        if (this.objectInputStream != null) {
            mol = this.readMolFromObjectInputStream();
            if (mol != null) {
                this.incNextRecordIndex(true);
            }
        } else {
            mol = MolImporter.read(this);
        }
        return mol;
    }

    public Molecule createMol() {
        this.initMolImportIfNeeded();
        return this.recordImporter.createMolIfNeeded();
    }

    private static Molecule read(MolImporter mi) throws IOException {
        Molecule mol = mi.createMol();
        if ((mol = mi.readMol(mol)) != null) {
            Molecule m = mol.getSimplifiedMolecule();
            m.setStartPosition(mol.getStartPosition());
            m.setEndPosition(mol.getEndPosition());
            return m;
        }
        return null;
    }

    @Override
    public MDocument nextDoc() throws IOException {
        return this.readDoc(null, null);
    }

    public MDocument readDoc(MDocument doc, Molecule buf) throws MolFormatException, IOException {
        if (this.objectInputStream != null) {
            try {
                Object o = this.objectInputStream.readObject();
                if (o != null) {
                    this.incNextRecordIndex(true);
                    if (o instanceof MDocument) {
                        return (MDocument)o;
                    }
                    if (o instanceof MoleculeGraph) {
                        return new MDocument((MoleculeGraph)o);
                    }
                }
                this.endReached = true;
                throw new IOException("Serialized object " + o + " is not a molecule");
            }
            catch (EOFException ex) {
                this.endReached = true;
                return null;
            }
            catch (ClassNotFoundException ex) {
                this.endReached = true;
                throw new IOException("Serialized object is of unknown class");
            }
        }
        this.initMolImportIfNeeded();
        if (doc == null && buf != null) {
            doc = new MDocument(buf);
        }
        if (this.isMultiSet()) {
            Molecule m;
            Molecule mol = doc != null ? (Molecule)doc.getMainMoleculeGraph() : null;
            try {
                m = this.recordImporter.readMultiSet(mol);
            }
            catch (MRecordParseException ex) {
                throw new MolFormatException(ex);
            }
            if (m != null) {
                if (doc == null) {
                    doc = new MDocument(m);
                }
            } else {
                doc = null;
            }
        } else if (this.isMolMovie()) {
            doc = this.recordImporter.readMolMovie(doc);
        } else {
            try {
                doc = this.recordImporter.readDoc();
            }
            catch (MRecordParseException ex) {
                throw new MolFormatException(ex);
            }
        }
        if (doc != null) {
            this.incNextRecordIndex(true);
        } else {
            this.endReached = true;
        }
        return doc;
    }

    public Molecule readMol(Molecule mol) throws MolFormatException, IOException {
        if (this.objectInputStream != null) {
            Molecule m = this.readMolFromObjectInputStream();
            if (m != null) {
                this.incNextRecordIndex(true);
            }
            return m;
        }
        this.initMolImportIfNeeded();
        try {
            mol = this.isMultiSet() ? this.recordImporter.readMultiSet(mol) : this.recordImporter.readMol(mol);
        }
        catch (MRecordParseException ex) {
            throw new MolFormatException(ex);
        }
        if (mol != null) {
            this.incNextRecordIndex(true);
        } else {
            this.endReached = true;
        }
        return mol;
    }

    public boolean read(Molecule mol) throws IOException {
        if (this.objectInputStream != null) {
            Molecule m = this.readMolFromObjectInputStream();
            if (m != null) {
                this.incNextRecordIndex(true);
                m.clonecopy(mol);
                return true;
            }
            return false;
        }
        this.initMolImportIfNeeded();
        try {
            if (this.isMultiSet()) {
                mol = this.recordImporter.readMultiSet(mol);
            } else {
                Molecule m = this.recordImporter.readMol(mol);
                if (m == null) {
                    this.endReached = true;
                    return false;
                }
            }
        }
        catch (MRecordParseException ex) {
            throw new MolFormatException(ex);
        }
        if (mol != null) {
            this.incNextRecordIndex(true);
            return true;
        }
        this.endReached = true;
        return false;
    }

    private Molecule readMolFromObjectInputStream() throws IOException {
        try {
            Object o = this.objectInputStream.readObject();
            if (o != null) {
                if (o instanceof MDocument) {
                    return (Molecule)((MDocument)o).getMainMoleculeGraph();
                }
                if (o instanceof Molecule) {
                    return (Molecule)o;
                }
            }
            throw new IOException("Serialized object " + o + " is not a molecule");
        }
        catch (EOFException ex) {
            return null;
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Serialized object is of unknown class");
        }
    }

    @Override
    public boolean skipRecord() throws MolFormatException, IOException {
        MRecord r;
        if (this.objectInputStream != null) {
            try {
                this.objectInputStream.readObject();
                this.incNextRecordIndex(false);
                return true;
            }
            catch (ClassNotFoundException ex) {
                this.endReached = true;
                throw new IOException("Cannot skip serialized molecule", ex);
            }
        }
        this.initMolImportIfNeeded();
        try {
            r = this.recordImporter.skipRecord();
        }
        catch (MRecordParseException ex) {
            throw new MolFormatException(ex);
        }
        if (r != null) {
            this.incNextRecordIndex(false);
            return true;
        }
        this.endReached = true;
        return false;
    }

    @Deprecated
    public boolean skipToNext() {
        try {
            return this.skipRecord();
        }
        catch (MolFormatException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public String readRecordAsText() throws MRecordParseException, MolExportException, IOException {
        if (this.objectInputStream != null) {
            try {
                Object o = this.objectInputStream.readObject();
                this.incNextRecordIndex(false);
                if (o instanceof Molecule) {
                    return MolExporter.exportToFormat((Molecule)o, "mrv");
                }
                if (o instanceof MDocument) {
                    return MolExporter.exportToFormat((MDocument)o, "mrv");
                }
                return o.toString();
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }
        this.initMolImportIfNeeded();
        return this.recordImporter.readRecordAsText();
    }

    @Override
    public boolean isRewindable() {
        this.initSeekSupportIfNeeded();
        return this.positions != null;
    }

    @Override
    public void seekRecord(int k, MProgressMonitor pmon) throws EOFException, IOException {
        if (k == this.nextRecordIndex) {
            return;
        }
        if (k > this.nextRecordIndex) {
            int k2 = this.seekForward(k, pmon, 0, null);
            if (k2 != k) {
                throw new EOFException("Cannot seek beyond end of file.");
            }
        } else {
            if (this.objectInputStream != null) {
                throw new IOException("Cannot seek back in object input stream.");
            }
            if (this.isRewindable()) {
                this.initSeekSupportIfNeeded();
                this.recordImporter.seek(this.positions[k], this.lineCounts[k], k);
                this.nextRecordIndex = k;
                if (k <= this.recordCountMax && this.endReached) {
                    this.endReached = false;
                }
            }
        }
    }

    @Override
    protected void seekVisitedRecord(int k) throws IOException {
        this.recordImporter.seek(this.positions[k], this.lineCounts[k], k);
        this.nextRecordIndex = k;
        if (k <= this.recordCountMax && this.endReached) {
            this.endReached = false;
        }
    }

    @Override
    public boolean isEndReached() {
        return this.endReached;
    }

    @Override
    public int estimateNumRecords() {
        int rcount = this.getRecordCountMax();
        if (this.isEndReached()) {
            return rcount;
        }
        long len = 0L;
        long off = this.filePositionMax;
        try {
            len = this.recordImporter.length();
        }
        catch (IOException ex) {
            int n = 2 * this.recordCountReadMax;
            return n;
        }
        if (len != 0L && off != 0L && rcount != 0) {
            int n = (int)Math.round((double)len / (double)off * (double)rcount);
            if (n == rcount) {
                ++n;
            }
            return Math.max(n, rcount);
        }
        return -1;
    }

    public long tell() throws IOException {
        return this.recordImporter.getFilePointer();
    }

    public int getLineCount() {
        this.initSeekSupportIfNeeded();
        return this.lineCounts != null ? this.lineCounts[this.recordCountMax] : this.recordImporter.getLineCount();
    }

    @Override
    public int getRecordCount() {
        return this.nextRecordIndex;
    }

    @Override
    public int getRecordCountMax() {
        return this.recordCountMax;
    }

    private void incNextRecordIndex(boolean read) {
        int k = ++this.nextRecordIndex;
        if (this.objectInputStream == null) {
            this.initSeekSupportIfNeeded();
            long off = this.recordImporter.getFilePointer();
            if (this.positions == null) {
                this.recordCountMax = k;
                this.filePositionMax = off;
            } else {
                if (k >= this.positions.length) {
                    int n = (3 * (k + 1) + 1) / 2;
                    long[] newpos = new long[n];
                    int[] newlc = new int[n];
                    System.arraycopy(this.positions, 0, newpos, 0, k);
                    System.arraycopy(this.lineCounts, 0, newlc, 0, k);
                    this.positions = newpos;
                    this.lineCounts = newlc;
                }
                int lc = this.recordImporter.getLineCount();
                if (k >= this.recordCountMax) {
                    this.recordCountMax = k;
                    this.filePositionMax = off;
                }
                this.positions[k] = off;
                this.lineCounts[k] = lc;
            }
        } else if (k > this.recordCountMax) {
            this.recordCountMax = k;
        }
        if (read && k > this.recordCountReadMax) {
            this.recordCountReadMax = k;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.objectInputStream != null) {
            this.objectInputStream.close();
        } else if (this.recordImporter != null) {
            this.recordImporter.close();
        }
    }

    public String getFormat() {
        if (this.objectInputStream != null) {
            return "chemaxon.struc.Molecule";
        }
        if (this.recordImporter != null) {
            return this.recordImporter.getFormat();
        }
        return null;
    }

    public static Molecule importMol(byte[] b) throws MolFormatException {
        return MolImporter.importMol(b, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Molecule importMol(byte[] b, String opts, String enc) throws MolFormatException {
        Molecule molecule;
        if (b == null) {
            return null;
        }
        MolImporter mi = null;
        ByteArrayInputStream is = new ByteArrayInputStream(b);
        mi = new MolImporter(is, opts, enc);
        if (mi.recordImporter != null) {
            mi.recordImporter.setThreadCount(1);
        }
        if (opts != null && opts.equals("nod2s") && "d2s".equals(mi.getFormat())) {
            throw new MolFormatException("Can't read molecule.");
        }
        try {
            Molecule m = MolImporter.read(mi);
            if (m == null) {
                throw new MolFormatException("Can't read molecule from input.");
            }
            molecule = m;
        }
        catch (Throwable throwable) {
            try {
                mi.close();
                throw throwable;
            }
            catch (MolFormatException ex) {
                throw ex;
            }
            catch (IOException ex) {
                int l = mi != null ? mi.getLineCount() : 0;
                throw MolImporter.toMolFormatException(ex, l);
            }
        }
        mi.close();
        return molecule;
    }

    public static boolean importMol(byte[] b, Molecule mol) throws MolFormatException {
        return MolImporter.importMol(b, null, null, mol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean importMol(byte[] b, String opts, String enc, Molecule mol) throws MolFormatException {
        boolean bl;
        if (b == null) {
            return false;
        }
        MolImporter mi = null;
        ByteArrayInputStream is = new ByteArrayInputStream(b);
        mi = new MolImporter(is, opts, enc);
        if (mi.recordImporter != null) {
            mi.recordImporter.setThreadCount(1);
        }
        if (opts != null && opts.equals("nod2s") && "d2s".equals(mi.getFormat())) {
            throw new MolFormatException("Can't read molecule.");
        }
        try {
            bl = mi.read(mol);
        }
        catch (Throwable throwable) {
            try {
                mi.close();
                throw throwable;
            }
            catch (MolFormatException ex) {
                throw ex;
            }
            catch (IOException ex) {
                int l = mi != null && mi.recordImporter != null ? mi.recordImporter.getLineCount() : 0;
                throw MolImporter.toMolFormatException(ex, l);
            }
        }
        mi.close();
        return bl;
    }

    public static MDocument importDoc(byte[] b) throws MolFormatException {
        return MolImporter.importDoc(b, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MDocument importDoc(byte[] b, String opts, String enc) throws MolFormatException {
        MDocument mDocument;
        if (b == null) {
            return null;
        }
        MolImporter mi = null;
        ByteArrayInputStream is = new ByteArrayInputStream(b);
        mi = new MolImporter(is, opts, enc);
        if (mi.recordImporter != null) {
            mi.recordImporter.setThreadCount(1);
        }
        if (opts != null && opts.equals("nod2s") && "d2s".equals(mi.getFormat())) {
            throw new MolFormatException("Can't read molecule.");
        }
        try {
            mDocument = mi.readDoc(null, null);
        }
        catch (Throwable throwable) {
            try {
                mi.close();
                throw throwable;
            }
            catch (MolFormatException ex) {
                throw ex;
            }
            catch (IOException ex) {
                int l = mi != null && mi.recordImporter != null ? mi.recordImporter.getLineCount() : 0;
                throw MolImporter.toMolFormatException(ex, l);
            }
        }
        mi.close();
        return mDocument;
    }

    private static MolFormatException toMolFormatException(Exception ex, int l) {
        StringBuffer msg = new StringBuffer();
        if (l > 0) {
            msg.append("Line " + l);
            msg.append(": ");
        }
        msg.append(ex.getMessage());
        return new MolFormatException(msg.toString(), ex);
    }

    public static Molecule importMol(String s) throws MolFormatException {
        return MolImporter.importMol(s, (String)null);
    }

    public static Molecule importMol(String s, String opts) throws MolFormatException {
        if (s == null) {
            return null;
        }
        String universalEncoding = "UTF-8";
        try {
            return MolImporter.importMol(s.getBytes(universalEncoding), opts, universalEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This should not happen, UTF-8 is a standard encoding", e);
        }
    }

    @Deprecated
    public static Molecule importMol(String s, String opts, String enc) throws MolFormatException {
        return s == null ? null : MolImporter.importMol(s.getBytes(), opts, enc);
    }

    public static boolean importMol(String s, Molecule mol) throws MolFormatException {
        return s != null && MolImporter.importMol(s.getBytes(), null, null, mol);
    }

    @Deprecated
    public static boolean importMol(String s, String opts, String enc, Molecule mol) throws MolFormatException {
        return s != null && MolImporter.importMol(s.getBytes(), opts, enc, mol);
    }

    public MPropertyContainer getGlobalProperties() {
        return this.recordImporter != null ? this.recordImporter.getGlobalProperties() : null;
    }

    public static MDocument parseMRV(String sval) throws IOException {
        MDocument d = new MDocument(new Molecule());
        MolImporter.parseMRV0(d, sval);
        return d;
    }

    static void parseMRV0(MDocument document, String sval) throws IOException {
        MolInputStream mis;
        byte[] data = sval.getBytes();
        try {
            mis = new MolInputStream(new ByteArrayInputStream(data));
        }
        catch (MolFormatException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new MolFormatException(ex);
        }
        String format2 = mis.getFormat();
        if (format2 != null && format2.equals("mrv")) {
            MolImportModule mi = MFileFormatUtil.getFormat("mrv").createImportModule();
            MDocument d = null;
            mi.initMolImport(mis);
            d = mi.readDocument(document);
            if (d != document) {
                throw new IOException("Cannot parse document");
            }
        } else {
            throw new IOException("argument is not in MRV format");
        }
    }
}

