/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import chemaxon.formats.recognizer.SMILESRecognizer;
import chemaxon.marvin.util.text.MStringTokenizer;

public class AbbrevGroupRecognizer
extends Recognizer {
    public static final int NO = 0;
    public static final int CAN_BE = 1;
    public static final int SURE = 2;
    private boolean needsMore = true;

    public AbbrevGroupRecognizer(String fmt) {
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        int r = AbbrevGroupRecognizer.testLine(line);
        if (r == 0) {
            reclist.remove("abbrevgroup");
            this.needsMore = false;
        } else if (r == 2) {
            reclist.removeAllExcept("abbrevgroup");
            this.needsMore = false;
        } else {
            this.needsMore = linenum < 2;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static int testLine(String line) {
        MStringTokenizer st = new MStringTokenizer(line, '\t', '\u0000');
        if (!st.hasMoreTokens()) {
            return 0;
        }
        String tok = st.nextToken();
        if (!AbbrevGroupRecognizer.canBeAbbrevGroupName(tok)) {
            return 0;
        }
        if (!st.hasMoreTokens()) {
            return 0;
        }
        tok = st.nextToken();
        if (!SMILESRecognizer.canBeSMILES(tok)) {
            return 0;
        }
        int numLeftNames = 0;
        int numRightNames = 0;
        int numCenterAUTO = 0;
        int i = 0;
        while (st.hasMoreTokens()) {
            try {
                String s = st.nextToken();
                if (s.startsWith("leftName=")) {
                    ++numLeftNames;
                    if (!AbbrevGroupRecognizer.canBeAbbrevGroupName(s.substring(9))) {
                        return 0;
                    }
                } else if (s.startsWith("rightName=")) {
                    ++numRightNames;
                    if (!AbbrevGroupRecognizer.canBeAbbrevGroupName(s.substring(10))) {
                        return 0;
                    }
                } else if (s.equals("center=AUTO")) {
                    ++numCenterAUTO;
                } else {
                    Integer.parseInt(s);
                }
            }
            catch (NumberFormatException ex) {
                return 0;
            }
            ++i;
        }
        if (i <= 2) {
            if (numLeftNames != 0 || numRightNames != 0 || numCenterAUTO != 0) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    private static boolean canBeAbbrevGroupName(String s) {
        for (int i = 0; i < s.length(); ++i) {
            boolean letter;
            char c = s.charAt(i);
            boolean bl = letter = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
            if (i == 0 && !letter) {
                return false;
            }
            if (letter || c >= '0' && c <= '9' || c == '-' || c == '+') continue;
            return false;
        }
        return true;
    }
}

