/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class Base64Recognizer
extends Recognizer {
    private boolean needsMore = true;

    public Base64Recognizer(String fmt) {
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (linenum == 1) {
            if (Base64Recognizer.canBeBase64Line(line)) {
                char c;
                if (line.length() > 2 && line.startsWith("H4") && ((c = line.charAt(2)) == 's' || c == 't' || c == 'u' || c == 'v')) {
                    reclist.removeAllExcept("base64");
                    this.needsMore = false;
                }
            } else {
                reclist.remove("base64");
                this.needsMore = false;
            }
        } else if (Base64Recognizer.canBeBase64Line(line)) {
            this.needsMore = false;
        } else {
            reclist.remove("base64");
            this.needsMore = false;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static boolean canBeBase64(String str) {
        BufferedReader br = new BufferedReader(new StringReader(str));
        try {
            String l;
            while ((l = br.readLine()) != null) {
                if (Base64Recognizer.canBeBase64Line(l)) continue;
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean canBeBase64Line(String line) {
        if ((line.length() & 3) != 0) {
            return false;
        }
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '=') {
                if (i == line.length() - 1) {
                    return true;
                }
                if (i == line.length() - 2) {
                    return line.charAt(i + 1) == '=';
                }
                return false;
            }
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '+' || c == '/') continue;
            return false;
        }
        return true;
    }
}

