/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;

public class CDXRecognizer
extends Recognizer {
    private boolean needsMore = true;

    public CDXRecognizer(String fmt) {
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (!line.startsWith("VjCD0100")) {
            reclist.remove("cdx");
            this.needsMore = false;
            return;
        }
        char[] c = line.toCharArray();
        for (int i = 8; i < 12; ++i) {
            byte b = (byte)c[i];
            if (b == 12 - i) continue;
            reclist.remove("cdx");
            this.needsMore = false;
            return;
        }
        reclist.removeAllExcept("cdx");
        this.needsMore = false;
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }
}

