/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import chemaxon.formats.recognizer.RecognizerUtil;

public class CMLRecognizer
extends Recognizer {
    private static int XMLDECL = 0;
    private static int CMLROOT = 1;
    private static int MRV_TAG = 2;
    private static int SVG_TAG = 3;
    private boolean needsMore = true;
    private boolean line1XML = false;

    public CMLRecognizer(String fmt) {
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        int xlev = this.evaluateCmlHeader(line);
        if (xlev == XMLDECL) {
            if (linenum == 1) {
                reclist.removeAllExcept(16384L, 16384L);
                this.line1XML = true;
            } else {
                reclist.remove("cml");
                reclist.remove("mrv");
                reclist.remove("svg");
                this.needsMore = false;
            }
        } else if (xlev == CMLROOT || xlev == MRV_TAG) {
            reclist.removeAllExcept("mrv");
            this.needsMore = false;
        } else if (xlev == SVG_TAG) {
            reclist.removeAllExcept("svg");
            this.needsMore = false;
        } else if (!this.line1XML) {
            reclist.remove("cml");
            reclist.remove("mrv");
            reclist.remove("svg");
            this.needsMore = false;
        }
    }

    private int evaluateCmlHeader(String line) {
        int x;
        String s = line.toLowerCase().trim();
        StringBuffer sb = new StringBuffer(s);
        int xmlLevel = -1;
        if (RecognizerUtil.isXMLHeaderLine(sb.toString())) {
            xmlLevel = XMLDECL;
            x = sb.indexOf(">");
            if (x > -1) {
                sb.delete(0, x + 1);
            }
        }
        if (CMLRecognizer.isCmlLine(sb.toString())) {
            xmlLevel = CMLROOT;
            x = sb.indexOf(">");
            if (x > -1) {
                sb.delete(0, x + 1);
            }
        }
        if (CMLRecognizer.isMrvHeaderLine(sb.toString())) {
            xmlLevel = MRV_TAG;
            x = sb.indexOf(">");
            if (x > -1) {
                sb.delete(0, x + 1);
            }
        }
        if (CMLRecognizer.isMrvLine(sb.toString())) {
            xmlLevel = 1;
            x = sb.indexOf(">");
            if (x > -1) {
                sb.delete(0, x + 1);
            }
        }
        if (CMLRecognizer.isSvgLine(sb.toString())) {
            xmlLevel = SVG_TAG;
            x = sb.indexOf(">");
            if (x > -1) {
                sb.delete(0, x + 1);
            }
        }
        return xmlLevel;
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    private static boolean isCmlLine(String line) {
        String s = line.trim().toLowerCase();
        return s.startsWith("<cml>") || s.startsWith("<cml ");
    }

    private static boolean isMrvHeaderLine(String line) {
        String s = line.trim().toLowerCase();
        return s.startsWith("<mhead>") || s.startsWith("<mhead ");
    }

    private static boolean isMrvLine(String line) {
        String s = line.trim().toLowerCase();
        return s.startsWith("<mdocument>") || s.startsWith("<mdocument ") || s.startsWith("<molecule>") || s.startsWith("<molecule ") || s.startsWith("<reaction>") || s.startsWith("<reaction ");
    }

    private static boolean isSvgLine(String line) {
        String s = line.trim().toLowerCase();
        return s.startsWith("<svg");
    }
}

