/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.RecognizerList;
import chemaxon.formats.recognizer.XYZRecognizer;

public class CubeRecognizer
extends XYZRecognizer {
    public CubeRecognizer(String fmt) {
        super(fmt);
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        if (this.isLastLine() && linenum < 7) {
            reclist.remove("cube");
        }
        if (linenum >= 3) {
            if (linenum >= 3 && linenum < 7) {
                if (!CubeRecognizer.isCubeLine(line, 3)) {
                    reclist.remove("cube");
                }
            } else if (linenum == 7) {
                if (CubeRecognizer.isCubeLine(line, 4)) {
                    reclist.removeAllExcept("cube");
                } else {
                    reclist.remove("cube");
                }
            }
        }
    }

    public static boolean isCubeLine(String line, int count) {
        int i = CubeRecognizer.findNonWS(line, 0);
        if (i < 0) {
            return false;
        }
        int j = CubeRecognizer.findWS(line, i);
        char c = line.charAt(i);
        if (c != '-' && (c < '0' || c > '9')) {
            return false;
        }
        for (int k = i + 1; k < j; ++k) {
            c = line.charAt(k);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return CubeRecognizer.findReals(line, j, count) >= 0;
    }
}

