/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;

public class PDBRecognizer
extends Recognizer {
    public static final int NO = 0;
    public static final int CAN_BE = 1;
    public static final int SURE = 2;
    private static final String[] PDB_RECORD_TYPES_SURE = new String[]{"JRNL  ", "OBSLTE", "CAVEAT", "COMPND", "KEYWDS", "EXPDTA", "REVDAT", "SPRSDE", "DBREF ", "SEQADV", "SEQRES", "MODRES", "FTNOTE", "HETNAM", "HETSYN", "FORMUL", "CRYST1", "CRYST2", "CRYST3", "ORIGX1", "ORIGX2", "ORIGX3", "SCALE1", "SCALE2", "SCALE3", "SIGATM", "HETATM"};
    private static final String[] PDB_RECORD_TYPES_CAN_BE = new String[]{"HEADER", "TITLE ", "SOURCE", "ATOM  ", "REMARK", "AUTHOR", "HET   ", "USER  "};
    private boolean needsMore = true;

    public PDBRecognizer(String fmt) {
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        int r = PDBRecognizer.testLine(line);
        if (r == 2 || r == 1 && linenum >= 2) {
            reclist.removeAllExcept("pdb");
            this.needsMore = false;
        } else if (r == 0) {
            reclist.remove("pdb");
            this.needsMore = false;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static int testLine(String line) {
        String ss;
        String S = line.toUpperCase();
        if (S.length() < 6) {
            return 0;
        }
        int r = PDBRecognizer.testRecord(S.substring(0, 6));
        if (r == 2 || r == 1) {
            return r;
        }
        if (S.startsWith("MODEL     ") && S.length() >= 14 && (ss = S.substring(10, 14).trim()).length() > 0) {
            try {
                Integer.parseInt(ss);
                return 2;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int testRecord(String recName) {
        int i;
        for (i = 0; i < PDB_RECORD_TYPES_SURE.length; ++i) {
            if (!recName.equals(PDB_RECORD_TYPES_SURE[i])) continue;
            return 2;
        }
        for (i = 0; i < PDB_RECORD_TYPES_CAN_BE.length; ++i) {
            if (!recName.equals(PDB_RECORD_TYPES_CAN_BE[i])) continue;
            return 1;
        }
        return 0;
    }
}

