/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.recognizer.Recognizer;
import chemaxon.formats.recognizer.RecognizerList;
import chemaxon.marvin.io.formats.peptide.AminoAcidSource;
import chemaxon.util.StringUtil;
import java.util.StringTokenizer;

public class PeptideRecognizer
extends Recognizer {
    private boolean needsMore = true;
    private String format;
    private boolean emptylines = true;

    public PeptideRecognizer(String fmt) {
        this.format = fmt;
    }

    @Override
    public void tryToRecognize(String line, int linenum, RecognizerList reclist) {
        boolean isEmptyLine;
        boolean bl = isEmptyLine = line == null || line.trim().equals("");
        if (this.format.equals("peptide")) {
            boolean canbe1letter = PeptideRecognizer.canBe1LetterPeptide(line);
            boolean canbe3letter = PeptideRecognizer.canBe3LetterPeptide(line);
            if (!canbe1letter && !canbe3letter) {
                if (!isEmptyLine) {
                    reclist.remove(this.format);
                    reclist.remove("peptide:1");
                    reclist.remove("peptide:3");
                }
                this.needsMore = false;
            } else if (canbe3letter && line.length() >= 6) {
                reclist.removeAllExcept("peptide:3");
                this.needsMore = false;
            }
        } else if (this.format.equals("peptide:1")) {
            if (!PeptideRecognizer.canBe1LetterPeptide(line)) {
                if (!isEmptyLine) {
                    reclist.remove(this.format);
                    this.needsMore = false;
                }
            } else {
                if (PeptideRecognizer.canBe3LetterPeptide(line) && this.isLastLine()) {
                    reclist.remove("peptide:1");
                }
                reclist.remove("peptide");
            }
        } else if (this.format.equals("peptide:3")) {
            if (isEmptyLine || PeptideRecognizer.canBe3LetterPeptide(line)) {
                if (!isEmptyLine && line.length() >= 6) {
                    reclist.removeAllExcept("peptide:3");
                    this.needsMore = false;
                } else if (!isEmptyLine) {
                    reclist.remove("peptide");
                }
            } else {
                reclist.remove(this.format);
                this.needsMore = false;
            }
        }
        this.emptylines &= isEmptyLine;
        if (this.isLastLine() && this.emptylines) {
            reclist.remove("peptide:1");
            reclist.remove("peptide");
        }
        if (linenum > 5) {
            this.needsMore = false;
        }
    }

    @Override
    public boolean needsMore() {
        return this.needsMore;
    }

    public static boolean canBe1LetterPeptide(String s) {
        boolean canBePeptide;
        boolean bl = canBePeptide = !PeptideRecognizer.containsInvalidPeptideChar(s) && PeptideRecognizer.isCustomAAPatternValid(s);
        if (canBePeptide) {
            s = PeptideRecognizer.removeCustomAAs(s);
            String uc = s.toUpperCase();
            canBePeptide = uc.equals(s);
        }
        if (canBePeptide && PeptideRecognizer.isNumberSequence(s)) {
            int xIdx = s.indexOf("X");
            int leftParen = s.indexOf("(");
            int rightParen = s.indexOf(")");
            if (xIdx > leftParen || xIdx > rightParen) {
                canBePeptide = false;
            } else if (xIdx < 0 && (leftParen >= 0 || rightParen >= 0)) {
                canBePeptide = false;
            } else if (xIdx < 0 && leftParen < 0 && rightParen < 0) {
                String nonAcids = "XBJUOZxbjuoz1234567890";
                for (int i = 0; i < s.length() && canBePeptide; ++i) {
                    char c = s.charAt(i);
                    if (c == '-') continue;
                    canBePeptide = nonAcids.indexOf(c) < 0;
                }
            }
        }
        return canBePeptide;
    }

    public static String guessPeptideFormat(String header) {
        String format2 = "peptide:1";
        int fnlIdx = (header = header.trim()).indexOf(10);
        if (fnlIdx >= 0) {
            header = header.substring(0, fnlIdx);
        }
        if (header.length() > 3) {
            format2 = (header = PeptideRecognizer.removeCustomAAs(header)).length() % 3 == 0 && !header.toUpperCase().equals(header) ? "peptide:3" : "peptide:1";
        }
        return format2;
    }

    private static boolean isCustomAAPatternValid(String s) {
        boolean areValidCAAs;
        int xIdx = s.indexOf(88);
        boolean bl = areValidCAAs = xIdx >= 0 || s.indexOf(40) < 0 && s.indexOf(41) < 0;
        if (areValidCAAs) {
            areValidCAAs = PeptideRecognizer.isNumberSequence(s);
        }
        int parenIncr = 0;
        for (int i = 0; i < s.length() && areValidCAAs; ++i) {
            if (s.charAt(i) == '(') {
                ++parenIncr;
            } else if (s.charAt(i) == ')') {
                --parenIncr;
            }
            areValidCAAs = parenIncr >= 0 && parenIncr < 2;
        }
        while (areValidCAAs && xIdx >= 0 && xIdx < s.length() - 1) {
            char next = s.charAt(xIdx + 1);
            areValidCAAs = next == '(';
            s = s.substring(xIdx + 1);
            xIdx = s.indexOf(88);
        }
        return areValidCAAs;
    }

    private static boolean isNumberSequence(String s) {
        boolean numSeq = true;
        if (s.indexOf(40) < 0 || s.indexOf(41) < 0) {
            int sMaxLength = s.length() > 100 ? 100 : s.length();
            String nums = "0123456789";
            for (int i = 0; i < sMaxLength && numSeq; ++i) {
                numSeq = nums.indexOf(s.charAt(i)) < 0;
            }
        }
        return numSeq;
    }

    private static boolean containsInvalidPeptideChar(String s) {
        char c;
        boolean containsInvalidChar = false;
        int sMaxLength = s.length() > 100 ? 100 : s.length();
        String invalidChars = "@#$!%^&*[]+|\\/\"'`.,?~=:;";
        String validNonAlphabetic = "0123456789()-";
        for (int i = 0; i < sMaxLength && !containsInvalidChar; containsInvalidChar |= !Character.isLetter(c) && validNonAlphabetic.indexOf(c) < 0, ++i) {
            c = s.charAt(i);
            containsInvalidChar = invalidChars.indexOf(c) >= 0;
        }
        return containsInvalidChar;
    }

    public static boolean canBe3LetterPeptide(String s) {
        if (s == null || s.trim().equals("")) {
            return false;
        }
        boolean canBeAA = !PeptideRecognizer.containsInvalidPeptideChar(s) && PeptideRecognizer.isCustomAAPatternValid(s) && PeptideRecognizer.isNumberSequence(s);
        StringTokenizer st = new StringTokenizer(s, " \t\n");
        if ((s = st.nextToken().trim()).startsWith("H-")) {
            s = s.substring(2);
        } else if (s.startsWith("OH-")) {
            s = s.substring(3);
        }
        if (s.endsWith("-H")) {
            s = s.substring(0, s.length() - 2);
        } else if (s.endsWith("-OH")) {
            s = s.substring(0, s.length() - 3);
        }
        if (canBeAA && s != null && s.length() > 2) {
            if (PeptideRecognizer.isCorrect3LetterFormat(s = PeptideRecognizer.removeCustomAAs(s))) {
                AminoAcidSource aas = AminoAcidSource.getInstance();
                String[] acids = aas.getImportNamesWithThreeLetters();
                StringUtil.replaceAll(s, "-", "");
                boolean bl = canBeAA = s.length() % 3 == 0;
                if (canBeAA) {
                    for (int i = 0; i < acids.length; ++i) {
                        if (acids[i].equals("H") || acids[i].equals("OH")) continue;
                        s = StringUtil.replaceAll(s, acids[i], "");
                    }
                }
            }
            canBeAA = s.equals("");
        } else {
            canBeAA = false;
        }
        return canBeAA;
    }

    private static boolean isCorrect3LetterFormat(String s) {
        boolean isCorrect;
        boolean bl = isCorrect = s.length() > 2;
        if (isCorrect) {
            int ucIdx = 0;
            for (int i = s.length() - 1; i > 0 && ucIdx == 0; --i) {
                if (!Character.isUpperCase(s.charAt(i))) continue;
                ucIdx = i;
            }
            boolean bl2 = isCorrect = (s = s.substring(0, ucIdx)).length() % 3 == 0;
            if (isCorrect) {
                while (s.length() > 2 && isCorrect) {
                    String chunk = s.substring(0, 3);
                    isCorrect = Character.isUpperCase(chunk.charAt(0)) && Character.isLowerCase(chunk.charAt(1)) && Character.isLowerCase(chunk.charAt(2));
                    s = s.substring(3);
                }
            }
        }
        return isCorrect;
    }

    private static String removeCustomAAs(String p) {
        int lastClosingParen = p.lastIndexOf(41);
        int lastStartParen = p.lastIndexOf(40);
        String tp = p;
        if (lastStartParen >= 0 && lastClosingParen < lastStartParen) {
            tp = tp.substring(0, lastStartParen - 1);
        }
        int spIdx = tp.indexOf(40);
        int epIdx = tp.indexOf(41);
        while (spIdx >= 0 && epIdx >= 0) {
            String ss = tp.substring(0, spIdx);
            String es = tp.substring(epIdx + 1);
            tp = ss + es;
            spIdx = tp.indexOf(40);
            epIdx = tp.indexOf(41);
        }
        tp = StringUtil.replaceAll(tp, "X", "");
        return tp;
    }
}

