/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.formats.recognizer;

import chemaxon.formats.MFileFormat;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.recognizer.Recognizer;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class RecognizerList {
    private List[] recognizerList;
    private List[] formatList;
    private List[] subformatList;
    private boolean[] made;

    RecognizerList(MFileFormat[] mff) throws MolFormatException {
        MFileFormat[][] hierarchy = this.hierarchizeFormats(mff);
        this.recognizerList = new List[hierarchy.length];
        this.formatList = new List[hierarchy.length];
        this.subformatList = new List[hierarchy.length];
        this.made = new boolean[hierarchy.length];
        for (int level = 0; level < hierarchy.length; ++level) {
            this.recognizerList[level] = new ArrayList(hierarchy[level].length);
            this.formatList[level] = new ArrayList(hierarchy[level].length);
            this.subformatList[level] = new ArrayList(hierarchy[level].length);
            this.made[level] = false;
            for (int i = 0; i < hierarchy[level].length; ++i) {
                MFileFormat f = hierarchy[level][i];
                String[] names = f.getNames();
                for (int j = 0; j < names.length; ++j) {
                    this.recognizerList[level].add(null);
                    this.formatList[level].add(f);
                    this.subformatList[level].add(names[j]);
                }
            }
        }
        this.makeLevel(0);
    }

    private RecognizerList(int nlevels) {
        this.recognizerList = new List[nlevels];
        this.formatList = new List[nlevels];
        this.subformatList = new List[nlevels];
        for (int level = 0; level < nlevels; ++level) {
            this.recognizerList[level] = new ArrayList();
            this.formatList[level] = new ArrayList();
            this.subformatList[level] = new ArrayList();
        }
    }

    boolean isLevelMade(int level) {
        return this.made[level];
    }

    public String toString() {
        int n = this.size();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            String fmt = this.getName(i);
            if (i > 0) {
                sb.append(i == n - 1 ? " or " : ", ");
            }
            sb.append(fmt);
        }
        return sb.toString();
    }

    void makeLevel(int level) throws MolFormatException {
        int n = this.recognizerList[level].size();
        ArrayList<Recognizer> reclist = new ArrayList<Recognizer>(n);
        ArrayList<MFileFormat> mfflist = new ArrayList<MFileFormat>(n);
        ArrayList<String> sublist = new ArrayList<String>(n);
        for (int i = 0; i < this.formatList[level].size(); ++i) {
            MFileFormat mff = (MFileFormat)this.formatList[level].get(i);
            String fmt = (String)this.subformatList[level].get(i);
            Recognizer r = mff.createRecognizer(fmt);
            int p = mff.getPriority(fmt);
            boolean inserted = false;
            for (int k = 0; !inserted && k < reclist.size(); ++k) {
                String fmtk = (String)sublist.get(k);
                MFileFormat mffk = (MFileFormat)mfflist.get(k);
                Recognizer rk = (Recognizer)reclist.get(k);
                int pk = mffk.getPriority(fmtk);
                if (p <= pk) continue;
                reclist.add(k, r);
                mfflist.add(k, mff);
                sublist.add(k, fmt);
                inserted = true;
            }
            if (inserted) continue;
            reclist.add(r);
            mfflist.add(mff);
            sublist.add(fmt);
        }
        this.recognizerList[level] = reclist;
        this.formatList[level] = mfflist;
        this.subformatList[level] = sublist;
        this.made[level] = true;
    }

    public int size() {
        int n = 0;
        for (int level = 0; level < this.recognizerList.length; ++level) {
            n += this.recognizerList[level].size();
        }
        return n;
    }

    public int getLevelCount() {
        return this.recognizerList.length;
    }

    public int size(int level) {
        return this.recognizerList[level].size();
    }

    public Recognizer getRecognizer(int level, int i) {
        return (Recognizer)this.recognizerList[level].get(i);
    }

    MFileFormat getFormat(int level, int i) {
        return (MFileFormat)this.formatList[level].get(i);
    }

    String getName(int i) {
        int ii = i;
        for (int level = 0; level < this.subformatList.length; ++level) {
            int n = this.subformatList[level].size();
            if (ii < n) {
                return (String)this.subformatList[level].get(n - ii - 1);
            }
            ii -= n;
        }
        throw new ArrayIndexOutOfBoundsException("Array index out of bounds " + i + " >= " + this.size());
    }

    String getName(int level, int i) {
        return (String)this.subformatList[level].get(i);
    }

    public int[] indicesOf(String format2) {
        for (int level = 0; level < this.getLevelCount(); ++level) {
            for (int i = 0; i < this.size(level); ++i) {
                if (!this.getName(level, i).equals(format2)) continue;
                return new int[]{level, i};
            }
        }
        return null;
    }

    public void remove(String format2) {
        int[] i = this.indicesOf(format2);
        if (i != null) {
            this.remove(i[0], i[1]);
        }
    }

    public void removeAllExcept(String formats) {
        int level;
        StringTokenizer st = new StringTokenizer(formats);
        int n = st.countTokens();
        List[] reclist = new List[this.getLevelCount()];
        List[] mfflist = new List[this.getLevelCount()];
        List[] sublist = new List[this.getLevelCount()];
        for (level = 0; level < this.getLevelCount(); ++level) {
            reclist[level] = new ArrayList();
            mfflist[level] = new ArrayList();
            sublist[level] = new ArrayList();
        }
        for (int i = 0; i < n; ++i) {
            String xfmt = st.nextToken();
            block2: for (int level2 = 0; level2 < this.getLevelCount(); ++level2) {
                for (int j = 0; j < this.size(level2); ++j) {
                    Recognizer rec = this.getRecognizer(level2, j);
                    MFileFormat mff = this.getFormat(level2, j);
                    String fmt = this.getName(level2, j);
                    if (sublist[level2].contains(fmt)) continue block2;
                    if (!fmt.equals(xfmt)) continue;
                    reclist[level2].add(rec);
                    mfflist[level2].add(mff);
                    sublist[level2].add(fmt);
                }
            }
        }
        for (level = 0; level < this.getLevelCount(); ++level) {
            this.recognizerList[level].clear();
            this.formatList[level].clear();
            this.subformatList[level].clear();
            for (int i = 0; i < reclist[level].size(); ++i) {
                this.recognizerList[level].add(reclist[level].get(i));
                this.formatList[level].add(mfflist[level].get(i));
                this.subformatList[level].add(sublist[level].get(i));
            }
        }
    }

    public void removeAllExcept(long flags, long mask) {
        for (int level = 0; level < this.getLevelCount(); ++level) {
            for (int i = this.size(level) - 1; i >= 0; --i) {
                MFileFormat mff = this.getFormat(level, i);
                if (mff.matches(null, flags, mask)) continue;
                this.remove(level, i);
            }
        }
    }

    private void remove(int level, int i) {
        this.recognizerList[level].remove(i);
        this.formatList[level].remove(i);
        this.subformatList[level].remove(i);
    }

    RecognizerList selectByExtension(String fname) {
        RecognizerList r = new RecognizerList(this.getLevelCount());
        for (int level = 0; level < this.getLevelCount(); ++level) {
            for (int i = 0; i < this.size(level); ++i) {
                Recognizer rec = this.getRecognizer(level, i);
                MFileFormat mff = this.getFormat(level, i);
                String fmt = this.getName(level, i);
                String[] exts = mff.getExtensions();
                boolean matches = true;
                if (exts.length != 0) {
                    matches = false;
                    for (int j = 0; j < exts.length; ++j) {
                        if (!fname.endsWith("." + exts[j])) continue;
                        matches = true;
                    }
                }
                if (!matches) continue;
                r.recognizerList[level].add(rec);
                r.formatList[level].add(mff);
                r.subformatList[level].add(fmt);
            }
        }
        return r;
    }

    RecognizerList selectHighestPriority() {
        int minp = Integer.MAX_VALUE;
        for (int level = 0; level < this.getLevelCount(); ++level) {
            for (int i = 0; i < this.size(level); ++i) {
                String fmt;
                MFileFormat mff;
                int p;
                Recognizer rec = this.getRecognizer(level, i);
                if (rec == null || (p = (mff = this.getFormat(level, i)).getPriority(fmt = this.getName(level, i))) >= minp) continue;
                minp = p;
            }
        }
        RecognizerList r = new RecognizerList(this.getLevelCount());
        for (int level = 0; level < this.getLevelCount(); ++level) {
            for (int i = 0; i < this.size(level); ++i) {
                String fmt;
                MFileFormat mff;
                Recognizer rec = this.getRecognizer(level, i);
                if (rec == null || (mff = this.getFormat(level, i)).getPriority(fmt = this.getName(level, i)) != minp) continue;
                r.recognizerList[level].add(rec);
                r.formatList[level].add(mff);
                r.subformatList[level].add(fmt);
            }
        }
        return r;
    }

    private MFileFormat[][] hierarchizeFormats(MFileFormat[] mff) {
        int nlevels = RecognizerList.countLevels(mff);
        int[] num = RecognizerList.countRecognizers(mff, nlevels);
        MFileFormat[][] hierarchy = new MFileFormat[nlevels][];
        for (int i = 0; i < nlevels; ++i) {
            int n = num[i];
            hierarchy[i] = new MFileFormat[n];
            if (n == 0) continue;
            int k = 0;
            for (int j = 0; j < mff.length; ++j) {
                MFileFormat f = mff[j];
                int ord = f.getPriority(null);
                if (ord != i) continue;
                hierarchy[i][k++] = f;
            }
        }
        return hierarchy;
    }

    private static int[] countRecognizers(MFileFormat[] mff, int nlevels) {
        int[] num = new int[nlevels];
        for (int i = 0; i < mff.length; ++i) {
            int ord;
            int n = ord = mff[i].getPriority(null);
            num[n] = num[n] + 1;
        }
        return num;
    }

    private static int countLevels(MFileFormat[] mff) {
        int maxord = -1;
        for (int i = 0; i < mff.length; ++i) {
            int ord = mff[i].getPriority(null);
            if (ord <= maxord) continue;
            maxord = ord;
        }
        return maxord + 1;
    }
}

