/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fragmenter;

import chemaxon.core.calculations.BondClassifier;
import chemaxon.fragmenter.Fragmenter;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import java.io.IOException;
import org.dom4j.Element;

public class CutBondReviser {
    protected Fragmenter fragmenter = null;
    protected BondClassifier classifier = null;
    protected Molecule mol = null;

    public static CutBondReviser create(Element element, Standardizer standardizer, String dir) throws IOException {
        CutBondReviser reviser = null;
        String clname = element.attributeValue("Class");
        if (clname == null) {
            throw new IOException("No reviser class specified.");
        }
        try {
            Class<?> cl = Class.forName(clname);
            reviser = (CutBondReviser)cl.newInstance();
            reviser.init(element, standardizer, dir);
            return reviser;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Reviser class " + clname + " is not found.\nCheck configuration file.");
        }
        catch (InstantiationException e) {
            throw new IOException("Reviser class " + clname + " could not be instantiated: " + e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Reviser class " + clname + " could not be accessed: " + e);
        }
    }

    protected void init(Element element, Standardizer standardizer, String dir) throws IOException {
    }

    protected void setFragmenter(Fragmenter fragmenter) {
        this.fragmenter = fragmenter;
        this.classifier = fragmenter.getClassifier();
    }

    protected void setMolecule(Molecule mol) throws SearchException {
        this.mol = mol;
    }

    protected Molecule getMolecule() {
        return this.mol;
    }

    public boolean revise(int a1, int a2) {
        return !this.classifier.isRingBond(a1, a2);
    }

    public void set(int a1, int a2) {
    }

    public void clear(int a1, int a2) {
    }
}

