/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fragmenter;

import chemaxon.fragmenter.CutBondReviser;
import chemaxon.fragmenter.Fragmenter;
import chemaxon.fragmenter.FragmenterConfig;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RxnMolecule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExhaustiveFragmenter
extends Fragmenter {
    private int maxsetcount = Integer.MAX_VALUE;
    private boolean extensive = false;
    private ArrayList hitlist = new ArrayList();
    private ArrayList cutlist = new ArrayList();
    private ArrayList cutsets = new ArrayList();
    private int[] cutset = null;
    private String fragmentset = null;

    public ExhaustiveFragmenter(File file) throws SearchException {
        try {
            FragmenterConfig fc = new FragmenterConfig(file);
            this.init(fc);
        }
        catch (IOException e) {
            throw new SearchException(e.getMessage());
        }
    }

    public ExhaustiveFragmenter(String xmlstr) throws SearchException {
        try {
            FragmenterConfig fc = new FragmenterConfig(xmlstr);
            this.init(fc);
        }
        catch (IOException e) {
            throw new SearchException(e.getMessage());
        }
    }

    public ExhaustiveFragmenter(InputStream is) throws SearchException {
        try {
            FragmenterConfig fc = new FragmenterConfig(is);
            this.init(fc);
        }
        catch (IOException e) {
            throw new SearchException(e.getMessage());
        }
    }

    public ExhaustiveFragmenter(RxnMolecule[] reactions, Standardizer standardizer) throws SearchException {
        this(reactions, standardizer, null);
    }

    private void init(FragmenterConfig fc) throws IOException, SearchException {
        this.init(fc.getReactions(), fc.getStandardizer(), fc.getReviser());
        this.setParams(fc.getMaxFragmentCount(), fc.getMaxSetCount(), fc.isExtensive());
        this.setFragmentSetsTag(fc.getFragmentSetsTag());
        this.setCountTag(fc.getCountTag());
        this.collect(fc.getUidTag(), fc.getCutIdsTag(), fc.getCutCountsTag(), fc.getCutSumTag(), fc.getReactionIDs());
    }

    public ExhaustiveFragmenter(RxnMolecule[] reactions, Standardizer standardizer, CutBondReviser reviser) throws SearchException {
        super(reactions, standardizer, reviser);
    }

    private void setParams(int maxfragcount, int maxsetcount, boolean extensive) {
        this.setMaxFragmentCount(maxfragcount);
        this.setMaxSetCount(maxsetcount);
        this.setExtensive(extensive);
    }

    public void setMaxSetCount(int maxsetcount) {
        this.maxsetcount = maxsetcount;
    }

    public void setExtensive(boolean extensive) {
        this.extensive = extensive;
    }

    @Override
    protected void find() throws SearchException {
        int[][] hits = null;
        for (int i = 0; i < this.cbs.length; ++i) {
            Fragmenter.CutBondSearch r = this.cbs[i];
            hits = r.searcher.findAll();
            if (hits == null) continue;
            for (int j = 0; j < hits.length; ++j) {
                int k = 0;
                while (k < r.cuts.length) {
                    this.cutlist.add(new int[]{i, k++, this.hitlist.size()});
                }
                this.hitlist.add(hits[j]);
            }
        }
        int n = this.cutlist.size();
        if (this.maxfragmentcount < n + 1) {
            n = this.maxfragmentcount - 1;
        }
        this.cutset = new int[n];
        try {
            this.findCuts(0);
        }
        catch (FragmentSetLimitException fragmentSetLimitException) {
            // empty catch block
        }
    }

    private int findCuts(int t) throws FragmentSetLimitException {
        if (this.cutsets.size() >= this.maxsetcount) {
            throw new FragmentSetLimitException();
        }
        if (t == this.cutset.length) {
            if (!this.sameCutSet(t)) {
                this.storeCutSet(t);
            }
            return t;
        }
        int s = t == 0 ? 0 : this.cutset[t - 1] + 1;
        int size = this.cutlist.size();
        boolean extended = false;
        for (int i = 0; i < size; ++i) {
            int j;
            for (j = 0; j < t && this.cutset[j] != i; ++j) {
            }
            if (j < t) continue;
            int[] cutinfo = (int[])this.cutlist.get(i);
            int cbsind = cutinfo[0];
            int cutind = cutinfo[1];
            int hitind = cutinfo[2];
            if (!this.activeHit(hitind, cbsind)) continue;
            Fragmenter.CutBondSearch r = this.cbs[cbsind];
            int[] hit = (int[])this.hitlist.get(hitind);
            int a1 = hit[r.cuts[cutind][0]];
            int a2 = hit[r.cuts[cutind][1]];
            if (a1 < 0 || a2 < 0 || !this.reviser.revise(a1, a2)) continue;
            this.reviser.set(a1, a2);
            this.setCutBond(a1, a2, hitind);
            this.cutset[t] = i;
            this.findCuts(t + 1);
            this.reviser.clear(a1, a2);
            this.clearCutBond(a1, a2);
            extended = true;
        }
        if (this.extensive) {
            if (!this.sameCutSet(t)) {
                this.storeCutSet(t);
            }
        } else if (!extended && !this.subCutSet(t)) {
            this.storeCutSet(t);
        }
        return t;
    }

    private void storeCutSet(int n) {
        int[] currcutset = new int[n];
        System.arraycopy(this.cutset, 0, currcutset, 0, n);
        Arrays.sort(currcutset);
        if (!this.extensive) {
            block0: for (int i = this.cutsets.size() - 1; i >= 0; --i) {
                int[] c = (int[])this.cutsets.get(i);
                if (c.length > n) continue;
                int k = 0;
                for (int j = 0; j < n && currcutset[j] <= c[k]; ++j) {
                    if (currcutset[j] != c[k] || ++k != c.length) continue;
                    this.cutsets.remove(i);
                    continue block0;
                }
            }
        }
        this.cutsets.add(currcutset);
    }

    private boolean sameCutSet(int n) {
        for (int i = this.cutsets.size() - 1; i >= 0; --i) {
            int[] c = (int[])this.cutsets.get(i);
            if (c.length != n || !this.subCutSet(n, c)) continue;
            return true;
        }
        return false;
    }

    private boolean subCutSet(int n) {
        for (int i = this.cutsets.size() - 1; i >= 0; --i) {
            int[] c = (int[])this.cutsets.get(i);
            if (!this.subCutSet(n, c)) continue;
            return true;
        }
        return false;
    }

    private boolean subCutSet(int n, int[] c) {
        for (int j = 0; j < n; ++j) {
            int k;
            int x = this.cutset[j];
            for (k = 0; k < c.length && c[k] < x; ++k) {
            }
            if (k != c.length && c[k] <= x) continue;
            return false;
        }
        return true;
    }

    private boolean activeHit(int hitind, int cbsind) {
        int[] hit = (int[])this.hitlist.get(hitind);
        Fragmenter.CutBondSearch r = this.cbs[cbsind];
        for (int i = 0; i < r.bonds.length; ++i) {
            int cuthitind = this.getCutBond(hit[r.bonds[i][0]], hit[r.bonds[i][1]]);
            if (cuthitind == -1 || cuthitind == hitind) continue;
            return false;
        }
        return true;
    }

    @Override
    public void create(List coll) {
        int size = this.cutsets.size();
        for (int i = 0; i < size; ++i) {
            this.clearCutBonds();
            int[] cutset = (int[])this.cutsets.get(i);
            for (int j = 0; j < cutset.length; ++j) {
                int[] cutinfo = (int[])this.cutlist.get(cutset[j]);
                int cbsind = cutinfo[0];
                Fragmenter.CutBondSearch r = this.cbs[cbsind];
                int cutind = cutinfo[1];
                int[] hit = (int[])this.hitlist.get(cutinfo[2]);
                this.setCutBond(hit[r.cuts[cutind][0]], hit[r.cuts[cutind][1]], cbsind, r.maps[cutind][0], r.maps[cutind][1]);
            }
            if (this.fragmentsetsTag != null) {
                this.fragmentset = String.valueOf(i + 1);
            }
            super.create(coll);
        }
        this.hitlist.clear();
        this.cutlist.clear();
        this.cutsets.clear();
    }

    @Override
    protected void setTags(Molecule frag) {
        super.setTags(frag);
        if (this.fragmentsetsTag != null) {
            String sets = frag.getProperty(this.fragmentsetsTag);
            if (sets == null) {
                frag.setProperty(this.fragmentsetsTag, this.fragmentset);
            } else {
                frag.setProperty(this.fragmentsetsTag, sets + "," + this.fragmentset);
            }
        }
    }

    static class FragmentSetLimitException
    extends Exception {
        public FragmentSetLimitException() {
        }

        public FragmentSetLimitException(String msg) {
            super(msg);
        }
    }
}

