/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fragmenter;

import chemaxon.core.util.BondTable;
import chemaxon.fragmenter.CutBondReviser;
import chemaxon.fragmenter.RecapConfig;
import chemaxon.reaction.Standardizer;
import chemaxon.sss.search.MolSearch;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.Arrays;
import org.dom4j.Element;

public class Recap
extends CutBondReviser {
    private int[][] atom2hitinds = null;
    private int[] atom2cutcount = null;
    private int[] atom2rootdfs = null;
    private int[] atom2dfs = null;
    private int[] dfs2atom = null;
    private int[][] ctab = null;
    private MolSearch searcher = new MolSearch();
    private Molecule[] notlist = null;
    private int maxcutcount = Integer.MAX_VALUE;
    private int minatomcount = 0;
    private boolean cutRingCHetero = true;
    private int acut = -1;
    private int[] join = null;

    public Recap() {
    }

    public Recap(Molecule[] notlist, int maxcutcount, int minatomcount, boolean cutRingCHetero) {
        this.notlist = notlist;
        this.maxcutcount = maxcutcount;
        this.minatomcount = minatomcount;
        this.cutRingCHetero = cutRingCHetero;
    }

    @Override
    protected void init(Element element, Standardizer standardizer, String dir) throws IOException {
        RecapConfig config = new RecapConfig(element, dir);
        this.notlist = config.getNotlist();
        if (standardizer != null) {
            for (int i = 0; i < this.notlist.length; ++i) {
                try {
                    standardizer.standardize(this.notlist[i]);
                    continue;
                }
                catch (SearchException e) {
                    throw new IOException("Standardization failed for molecule " + (i + 1) + " in the notlist section: " + e.getMessage());
                }
            }
        }
        this.maxcutcount = config.getMaxCutCount();
        this.minatomcount = config.getMinAtomCount();
        this.cutRingCHetero = config.getCutRingCHetero();
    }

    public void setNotlist(Molecule[] notlist) {
        this.notlist = notlist;
    }

    public void setMaxCutCount(int maxcutcount) {
        this.maxcutcount = maxcutcount;
    }

    public void setMinAtomCount(int minatomcount) {
        this.minatomcount = minatomcount;
    }

    public void setCutRingCHetero(boolean cutRingCHetero) {
        this.cutRingCHetero = cutRingCHetero;
    }

    @Override
    protected void setMolecule(Molecule mol) throws SearchException {
        super.setMolecule(mol);
        this.ctab = mol.getCtab();
        int n = mol.getAtomCount();
        this.alloc(n);
        for (int a = 0; a < n; ++a) {
            if (this.atom2hitinds[a] == null) continue;
            this.atom2hitinds[a][0] = -1;
        }
        int joinlen = 0;
        int hitind = 0;
        int[] hit = null;
        this.searcher.setTarget(mol);
        for (int i = 0; i < this.notlist.length; ++i) {
            this.searcher.setQuery(this.notlist[i]);
            while ((hit = this.searcher.findNext()) != null) {
                if (this.ringbondProtected(hit, this.notlist[i])) continue;
                for (int j = 0; j < hit.length; ++j) {
                    int a = hit[j];
                    if (this.atom2hitinds[a] == null) {
                        this.atom2hitinds[a] = new int[4];
                        this.atom2hitinds[a][0] = -1;
                    }
                    int len = this.atom2hitinds[a].length;
                    int k = 0;
                    while (this.atom2hitinds[a][k] != -1) {
                        ++k;
                    }
                    if (k == len - 1) {
                        int[] tmp = this.atom2hitinds[a];
                        this.atom2hitinds[a] = new int[len + 4];
                        System.arraycopy(tmp, 0, this.atom2hitinds[a], 0, len);
                    }
                    this.atom2hitinds[a][k] = hitind;
                    this.atom2hitinds[a][k + 1] = -1;
                    joinlen = Math.max(this.atom2hitinds[a].length, joinlen);
                }
                ++hitind;
            }
        }
        if (this.join == null || this.join.length < joinlen) {
            this.join = new int[joinlen];
        }
        Arrays.fill(this.atom2cutcount, 0);
        for (int a = 0; a < n; ++a) {
            this.atom2rootdfs[a] = this.classifier.getRootDFS(a);
        }
        int d = 0;
        while (d < n) {
            int a;
            this.dfs2atom[d] = a = this.classifier.getAtomIndex(d);
            this.atom2dfs[a] = d++;
        }
    }

    @Override
    public boolean revise(int a1, int a2) {
        if (this.isH(a1) || this.isH(a2)) {
            return false;
        }
        if (!this.cutRingCHetero && this.ringCnonC(a1, a2)) {
            return false;
        }
        if (this.classifier.isRingBond(a1, a2)) {
            return false;
        }
        int dfs1 = this.atom2dfs[a1];
        int dfs2 = this.atom2dfs[a2];
        if (dfs1 > dfs2) {
            int tmp = dfs1;
            dfs1 = dfs2;
            dfs2 = tmp;
            tmp = a1;
            a1 = a2;
            a2 = tmp;
        }
        this.cut(a1, a2);
        if (!this.countersOK(a1, a2)) {
            return false;
        }
        return !this.notlisthit1(a1, a2) && !this.notlisthit2(a1, a2);
    }

    private boolean isH(int a) {
        return a < 0 || this.mol.getAtom(a).getAtno() == 1;
    }

    private boolean ringCnonC(int a1, int a2) {
        return this.classifier.isRingAtom(a1) && this.mol.getAtom(a1).getAtno() == 6 && this.mol.getAtom(a2).getAtno() != 6 || this.classifier.isRingAtom(a2) && this.mol.getAtom(a2).getAtno() == 6 && this.mol.getAtom(a1).getAtno() != 6;
    }

    private void cut(int a1, int a2) {
        this.acut = a1;
        int dfs = this.atom2dfs[a1];
        int dfs2 = this.atom2dfs[a2];
        int dfsr = this.atom2rootdfs[a1];
        int state = 1;
        while (state == 1) {
            state = 0;
            int dfsa = dfs;
            int[] na = this.ctab[this.acut];
            for (int i = 0; i < na.length; ++i) {
                if (this.atom2rootdfs[na[i]] != dfsr) continue;
                int d = this.atom2dfs[na[i]];
                if (d > dfs2) {
                    if (state == 2 && d >= dfs) continue;
                    this.acut = na[i];
                    dfs = d;
                    state = 2;
                    continue;
                }
                if (state == 2 || d >= dfsa || state == 1 && d <= dfs) continue;
                this.acut = na[i];
                dfs = d;
                state = 1;
            }
        }
    }

    private boolean countersOK(int a1, int a2) {
        int a0;
        int dfsr = this.atom2rootdfs[a1];
        int dfs2 = this.atom2dfs[a2];
        int dfsa = this.atom2dfs[this.acut];
        int cutcount1 = 0;
        int cutcount2 = 0;
        int atomcount1 = 0;
        int atomcount2 = 0;
        for (int d = dfsr; d < this.ctab.length && this.atom2rootdfs[a0 = this.dfs2atom[d]] == dfsr; ++d) {
            if (d < dfs2 || d >= dfsa && dfsa > dfs2) {
                if (this.mol.getAtom(a0).getAtno() != 1) {
                    ++atomcount1;
                }
                if ((cutcount1 += this.atom2cutcount[a0]) < this.maxcutcount) continue;
                return false;
            }
            if (this.mol.getAtom(a0).getAtno() != 1) {
                ++atomcount2;
            }
            if ((cutcount2 += this.atom2cutcount[a0]) < this.maxcutcount) continue;
            return false;
        }
        return atomcount1 >= this.minatomcount && atomcount2 >= this.minatomcount;
    }

    private boolean notlisthit1(int a1, int a2) {
        if (this.atom2hitinds[a1] == null || this.atom2hitinds[a1][0] == -1) {
            return false;
        }
        int dfsr = this.atom2rootdfs[a1];
        int r = this.dfs2atom[dfsr];
        if (this.atom2hitinds[r] == null || this.atom2hitinds[r][0] == -1) {
            return false;
        }
        System.arraycopy(this.atom2hitinds[r], 0, this.join, 0, this.atom2hitinds[r].length);
        int dfs2 = this.atom2dfs[a2];
        int dfs = this.atom2dfs[this.acut];
        for (int d = dfsr + 1; d < this.ctab.length && this.atom2rootdfs[this.dfs2atom[d]] == dfsr; ++d) {
            if (d == dfs2) {
                if (dfs < dfs2) {
                    return true;
                }
                d = dfs;
            }
            this.joinhitinds(this.join, this.atom2hitinds[this.dfs2atom[d]]);
            if (this.join[0] != -1) continue;
            return false;
        }
        return true;
    }

    private boolean notlisthit2(int a1, int a2) {
        if (this.atom2hitinds[a2] == null || this.atom2hitinds[a2][0] == -1) {
            return false;
        }
        System.arraycopy(this.atom2hitinds[a2], 0, this.join, 0, this.atom2hitinds[a2].length);
        int dfs2 = this.atom2dfs[a2];
        int dfs = this.atom2dfs[this.acut];
        int dfsr = this.atom2rootdfs[a1];
        for (int d = dfs2 + 1; d < this.ctab.length && this.atom2rootdfs[this.dfs2atom[d]] == dfsr; ++d) {
            if (d == dfs) {
                return true;
            }
            this.joinhitinds(this.join, this.atom2hitinds[this.dfs2atom[d]]);
            if (this.join[0] != -1) continue;
            return false;
        }
        return true;
    }

    private void joinhitinds(int[] h1, int[] h2) {
        int i1 = 0;
        int i2 = 0;
        int j = 0;
        if (h2 != null) {
            while (h1[i1] != -1 && h2[i2] != -1) {
                if (h1[i1] == h2[i2]) {
                    h1[j++] = h1[i1++];
                    continue;
                }
                if (h1[i1] < h2[i2]) {
                    ++i1;
                    continue;
                }
                ++i2;
            }
        }
        h1[j] = -1;
    }

    @Override
    public void set(int a1, int a2) {
        int a;
        int d;
        int dfs1 = this.atom2dfs[a1];
        int dfs2 = this.atom2dfs[a2];
        int dfs = this.atom2dfs[this.acut];
        if (dfs1 > dfs2) {
            int tmp = dfs1;
            dfs1 = dfs2;
            dfs2 = tmp;
            tmp = a1;
            a1 = a2;
            a2 = tmp;
        }
        int dfsr = this.atom2rootdfs[a1];
        int m = this.ctab.length;
        int k = 0;
        for (d = dfs2; d < this.ctab.length; ++d) {
            a = this.dfs2atom[d];
            if (d == dfs || this.atom2rootdfs[a] != dfsr) {
                m = d;
                break;
            }
            ++k;
        }
        if (dfs > dfs2) {
            int a3;
            int d2;
            m = this.ctab.length;
            int t = 0;
            for (d2 = dfs; d2 < this.ctab.length; ++d2) {
                a3 = this.dfs2atom[d2];
                if (this.atom2rootdfs[a3] != dfsr) {
                    m = d2;
                    break;
                }
                int n = a3;
                this.atom2dfs[n] = this.atom2dfs[n] - k;
                ++t;
            }
            for (d2 = dfs2; d2 < dfs; ++d2) {
                int n = a3 = this.dfs2atom[d2];
                this.atom2dfs[n] = this.atom2dfs[n] + t;
            }
            for (a = 0; a < this.ctab.length; ++a) {
                this.dfs2atom[this.atom2dfs[a]] = a;
            }
        }
        dfs2 = this.atom2dfs[a2];
        for (d = m - k; d < m; ++d) {
            this.atom2rootdfs[this.dfs2atom[d]] = dfs2;
        }
        int n = a1;
        this.atom2cutcount[n] = this.atom2cutcount[n] + 1;
        int n2 = a2;
        this.atom2cutcount[n2] = this.atom2cutcount[n2] + 1;
        this.acut = -1;
    }

    @Override
    public void clear(int a1, int a2) {
        int a;
        int d;
        int dfs1 = this.atom2dfs[a1];
        int dfs2 = this.atom2dfs[a2];
        if (dfs1 > dfs2) {
            int tmp = dfs1;
            dfs1 = dfs2;
            dfs2 = tmp;
            tmp = a1;
            a1 = a2;
            a2 = tmp;
        }
        int dfsr1 = this.atom2rootdfs[a1];
        int dfsr2 = this.atom2rootdfs[a2];
        int dfsdiff = dfs2 - dfs1 - 1;
        int k = 0;
        for (d = dfs2; d < this.ctab.length && this.atom2rootdfs[a = this.dfs2atom[d]] == dfsr2; ++d) {
            int n = a;
            this.atom2dfs[n] = this.atom2dfs[n] - dfsdiff;
            this.atom2rootdfs[a] = dfsr1;
            ++k;
        }
        for (d = dfs1 + 1; d < dfs2; ++d) {
            int n = a = this.dfs2atom[d];
            this.atom2dfs[n] = this.atom2dfs[n] + k;
            if (this.atom2rootdfs[a] == dfsr1) continue;
            int n2 = a;
            this.atom2rootdfs[n2] = this.atom2rootdfs[n2] + k;
        }
        for (int a3 = 0; a3 < this.ctab.length; ++a3) {
            this.dfs2atom[this.atom2dfs[a3]] = a3;
        }
        int n = a1;
        this.atom2cutcount[n] = this.atom2cutcount[n] - 1;
        int n3 = a2;
        this.atom2cutcount[n3] = this.atom2cutcount[n3] - 1;
    }

    private boolean ringbondProtected(int[] hit, Molecule frag) {
        BondTable btab = frag.getBondTable();
        for (int i = 0; i < hit.length; ++i) {
            for (int j = i + 1; j < hit.length; ++j) {
                if (btab.getBondIndex(i, j) != -1 || !this.classifier.isRingBond(hit[i], hit[j])) continue;
                return true;
            }
        }
        return false;
    }

    private void alloc(int capacity) {
        int n;
        int n2 = n = this.dfs2atom != null ? this.dfs2atom.length : 1;
        while (n < capacity) {
            n <<= 1;
        }
        if (this.dfs2atom == null || n > this.dfs2atom.length) {
            this.atom2hitinds = new int[n][];
            this.atom2cutcount = new int[n];
            this.atom2rootdfs = new int[n];
            this.atom2dfs = new int[n];
            this.dfs2atom = new int[n];
        }
    }
}

