/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.fragmenter;

import chemaxon.formats.MolImporter;
import chemaxon.struc.Molecule;
import chemaxon.util.ConfigTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class RecapConfig {
    private Molecule[] notlist = null;
    private int maxcutcount = Integer.MAX_VALUE;
    private int minatomcount = 0;
    private boolean cutRingCHetero = false;
    private String dir = null;

    public RecapConfig(File file) throws IOException {
        this.dir = file.getParent();
        this.readConfig(file);
    }

    public RecapConfig(Element root, String dir) throws IOException {
        this.dir = dir;
        this.readConfig(root);
    }

    public Molecule[] getNotlist() {
        return this.notlist;
    }

    public int getMaxCutCount() {
        return this.maxcutcount;
    }

    public int getMinAtomCount() {
        return this.minatomcount;
    }

    public boolean getCutRingCHetero() {
        return this.cutRingCHetero;
    }

    public void readConfig(File file) throws IOException {
        Element root = null;
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(file);
            root = doc.getRootElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Error occured during XML parsing.");
        }
        this.readConfig(root);
    }

    public void readConfig(Element root) throws IOException {
        Element notlistRoot = (Element)root.selectSingleNode("Notlist");
        Element paramsRoot = (Element)root.selectSingleNode("Params");
        this.setNotlist((Node)notlistRoot);
        this.setParams(paramsRoot);
    }

    public void setNotlist(Node root) throws IOException {
        ArrayList<Molecule> v = new ArrayList<Molecule>();
        if (root != null) {
            List children = root.selectNodes("Mol");
            int n = children.size();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)children.get(i);
                String type = element.attributeValue("Type");
                String structure = element.attributeValue("Structure");
                if (structure == null) {
                    throw new IOException("Structure attribute is mandatory for Mol elements.");
                }
                MolImporter importer = ConfigTools.getQueryMolImporter(structure, type, this.dir);
                Molecule mol = null;
                while ((mol = importer.read()) != null) {
                    v.add(mol);
                }
                importer.close();
            }
        }
        this.notlist = new Molecule[v.size()];
        v.toArray(this.notlist);
    }

    public void setParams(Element root) throws IOException {
        if (root != null) {
            Element limits = (Element)root.selectSingleNode("Limits");
            Element options = (Element)root.selectSingleNode("Options");
            if (limits != null) {
                String minatomsAttr;
                String maxcutsAttr = limits.attributeValue("MaxCutCount");
                if (maxcutsAttr != null) {
                    try {
                        this.maxcutcount = Integer.parseInt(maxcutsAttr);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("MaxCutCount is not an integer: " + maxcutsAttr);
                    }
                }
                if ((minatomsAttr = limits.attributeValue("MinAtomCount")) != null) {
                    try {
                        this.minatomcount = Integer.parseInt(minatomsAttr);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("MinAtomCount is not an integer: " + minatomsAttr);
                    }
                }
            }
            if (options != null) {
                String cutRingCHeteroStr = options.attributeValue("CutRingCHetero", "");
                this.cutRingCHetero = cutRingCHeteroStr.equalsIgnoreCase("true");
            }
        }
    }
}

