/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem;

import chemaxon.jchem.Command;
import chemaxon.jchem.db.DatabaseConstants;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.gui.JChemFrame;
import chemaxon.util.SupportedPlatform;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JChemManager {
    private static final Logger logger = Logger.getLogger(JChemManager.class.getName());
    JChemFrame mainWindow;

    public void init() {
        this.mainWindow = new JChemFrame();
        this.mainWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        SwingUtilities.updateComponentTreeUI(this.mainWindow);
        this.mainWindow.setVisible(true);
        try {
            SupportedPlatform.showWarningIfNeeded(this.mainWindow, this.mainWindow.getSettings());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void connect() {
        this.mainWindow.connect();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            Command.main(args);
        } else {
            final JChemManager manager = new JChemManager();
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        manager.init();
                    }
                });
                manager.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        String lf = null;
        Properties p = null;
        SettingsHandler sh = null;
        try {
            sh = new SettingsHandler(DatabaseConstants.getDefaultDerbySettings());
            p = sh.getSettings();
            lf = p.getProperty("gui.lookAndFeel.className");
            if (lf == null) {
                lf = UIManager.getSystemLookAndFeelClassName();
                p.put("gui.lookAndFeel.className", lf);
            }
            UIManager.setLookAndFeel(lf);
        }
        catch (Exception e) {
            logger.throwing("JChemManager", "init", e);
            System.err.println("Warning: Couldn't set Look and Feel: " + lf);
            System.err.println("Restoring system look and feel.");
            lf = UIManager.getSystemLookAndFeelClassName();
            p.put("gui.lookAndFeel.className", lf);
            try {
                UIManager.setLookAndFeel(lf);
            }
            catch (Exception e1) {}
        }
        catch (InternalError e) {
            // empty catch block
        }
        try {
            sh.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

