/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem;

import chemaxon.formats.MolExporter;
import chemaxon.formats.MolImporter;
import chemaxon.jchem.SearchBase;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.sss.search.MarkushGenerator;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.RGroupDecomposition;
import chemaxon.sss.search.SearchException;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.CLQ;
import chemaxon.util.ConfigTools;
import chemaxon.util.MolHandler;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class RGDecomp
extends SearchBase {
    private static final String strhelp = "R-group decomposition " + VersionInfo.JCHEM_VERSION + ", (C) 1999-2012 ChemAxon Ltd." + lineSep + "Usage:" + lineSep + "  rgdecomp [options] -q <query file/string> [target file(s)/string(s)]" + lineSep + lineSep + "Options:" + lineSep + "  -h, --help                             this help message" + lineSep + "  --undefinedRAtom:g/gh/ghe              Describes the matching of an undefined " + lineSep + "                                         R-atom in query. Effective only when" + lineSep + "                                         --exactQueryAtomMatching is not set." + lineSep + "      Values:" + lineSep + "        g   Undefined R-atom matches a group of" + lineSep + "            one or more connected atoms in target," + lineSep + "            including at least one heavy atom." + lineSep + "        gh  Undefined R-atom matches a group of " + lineSep + "            one or more connected atoms in target," + lineSep + "            which can also be a single H atom." + lineSep + "            Default when query originally contains R-atoms." + lineSep + "        ghe Undefined R-atom matches a group of " + lineSep + "            one or more connected atoms in target," + lineSep + "            which can also be a single H atom or the empty set" + lineSep + "            (empty set match is allowed for isolated or" + lineSep + "            one-attachment R-atoms only)." + lineSep + "            Default when query does not contain R-atoms and" + lineSep + "            R-atoms added automatically in place of implicit H-s." + lineSep + "  --bridgingRAllowed:n/y        Forbid/allow different R-atoms matching" + lineSep + "                                the same group. Default is n." + lineSep + "  --RLigandEqualityCheck:y/n    Switch on/off the requirement that R-atoms" + lineSep + "                                with the same R-group ID should match ligands" + lineSep + "                                with the same structure. Default is y." + lineSep + lineSep + "Input options:" + lineSep + "  -q, --query <query>                    Query SMARTS string or file." + lineSep + "  -m, --query-modification <Ra|Rs>       Query modification options:" + lineSep + "                                         Ra, Rs: attach unique rgroup nodes" + lineSep + "                                                 in place of missing bonds" + lineSep + "                                                 Ra: with any-bonds" + lineSep + "                                                 Rs: with single-bonds" + lineSep + "  -S, --standardize <file/string>        Standardize query and target" + lineSep + "                                         according to config file/string." + lineSep + "                                         Default: -S 'aromatize'." + lineSep + "                                         Set -S '' to skip standardization." + lineSep + "  -g, --ignore-error                     Continue with next molecule on error." + lineSep + lineSep + "Output options:" + lineSep + "  -a, --attachment-symbol <N|P|A|M|L|R>  attachment symbol on ligands:" + lineSep + "                                         N: none" + lineSep + "                                         P: R-group attachment" + lineSep + "                                         A: any-atom (default)" + lineSep + "                                         M: atom map" + lineSep + "                                         L: atom label" + lineSep + "                                         R: atom label with 'R' prefix" + lineSep + "  -s, --style <HTS>                      output style (multiple choice):" + lineSep + "                                         H: include header (default)" + lineSep + "                                         T: include target (default)" + lineSep + "                                         S: include scaffold" + lineSep + "  -i, --id <ID field>                    ID field in target," + lineSep + "                                         to be displayed in SMILES table output" + lineSep + "                                         set '=' to display target index as ID" + lineSep + "  -k, --keep-coordinates                 keep coordinates of structures" + lineSep + "                                         (otherwise align for 2D output)" + lineSep + "  -M, --Markush                          generate Markush output" + lineSep + "                                         (if set, then the above four" + lineSep + "                                         output options are ignored)" + lineSep + "  -f, --format <format>                  output file format" + lineSep + "                                         (default: SMILES table" + lineSep + "                                         for decomposition," + lineSep + "                                         MOL for Markush output)," + lineSep + "                                         molecule (series) output otherwise" + lineSep + "  -o, --output <filepath>                output file (default: standard output)" + lineSep + lineSep + "Search options:" + lineSep + "  -A, --allHits                          process all hits" + lineSep + searchOptionsHelp + lineSep + absoluteStereoHelp + lineSep + lineSep + "Examples:" + lineSep + "  SMILES table output, automatical R-group addition:" + lineSep + "    rgdecomp -q \"c1ccccc1Cl\" \"Brc1c(I)cccc1Cl\"" + lineSep + "  SMILES table output, SDF input with standardization:" + lineSep + "    rgdecomp -S \"[O-][N+]=O>>O=N=O..aromatize\" -q scaffold.mol target.sdf" + lineSep + "  SMILES molecule series output:" + lineSep + "    rgdecomp -f smiles -q scaffold.mol \"Brc1c(I)cccc1Cl\"" + lineSep + "  MRV molecule series output with R-group addition," + lineSep + "  attachment point symbols and including scaffold in output:" + lineSep + "    rgdecomp -f mrv -m Ra -a P -s HTS -q scaffold.mrv target.mrv" + lineSep + "  Markush generation with specified scaffold and targets:" + lineSep + "    rgdecomp -M -q scaffold.mol targets.sdf";
    private static final Molecule EMPTY_MOL = new Molecule();
    private static final int QMOD_NONE = 0;
    private static final int QMOD_ADDH = 1;
    private static final int QMOD_ADDR_ANYBOND = 2;
    private static final int QMOD_ADDR_SINGLEBOND = 3;
    private static final int INCLUDE_HEADER = 1;
    private static final int INCLUDE_TARGET = 2;
    private static final int INCLUDE_SCAFFOLD = 4;
    private static final String PROP_COLORMAP = "DMAP";
    private int undefinedRAtom = -1;
    private boolean allHits = false;
    private MolImporter queryMolImporter = null;
    private MolImporter[] targetMolImporters = null;
    private int queryModification = 0;
    private int attachmentType = 4;
    private int outputStyle = 3;
    private String colorTag = null;
    private String idField = null;
    private String outputFormat = null;
    private boolean daylightFormat = true;
    private boolean align = false;
    private PrintStream outputStream = null;
    private MolExporter outputMolExporter = null;
    private RGroupDecomposition rgd = null;
    private MarkushGenerator mg = null;

    @Override
    protected MolSearchOptions getSearchOptions() {
        return this.rgd != null ? this.rgd.getSearchOptions() : this.mg.getSearchOptions();
    }

    @Override
    public void setParameters(String[] args) throws Exception {
        boolean markush = false;
        this.undefinedRAtom = -1;
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s.startsWith("--undefinedRAtom:")) {
                if (s.endsWith("g")) {
                    this.undefinedRAtom = 2;
                    continue;
                }
                if (s.endsWith("gh")) {
                    this.undefinedRAtom = 3;
                    continue;
                }
                if (s.endsWith("ghe")) {
                    this.undefinedRAtom = 4;
                    continue;
                }
                throw new IllegalArgumentException("Invalid --undefinedRAtom option: " + s);
            }
            if (!s.equals("-M") && !s.equals("--Markush")) continue;
            markush = true;
        }
        if (markush) {
            this.mg = new MarkushGenerator();
        } else {
            this.rgd = new RGroupDecomposition();
        }
        super.setParameters(args);
        String querystr = this.clq.lookup("-q", "--query", "", 2, true, false).getString();
        this.queryMolImporter = ConfigTools.getQueryMolImporter(querystr);
        CLQ.Parameter p = this.clq.lookup("-m", "--query-modification", "", 2, false, false);
        String str = p == null ? null : p.getString().toLowerCase();
        this.queryModification = 0;
        if (str != null) {
            if (str.indexOf("h") != -1) {
                this.queryModification = 1;
            } else if (str.indexOf("ra") != -1) {
                this.queryModification = 2;
                if (this.undefinedRAtom == -1) {
                    this.undefinedRAtom = 4;
                }
            } else if (str.indexOf("rs") != -1) {
                this.queryModification = 3;
                if (this.undefinedRAtom == -1) {
                    this.undefinedRAtom = 4;
                }
            } else {
                throw new IllegalArgumentException("Invalid --query-modification option: " + str);
            }
        }
        this.allHits = this.clq.lookup("-A", "--allHits", "", 1, false, false) != null;
        p = this.clq.lookup("-a", "--attachment-symbol", "", 2, false, false);
        str = p == null ? null : p.getString().toLowerCase();
        this.attachmentType = 4;
        if (str != null) {
            if (str.indexOf("n") != -1) {
                this.attachmentType = 0;
            } else if (str.indexOf("a") != -1) {
                this.attachmentType = 4;
            } else if (str.indexOf("p") != -1) {
                this.attachmentType = 1;
            } else if (str.indexOf("m") != -1) {
                this.attachmentType = 2;
            } else if (str.indexOf("l") != -1) {
                this.attachmentType = 3;
            } else if (str.indexOf("r") != -1) {
                this.attachmentType = 5;
            } else {
                throw new IllegalArgumentException("Invalid --attachment-symbol option: " + str);
            }
        }
        str = (p = this.clq.lookup("-s", "--style", "", 2, false, false)) == null ? null : p.getString().toLowerCase();
        this.outputStyle = 3;
        if (str != null) {
            this.outputStyle = 0;
            if (str.indexOf("h") != -1) {
                this.outputStyle |= 1;
            }
            if (str.indexOf("t") != -1) {
                this.outputStyle |= 2;
            }
            if (str.indexOf("s") != -1) {
                this.outputStyle |= 4;
            }
        }
        this.idField = (p = this.clq.lookup("-i", "--id", "", 2, false, false)) == null ? null : p.getString();
        markush = this.clq.lookup("-M", "--Markush", "", 1, false, false) != null;
        p = this.clq.lookup("-f", "--format", "", 2, false, false);
        this.outputFormat = p == null ? (markush ? "mol" : null) : p.getString();
        this.daylightFormat = this.outputFormat == null || MolHandler.isDaylightFormat(this.outputFormat);
        this.align = !this.daylightFormat && this.clq.lookup("-k", "--keep-coordinates", "", 1, false, false) == null;
        this.colorTag = null;
        if (this.idField != null && this.outputFormat != null) {
            throw new IllegalArgumentException("ID output column is only available in SMILES table form.");
        }
        p = this.clq.lookup("-o", "--output", "", 2, false, false);
        PrintStream printStream = this.outputStream = p == null ? new PrintStream(new BufferedOutputStream(System.out)) : new PrintStream(new BufferedOutputStream(new FileOutputStream(p.getString())));
        if (this.outputFormat != null) {
            this.outputMolExporter = new MolExporter(this.outputStream, this.outputFormat);
            if (this.outputFormat.toUpperCase().startsWith("SDF")) {
                this.colorTag = PROP_COLORMAP;
            }
        }
        this.targetMolImporters = ConfigTools.getTargetMolImporters(this.clq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws SearchException, IOException {
        try {
            if (this.rgd != null) {
                this.runDecomp(this.getQueries(), this.getTargets());
            } else {
                this.runGenerate(this.getQueries(), this.getTargets());
            }
        }
        finally {
            if (this.outputMolExporter != null) {
                this.outputMolExporter.close(2);
            } else if (this.outputStream != null) {
                this.outputStream.flush();
            }
            this.rgd = null;
            this.mg = null;
        }
    }

    private Molecule[] getQueries() throws SearchException, IOException {
        Molecule query = null;
        ArrayList<Molecule> qlist = new ArrayList<Molecule>();
        while ((query = this.queryMolImporter.read()) != null) {
            if (this.queryStandardizer != null) {
                this.queryStandardizer.standardize(query);
            }
            switch (this.queryModification) {
                case 1: {
                    break;
                }
                case 2: {
                    RGroupDecomposition.addRGroups(query, 0);
                    break;
                }
                case 3: {
                    RGroupDecomposition.addRGroups(query, 1);
                }
            }
            qlist.add(query);
        }
        this.queryMolImporter.close();
        Molecule[] queries = new Molecule[qlist.size()];
        qlist.toArray(queries);
        return queries;
    }

    private Molecule[] getTargets() throws SearchException, IOException {
        Molecule target = null;
        ArrayList<Molecule> tlist = new ArrayList<Molecule>();
        for (int i = 0; i < this.targetMolImporters.length; ++i) {
            while ((target = ConfigTools.readMol(this.targetMolImporters[i], this.ignoreError)) != null) {
                if (ConfigTools.isReadErrorMol(target)) {
                    System.err.println("Import error when reading molecule " + (tlist.size() + 1) + ": " + ConfigTools.getReadErrorMessage(target));
                    continue;
                }
                if (this.targetStandardizer != null) {
                    this.targetStandardizer.standardize(target);
                }
                tlist.add(target);
            }
            this.targetMolImporters[i].close();
        }
        Molecule[] targets = new Molecule[tlist.size()];
        tlist.toArray(targets);
        return targets;
    }

    private void runGenerate(Molecule[] queries, Molecule[] targets) throws SearchException, IOException {
        if (this.queryStandardizer != null) {
            this.mg.setStandardizer(this.queryStandardizer, true, true);
        }
        this.mg.setTargets(targets);
        for (Molecule query : queries) {
            this.mg.setQuery(query);
            RgMolecule rgmol = this.mg.generate();
            this.outputMolExporter.write(rgmol);
        }
    }

    private void runDecomp(Molecule[] queries, Molecule[] targets) throws SearchException, IOException {
        if (this.queryStandardizer != null) {
            this.rgd.setStandardizer(this.queryStandardizer, true, true);
        }
        this.rgd.setAttachmentType(this.attachmentType);
        this.rgd.setAlign(this.align);
        boolean idIndex = "=".equals(this.idField);
        for (int i = 0; i < queries.length; ++i) {
            Molecule query = queries[i];
            if (this.undefinedRAtom != -1) {
                this.rgd.getSearchOptions().setUndefinedRAtom(this.undefinedRAtom);
            }
            this.rgd.setQuery(query);
            boolean headerRequired = true;
            for (int j = 0; j < targets.length; ++j) {
                String id;
                Molecule target = targets[j];
                if (i == 0 || targets.length > 1) {
                    this.rgd.setTarget(target);
                }
                String string = idIndex ? "" + (j + 1) : (id = this.idField != null ? target.getProperty(this.idField) : null);
                if (!this.decomp(id, headerRequired)) continue;
                headerRequired = false;
            }
        }
    }

    private boolean decomp(String id, boolean headerRequired) throws SearchException, IOException {
        int addCols = 0;
        if ((this.outputStyle & 2) != 0) {
            addCols |= 1;
        }
        if ((this.outputStyle & 4) != 0) {
            addCols |= 2;
        }
        Molecule[] header = null;
        int headerType = 0;
        if (headerRequired && (this.outputStyle & 1) != 0) {
            headerType = this.daylightFormat ? 2 : 1;
            header = this.rgd.getLigandTableHeader(headerType, addCols, this.colorTag);
        }
        if (this.outputFormat == null) {
            headerType = 0;
        }
        if (this.allHits) {
            Molecule[][] ligandTable = this.rgd.findLigandTable(headerType, addCols, this.colorTag);
            if (ligandTable == null) {
                return false;
            }
            if (this.outputFormat == null) {
                StringBuffer sb = new StringBuffer();
                if (header != null && ligandTable.length > 0) {
                    sb.append(this.getHeaderString(header) + "\n");
                }
                for (int i = 0; i < ligandTable.length; ++i) {
                    if (i > 0) {
                        sb.append("\n");
                    }
                    if (id != null) {
                        sb.append(id + "\t");
                    }
                    for (int j = 0; j < ligandTable[i].length; ++j) {
                        if (j > 0) {
                            sb.append("\t");
                        }
                        if (ligandTable[i][j] != null) {
                            if (!ligandTable[i][j].isEmpty()) {
                                sb.append(ligandTable[i][j].toFormat("smiles"));
                                continue;
                            }
                            sb.append("-");
                            continue;
                        }
                        sb.append("-");
                    }
                }
                this.outputStream.println(new String(sb));
            } else {
                for (int i = 0; i < ligandTable.length; ++i) {
                    for (int j = 0; j < ligandTable[i].length; ++j) {
                        if (ligandTable[i][j] != null) {
                            if (!this.daylightFormat && ligandTable[i][j].getDim() == 0) {
                                ligandTable[i][j].clean(2, null);
                            }
                            ConfigTools.writeMol(ligandTable[i][j], this.outputMolExporter, this.ignoreError);
                            continue;
                        }
                        this.outputMolExporter.write(EMPTY_MOL);
                    }
                }
            }
        } else {
            Molecule[] row = this.rgd.findLigandTableRow(addCols, this.colorTag);
            if (row == null) {
                return false;
            }
            if (this.outputFormat == null) {
                StringBuffer sb = new StringBuffer();
                if (header != null) {
                    sb.append(this.getHeaderString(header) + "\n");
                }
                if (this.idField != null) {
                    sb.append(id + "\t");
                }
                for (int i = 0; i < row.length; ++i) {
                    if (i > 0) {
                        sb.append("\t");
                    }
                    if (row[i] != null) {
                        if (!row[i].isEmpty()) {
                            sb.append(row[i].toFormat("smiles"));
                            continue;
                        }
                        sb.append("-");
                        continue;
                    }
                    sb.append("-");
                }
                this.outputStream.println(new String(sb));
            } else {
                int i;
                if (header != null) {
                    for (i = 0; i < header.length; ++i) {
                        if (!this.daylightFormat && header[i].getDim() == 0) {
                            header[i].clean(2, null);
                        }
                        ConfigTools.writeMol(header[i], this.outputMolExporter, this.ignoreError);
                    }
                }
                for (i = 0; i < row.length; ++i) {
                    if (row[i] != null) {
                        if (!this.daylightFormat && row[i].getDim() == 0) {
                            row[i].clean(2, null);
                        }
                        ConfigTools.writeMol(row[i], this.outputMolExporter, this.ignoreError);
                        continue;
                    }
                    this.outputMolExporter.write(EMPTY_MOL);
                }
            }
        }
        return true;
    }

    private String getHeaderString(Molecule[] header) {
        StringBuffer sb = new StringBuffer();
        if (this.idField != null) {
            sb.append("ID\t");
        }
        for (int i = 0; i < header.length; ++i) {
            if (i > 0) {
                sb.append("\t");
            }
            sb.append(header[i].toFormat("smarts"));
        }
        return new String(sb);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || "-h".equals(args[0]) || "--help".equals(args[0])) {
            System.out.println(strhelp);
            return;
        }
        RGDecomp rgdecomp = new RGDecomp();
        rgdecomp.setParameters(args);
        rgdecomp.run();
    }
}

