/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem;

import chemaxon.common.util.ColorParser;
import chemaxon.enumeration.homology.HomologyConstants;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolExporter;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolImporter;
import chemaxon.formats.MolInputStream;
import chemaxon.jchem.SearchBase;
import chemaxon.jchem.db.DatabaseProperties;
import chemaxon.jchem.db.JChemSearch;
import chemaxon.jchem.db.SettingsHandler;
import chemaxon.jchem.db.TableInfo;
import chemaxon.jchem.db.status.IncidentsObserver;
import chemaxon.jchem.db.status.incidentsets.JCSIncidents;
import chemaxon.jchem.db.status.observers.JCSObserver;
import chemaxon.jchem.version.VersionInfo;
import chemaxon.jep.ChemJEP;
import chemaxon.jep.Evaluator;
import chemaxon.jep.context.MolContext;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.nfunk.jep.ParseException;
import chemaxon.sss.screen.Similarity;
import chemaxon.sss.search.JChemSearchOptions;
import chemaxon.sss.search.MolSearchOptions;
import chemaxon.sss.search.SearchException;
import chemaxon.sss.search.SearchOptions;
import chemaxon.sss.search.SearchUtil;
import chemaxon.sss.search.StandardizedMolSearch;
import chemaxon.sss.search.options.HaltOnErrorOption;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.ConfigTools;
import chemaxon.util.ConnectionHandler;
import chemaxon.util.HitColoringAndAlignmentOptions;
import chemaxon.util.HitDisplayTool;
import chemaxon.util.MolHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.zip.GZIPInputStream;

public class Search
extends SearchBase {
    private final RgMolecule molbuf = new RgMolecule();
    private MolInputStream mis = null;
    private MolImporter molimp = null;
    private MolExporter exporter = null;
    private String outTagName = null;
    private String[] outTagNames = null;
    private OutputStream ostream = null;
    private PrintWriter printwr = null;
    private final RandomAccessFile oraf = null;
    private boolean forceCleaning = false;
    private int cleanDim = 2;
    private String cleanOpts = "01";
    private final boolean textmode = false;
    private final ArrayList<String> inOptions = new ArrayList();
    private final ArrayList inFiles = new ArrayList();
    private int inFileIndex;
    private int inMolIndex;
    private int outMolIndex;
    private int verbose = 0;
    private boolean hasMoreMols;
    private String outfmt = "smiles";
    private String outfmtWithOpts = "smiles";
    private final ArrayList<String> querySources = new ArrayList();
    private final ArrayList<Molecule> queryStructures = new ArrayList();
    private final ArrayList<Molecule> nonStardardizedQueryStructures = new ArrayList();
    private final StandardizedMolSearch msearch = new StandardizedMolSearch();
    private boolean listNonHits = false;
    private boolean andMultipleQueries = true;
    private boolean andMultipleQueriesInMolSearch = true;
    private final int errorPrintingLevel;
    private final boolean isExitAllowed;
    private static final String strhelp = "JChem Search Utility " + VersionInfo.JCHEM_VERSION + ", (C) 2000-2012 ChemAxon Ltd." + lineSep + "Usage: jcsearch [options] [files...]" + lineSep + "   or  jcsearch [options] DB:[table name]" + lineSep + "With no file, or when file is -, read standard input." + lineSep + "When DB is specified, search is done in the database, using connection" + lineSep + "  information saved by other jchem programs (e.g. jcman)" + lineSep + "Output format: mol, rgf, sdf, csmol, csrgf, cssdf, cml, smiles, smarts, sybyl," + lineSep + "  pdb, pov or xyz (see -H)" + lineSep + "Options:" + lineSep + "-h         this help message" + lineSep + "-H         help on output file formats" + lineSep + "-q query   SMARTS string or name of file that contains the query structure(s)" + lineSep + "             (More than one can be specified.) In case of -t:p or --tautomer " + lineSep + "             expects SMILES instead of SMARTS." + lineSep + "-t:type    search type." + lineSep + "      -t:s                                substructure search (default)" + lineSep + "      -t:f                                full search" + lineSep + "      -t:ff                               full fragment search" + lineSep + "      -t:d                                duplicate search" + lineSep + "      -t:i:[dissimilarity_threshold]      similarity search" + lineSep + "                                          in case of mrv or sdf output the " + lineSep + "                                          dissimilarity value is stored as" + lineSep + "                                          molecule property." + lineSep + "      -t:u                                superstructure search " + lineSep + "\t\t\t\t\t   (default for query tables)" + lineSep + "      -t:c                                count all hits" + lineSep + "--hitColoring\t\t      if the output format is " + lineSep + "           \t\t      MRV, colors the hits depending on search type. " + lineSep + "--hitColor\t\t      in case of hitColoring specify color of hit atoms and bonds" + lineSep + "\t                              example: \"#00FF00\" means full green" + lineSep + "\t\t\t\t      examples: \"red\", \"green\", \"blue\"" + lineSep + "--hitHomologyColor             in case of hitColoring specify color of user defined homology" + lineSep + "                               hit atoms and bonds" + lineSep + "\t                              example: \"#00FF00\" means full green" + lineSep + "\t\t\t\t      examples: \"red\", \"green\", \"blue\"" + lineSep + "--nonHitColor\t\t      in case of hitColoring specify color of hit atoms and bonds" + lineSep + "\t\t\t\t      example: \"#00FF00\" means full green" + lineSep + "\t\t\t\t      examples: \"red\", \"green\", \"blue\"" + lineSep + "--nonHitColor3D\t\t      in case of hitColoring in 3D molecules specify color of hit" + lineSep + "\t\t\t\t      atoms and bonds" + lineSep + "\t\t\t\t      example: \"#00FF00\" means full green" + lineSep + "\t\t\t\t      examples: \"red\", \"green\", \"blue\"" + lineSep + "--removeUnusedDef\t      in case of markush search remove unused R-group definitions" + lineSep + "                               Default value is y." + lineSep + "--markushScreening:y/n" + lineSep + "                               specify if screening should be used in case of markush search" + lineSep + "\t\t\t\t      default value is y. " + lineSep + "--haltOnError:y/n\t      specify how search should handle recoverable errors, stop" + lineSep + "\t\t\t\t      or log and continue if possible, default value is y for" + lineSep + "\t\t\t\t      normal structure searches and n for markush targets" + lineSep + "--markushDisplayMode:o/r/rhg    In case of markush searching and hit coloring" + lineSep + "\t\t\t\t specifies the type of the resulting molecule." + lineSep + "      Values:" + lineSep + "        o   Default: The results is shown on the given target structure." + lineSep + "        r   Markush reduction to hit : The markush structure is reduced" + lineSep + "            according to the hit." + lineSep + "        rhg Markush reduction to hit and the homology groups" + lineSep + "            are expanded according to the matching part of the query." + lineSep + "            which can also be a single H atom or the empty set" + lineSep + "--align                      align or template based clean hits if DB option " + lineSep + "           \t\t      has been set, and output format is MRV." + lineSep + "      --align:r              rotate. If query molecule has 0 dimension, it" + lineSep + "           \t\t      will be cleaned in 2d for alignment." + lineSep + "      --align:p              partial clean (template based clean). If query " + lineSep + "            \t\t      molecule has 0 dimension, same as rotate." + lineSep + SearchBase.absoluteStereoDBIncludedHelp + lineSep + SearchBase.searchOptionsHelp + lineSep + "--undefinedRAtom:g/gh/ghe/a/u          Describes the matching of an undefined " + lineSep + "                                       R-atom in query. Effective only when" + lineSep + "                                       --exactQueryAtomMatching is not set." + lineSep + "      Values:" + lineSep + "        g   Default: Undefined R-atom matches a group of" + lineSep + "            one or more connected atoms in target," + lineSep + "            including at least one heavy atom." + lineSep + "        gh  Undefined R-atom matches a group of " + lineSep + "            one or more connected atoms in target," + lineSep + "            which can also be a single H atom." + lineSep + "        ghe Undefined R-atom matches a group of " + lineSep + "            one or more connected atoms in target," + lineSep + "            which can also be a single H atom or the empty set" + lineSep + "            (empty set match is allowed for isolated or" + lineSep + "            one-attachment R-atoms only)." + lineSep + "        a   Undefined R-atom matches any single atom in target." + lineSep + "        u   Undefined R-atom matches only an undefined R-atom in target." + lineSep + "--bridgingRAllowed:n/y        Forbid/allow different R-atoms matching" + lineSep + "                              the same group. Default is n." + lineSep + "--RLigandEqualityCheck:y/n    Switch on/off the requirement that R-atoms" + lineSep + "                              with the same R-group ID should match ligands" + lineSep + "                              with the same structure. Default is y." + lineSep + "--maxResults:<n>              Limits the number of molecules returned." + lineSep + "-f format  output format (default: smiles). Run jcsearch -H for details." + lineSep + "      -f :T<SDF field>   write the value of the SDF field in matching targets" + lineSep + "      -f :Tname          write the molecule names of matching targets" + lineSep + "      -f :M<SDF field1:...:SDF fieldn>   write the specified field values to " + lineSep + "                                         the molecule as SDF feilds" + lineSep + "-o file    write output to file" + lineSep + "-s SMILES  read input from SMILES string" + lineSep + "-v         verbose" + lineSep + "-vv        very verbose, stack trace on error" + lineSep + "-0         skip coordinate calculation for SMILES input" + lineSep + "-d         use Daylight-type aromatization (Huckel-rule) instead of " + lineSep + "           the standard one. (This flag overrides flags -S and --standardize!)" + lineSep + "-2[:[On][e]]  2D coordinate calculation (useful if the input is SMILES)" + lineSep + "      -2      coordinate calculation with default options (O1)" + lineSep + "      -2:O0   no optimization    -2:O1  optimize if needed" + lineSep + "      -2:O2   optimize           -2:e   make double either (cis/trans) bonds" + lineSep + "-n         List non-hits. For using with multiple targets, see options --and" + lineSep + "           and --or." + lineSep + "--and      If two or more queries are present, all are required to match." + lineSep + "           (Default) For DB targets, only the first query is considered." + lineSep + "           If used together with option -n , a hit is returned if none of the" + lineSep + "           query molecules match." + lineSep + "--or       If more than one queries are present, at least one is required to" + lineSep + "           match. For DB targets, only the first query is considered." + lineSep + "           If used together with option -n , a hit is returned if at least" + lineSep + "           one query molecules does not match." + lineSep + "--allHits  Instead of checking the existence of matching, all matchings of" + lineSep + "           the query molecule(s) are reported." + lineSep + "           Symbols used in hit arrays in place of specific query atoms:" + lineSep + "            R    - R-group" + lineSep + "            M    - multicenter" + lineSep + "            U    - unmapable (e.g. polymer star atom)" + lineSep + "            LP   - lone pair" + lineSep + "            E    - R-atom matching the empty set" + lineSep + "            EXCL - excluded query atom" + lineSep + "-e \"expression\" | <file>               A Chemical Terms filtering expression" + lineSep + "  or --expression \"expression\"|<file>  for filtering hits. For syntax, see" + lineSep + "       http://www.chemaxon.com/jchem/doc/user/ChemicalTerms.html" + lineSep + "-F \"SQL statement\"                     SQL query for filtering. The result should" + lineSep + "  or --filterQuery \"SQL statement\"     contain the cd_id values. For syntax, see" + lineSep + "       http://www.chemaxon.com/jchem/doc/dev/cartridge/cartapi.html#jc_compare_filterQuery" + lineSep + "--ignoreCTExceptions:n/y\tIf set to y, only syntactical exceptions " + lineSep + "\t\t\t\twill be thrown during search. Those molecules" + lineSep + " \t\t\t\tthat return exception during evaluation" + lineSep + "\t\t\t\twill be left out from hit list. Default is n." + lineSep + "-c config file          Configuration xml file for Chemical Terms (optional)" + lineSep + "  or --config config file" + lineSep + "-S, --standardize <file/string>      standardize query and target" + lineSep + "                                     according to configuration file/string" + lineSep + "-g, --ignore-error                   continue with next molecule on error" + lineSep + "Examples:" + lineSep + "1) Searching chlorobenzol in a SMILES file and sending the results to" + lineSep + "   the standard output in SMILES format:" + lineSep + "      jcsearch -q \"c1ccccc1Cl\" -f smiles input.smi" + lineSep + "2) Searching chlorobenzol in an SDfile file and writing the result" + lineSep + "   (structures and all other data) into another SDfile:" + lineSep + "      jcsearch -q \"c1ccccc1Cl\" -f sdf -o hits.sdf input.sdf" + lineSep + "3) Like 2), but reading the query from a molfile and displaying" + lineSep + "   the results using mview:" + lineSep + "      jcsearch -q clbenz.mol -f sdf input.sdf | mview -f ID -";
    private static String fmthelp = "Some output file formats. (See more in the help of molconvert):" + lineSep + "mol  MDL Molfile or RGfile (.mol)  csmol   Compressed Molfile (.csmol)" + lineSep + "rgf  MDL RGfile (.mol)             csrgf   Compressed RGfile (.csmol)" + lineSep + "sdf  MDL SDfile (.sdf)             cssdf   Compressed SDfile (.cssdf)" + lineSep + "cml  CML                           smiles  SMILES (.smiles)" + lineSep + "Export options for various formats:" + lineSep + "MDL:bXXX  scale molecule in such a way that the C-C bond lengths will be" + lineSep + "     XXX instead of the default 0.825 (MDL=mol,rgf,sdf,csmol,csrgf,cssdf)" + lineSep + "cml:A     use <atomArray> instead of <atom> tags in CML" + lineSep + "smiles:0  do not write stereo information in SMILES";
    private Properties props;
    private ConnectionHandler conh;
    private String tableName;
    private int DBAbsoluteStereo = 0;
    private boolean allHits = false;
    private boolean hitColoring = false;
    private String filterQuery = null;
    private int markushDisplayMode = 0;
    private boolean removeUnusedDef = false;
    private String hitColorString = "";
    private String hitHomologyColorString = "";
    private String nonHitColorString = "";
    private String nonHitColor3DString = "";
    private int align = 0;
    private boolean markushScreening = true;
    private String markushScreeningOptions;
    private HaltOnErrorOption haltOnError = HaltOnErrorOption.DEFAULT;
    private boolean daylightAromatization = false;
    private String expression = null;
    private String expressionConfigFile = null;
    private byte[][] queryFP;
    private int maxResults = Integer.MAX_VALUE;
    private int totalMolIndex = 0;
    private boolean firstQuery = true;
    private Evaluator evaluator;
    private MolContext context;
    private ChemJEP jep;
    private boolean hadDB = false;

    public Search() {
        this(0, true);
    }

    private Search(int errorPrintingLevel, boolean isExitAllowed) {
        this.errorPrintingLevel = errorPrintingLevel;
        this.isExitAllowed = isExitAllowed;
    }

    @Override
    protected MolSearchOptions getSearchOptions() {
        return this.msearch.getSearchOptions();
    }

    @Override
    public void setParameters(String[] args) throws Exception {
        super.setParameters(args);
        for (int i = 0; i < args.length; ++i) {
            String s = args[i];
            if (s == null || s.length() == 0) continue;
            if (s.equals("-")) {
                this.inFiles.add(System.in);
                this.inOptions.add("");
                continue;
            }
            if (s.startsWith("--")) {
                String ss;
                int l;
                if (s.startsWith("--maxResults")) {
                    l = "--maxResults".length();
                    char c = s.charAt(l);
                    if (c == ':' || c == '=') {
                        try {
                            this.maxResults = Integer.parseInt(s.substring(l + 1));
                        }
                        catch (NumberFormatException e) {
                            this.maxResults = Integer.MAX_VALUE;
                            System.err.println("error: wrong maxResults flag:" + s);
                            System.err.println("Use -h for help.");
                            this.exit(1);
                        }
                        continue;
                    }
                    System.err.println("error: unknown flag:" + s);
                    System.err.println("Use -h for help.");
                    this.exit(1);
                    continue;
                }
                if (s.startsWith("--DBAbsoluteStereo")) {
                    l = "--DBAbsoluteStereo".length();
                    char c = s.charAt(l);
                    if (c == ':' || c == '=') {
                        if (s.substring(l + 1).equalsIgnoreCase("T")) {
                            this.DBAbsoluteStereo = 0;
                            continue;
                        }
                        if (s.substring(l + 1).equalsIgnoreCase("C")) {
                            this.DBAbsoluteStereo = 1;
                            continue;
                        }
                        if (s.substring(l + 1).equalsIgnoreCase("A")) {
                            this.DBAbsoluteStereo = 2;
                            continue;
                        }
                        System.err.println("error: unknown DBAbsoluteStereo flag:" + s);
                        System.err.println("Use -h for help.");
                        this.exit(1);
                        continue;
                    }
                    System.err.println("error: unknown DBAbsoluteStereo matching flag:" + s);
                    System.err.println("Use -h for help.");
                    this.exit(1);
                    continue;
                }
                if (s.startsWith("--align")) {
                    l = "--align".length();
                    char c = s.charAt(l);
                    if (c == ':' || c == '=') {
                        if (s.substring(l + 1).equalsIgnoreCase("R")) {
                            this.align = 1;
                            continue;
                        }
                        if (s.substring(l + 1).equalsIgnoreCase("P")) {
                            this.align = 2;
                            continue;
                        }
                        System.err.println("error: unknown Align flag:" + s);
                        System.err.println("Use -h for help.");
                        this.exit(1);
                        continue;
                    }
                    System.err.println("error: unknown Align matching flag:" + s);
                    System.err.println("Use -h for help.");
                    this.exit(1);
                    continue;
                }
                if (s.equalsIgnoreCase("--and")) {
                    this.andMultipleQueries = true;
                    continue;
                }
                if (s.equalsIgnoreCase("--or")) {
                    this.andMultipleQueries = false;
                    continue;
                }
                if (s.equalsIgnoreCase("--allHits")) {
                    this.allHits = true;
                    continue;
                }
                if (s.startsWith("--hitColoring")) {
                    char c;
                    this.hitColoring = true;
                    l = "--hitColoring".length();
                    if (s.length() <= l || (c = s.charAt(l)) != ':' && c != '=') continue;
                    if (s.substring(l + 1).equalsIgnoreCase("y")) {
                        this.hitColoring = true;
                        continue;
                    }
                    if (s.substring(l + 1).equalsIgnoreCase("n")) {
                        this.hitColoring = false;
                        continue;
                    }
                    System.err.println("error: unknown hitColoring flag:" + s);
                    System.err.println("Use -h for help.");
                    this.exit(1);
                    continue;
                }
                if (s.startsWith("--markushDisplayMode")) {
                    l = "--markushDisplayMode".length();
                    char c = s.charAt(l);
                    if (c == ':' || c == '=') {
                        if (s.substring(l + 1).equalsIgnoreCase("o")) {
                            this.markushDisplayMode = 0;
                            continue;
                        }
                        if (s.substring(l + 1).equalsIgnoreCase("r")) {
                            this.markushDisplayMode = 1;
                            this.hitColoring = true;
                            continue;
                        }
                        if (s.substring(l + 1).equalsIgnoreCase("rhg")) {
                            this.markushDisplayMode = 2;
                            this.hitColoring = true;
                            continue;
                        }
                        System.err.println("error: unknown markushDisplayMode flag:" + s);
                        System.err.println("Use -h for help.");
                        this.exit(1);
                        continue;
                    }
                    System.err.println("error: unknown markushDisplayMode matching flag:" + s);
                    System.err.println("Use -h for help.");
                    this.exit(1);
                    continue;
                }
                if (s.equalsIgnoreCase("--removeUnusedDef")) {
                    this.removeUnusedDef = true;
                    continue;
                }
                if (s.startsWith("--hitColor")) {
                    l = "--hitColor".length();
                    char c = s.charAt(l);
                    if (c != ':' && c != '=') continue;
                    ss = s.substring(l + 1);
                    try {
                        ColorParser.parseColor(ss);
                        this.hitColorString = ss;
                    }
                    catch (IllegalArgumentException ex) {
                        System.err.println("error: unknown hitColor value:" + s);
                        System.err.println("Use -h for help.");
                        this.exit(1);
                    }
                    continue;
                }
                if (s.startsWith("--hitHomologyColor")) {
                    l = "--hitHomologyColor".length();
                    char c = s.charAt(l);
                    if (c != ':' && c != '=') continue;
                    ss = s.substring(l + 1);
                    try {
                        ColorParser.parseColor(ss);
                        this.hitHomologyColorString = ss;
                    }
                    catch (IllegalArgumentException ex) {
                        System.err.println("error: unknown hitColor value:" + s);
                        System.err.println("Use -h for help.");
                        this.exit(1);
                    }
                    continue;
                }
                if (s.startsWith("--nonHitColor")) {
                    l = "--nonHitColor".length();
                    char c = s.charAt(l);
                    if (c != ':' && c != '=') continue;
                    ss = s.substring(l + 1);
                    try {
                        ColorParser.parseColor(ss);
                        this.nonHitColorString = ss;
                    }
                    catch (IllegalArgumentException ex) {
                        System.err.println("error: unknown nonHitColor value:" + s);
                        System.err.println("Use -h for help.");
                        this.exit(1);
                    }
                    continue;
                }
                if (s.startsWith("--nonHitColor3D")) {
                    l = "--nonHitColor3D".length();
                    char c = s.charAt(l);
                    if (c != ':' && c != '=') continue;
                    ss = s.substring(l + 1);
                    try {
                        ColorParser.parseColor(ss);
                        this.nonHitColor3DString = ss;
                    }
                    catch (IllegalArgumentException ex) {
                        System.err.println("error: unknown nonHitColor3D value:" + s);
                        System.err.println("Use -h for help.");
                        this.exit(1);
                    }
                    continue;
                }
                if (s.startsWith("--markushScreening")) {
                    char c;
                    this.markushScreening = true;
                    l = "--markushScreening".length();
                    if (s.length() <= l || (c = s.charAt(l)) != ':' && c != '=') continue;
                    if (s.substring(l + 1).equalsIgnoreCase("y")) {
                        this.markushScreening = true;
                        if (s.length() > 4) {
                            this.markushScreeningOptions = s.substring(l + 3);
                            continue;
                        }
                        this.markushScreeningOptions = null;
                        continue;
                    }
                    if (s.substring(l + 1).equalsIgnoreCase("n")) {
                        this.markushScreening = false;
                        continue;
                    }
                    System.err.println("error: unknown markushScreening flag:" + s);
                    System.err.println("Use -h for help.");
                    this.exit(1);
                    continue;
                }
                if (s.equalsIgnoreCase("--haltOnError") || s.startsWith("--haltOnError")) {
                    char c;
                    l = "--haltOnError".length();
                    if (s.length() <= l || (c = s.charAt(l)) != ':' && c != '=') continue;
                    if (s.substring(l + 1).equalsIgnoreCase("y")) {
                        this.haltOnError = HaltOnErrorOption.YES;
                        continue;
                    }
                    if (s.substring(l + 1).equalsIgnoreCase("n")) {
                        this.haltOnError = HaltOnErrorOption.NO;
                        continue;
                    }
                    System.err.println("error: unknown haltOnError flag:" + s);
                    System.err.println("Use -h for help.");
                    this.exit(1);
                    continue;
                }
                if (s.equalsIgnoreCase("--expression")) {
                    if (i >= args.length - 1) {
                        System.err.println("error: No expression is specified!");
                        this.exit(1);
                    }
                    String filter = args[++i];
                    try {
                        this.expression = ConfigTools.getContent(new BufferedReader(new FileReader(filter)));
                    }
                    catch (IOException e) {
                        this.expression = filter;
                    }
                    continue;
                }
                if (s.equalsIgnoreCase("--filterQuery")) {
                    if (i >= args.length - 1) {
                        System.err.println("error: No expression is specified!");
                        this.exit(1);
                    }
                    this.filterQuery = args[++i];
                    continue;
                }
                if (s.equalsIgnoreCase("--config")) {
                    if (i >= args.length - 1) {
                        System.err.println("error: No config file is specified!");
                        this.exit(1);
                    }
                    this.expressionConfigFile = args[++i];
                    break;
                }
                if (s.equalsIgnoreCase("--standardize")) {
                    ++i;
                    continue;
                }
                System.err.println("error: unknown option:" + s);
                continue;
            }
            if (s.charAt(0) == '-') {
                block42: for (int j = 1; j < s.length(); ++j) {
                    char c = s.charAt(j);
                    switch (c) {
                        case 'h': {
                            System.out.println(strhelp);
                            this.exit(0);
                        }
                        case 'H': {
                            System.out.println(fmthelp);
                            this.exit(0);
                        }
                        case 'v': {
                            ++this.verbose;
                            continue block42;
                        }
                        case 's': {
                            String[] smiopts = MFileFormatUtil.splitFileAndOptions(args[++i]);
                            byte[] data = smiopts[0].getBytes();
                            this.inFiles.add(new ByteArrayInputStream(data));
                            if (smiopts[1] == null) {
                                smiopts[1] = "cxsmiles:";
                            } else {
                                String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(smiopts[1]);
                                if (fmtopts[1] == null) {
                                    smiopts[1] = "cxsmiles:" + fmtopts[1];
                                }
                            }
                            this.inOptions.add(smiopts[1]);
                            continue block42;
                        }
                        case '0': {
                            this.cleanDim = 0;
                            continue block42;
                        }
                        case 'n': {
                            this.listNonHits = true;
                            continue block42;
                        }
                        case '2': {
                            this.cleanDim = 2;
                            this.forceCleaning = true;
                            if (j >= s.length() - 2 || (c = s.charAt(j + 1)) != ':' && c != '=') continue block42;
                            this.cleanOpts = s.substring(j + 2);
                            j = s.length() - 1;
                            continue block42;
                        }
                        case '3': {
                            this.cleanDim = 3;
                            this.forceCleaning = true;
                            if (j >= s.length() - 2 || (c = s.charAt(j + 1)) != ':' && c != '=') continue block42;
                            this.cleanOpts = s.substring(j + 2);
                            j = s.length() - 1;
                            continue block42;
                        }
                        case 'o': {
                            if (this.ostream != null) {
                                System.err.println("error: more than one output file specified");
                                this.exit(1);
                                continue block42;
                            }
                            if (i >= args.length - 1) {
                                System.err.println("error: Please specify a file name for option \"-o\" using the following syntax: -o filename");
                                this.exit(1);
                                continue block42;
                            }
                            try {
                                this.ostream = new FileOutputStream(args[++i]);
                            }
                            catch (IOException ex) {
                                System.err.println(s.concat(": cannotopen for writing"));
                                this.exit(1);
                            }
                            continue block42;
                        }
                        case 'q': {
                            if (i >= args.length - 1) {
                                System.err.println("error: query not specified");
                                this.exit(1);
                            }
                            this.querySources.add(args[++i]);
                            continue block42;
                        }
                        case 'f': {
                            try {
                                this.outfmtWithOpts = args[++i];
                                int colonIndex = this.outfmtWithOpts.indexOf(58);
                                this.outfmt = this.outfmtWithOpts.substring(0, colonIndex >= 0 ? colonIndex : this.outfmtWithOpts.length());
                                if (this.outfmt.equals("smiles") || this.outfmt.equals("smarts") || this.outfmt.equals("cxsmiles") || this.outfmt.equals("cxsmarts")) continue block42;
                                if (this.outfmtWithOpts.startsWith(":T")) {
                                    this.outTagName = this.outfmtWithOpts.substring(2);
                                    continue block42;
                                }
                                if ((this.outfmt.equals("") || colonIndex < 0) && !this.outfmtWithOpts.startsWith(":M") || this.outfmtWithOpts.startsWith(":T")) continue block42;
                                this.outfmtWithOpts = this.outfmtWithOpts.substring(colonIndex);
                                String outTag = this.outfmtWithOpts.substring(2);
                                this.outTagNames = outTag.split(":");
                                this.outfmtWithOpts = !this.outfmt.equals("") ? this.outfmt : "smiles";
                                if (!this.outfmt.equals("")) continue block42;
                                this.outfmtWithOpts = "smiles:T";
                                for (int n = 0; n < this.outTagNames.length; ++n) {
                                    this.outfmtWithOpts = n == this.outTagNames.length - 1 ? this.outfmtWithOpts + this.outTagNames[n] : this.outfmtWithOpts + this.outTagNames[n] + ":";
                                }
                                continue block42;
                            }
                            catch (Throwable e) {
                                System.err.println("error: output format not specified");
                                this.exit(1);
                                continue block42;
                            }
                        }
                        case 't': {
                            this.handleSearchTypeOption(s, args, i, j);
                            continue block42;
                        }
                        case 'd': {
                            this.daylightAromatization = true;
                            continue block42;
                        }
                        case 'e': {
                            if (i >= args.length - 1) {
                                System.err.println("error: No expression is specified!");
                                this.exit(1);
                            }
                            String filter = args[++i];
                            try {
                                this.expression = ConfigTools.getContent(new BufferedReader(new FileReader(filter)));
                            }
                            catch (IOException e) {
                                this.expression = filter;
                            }
                            continue block42;
                        }
                        case 'F': {
                            if (i >= args.length - 1) {
                                System.err.println("error: No expression is specified!");
                                this.exit(1);
                            }
                            this.filterQuery = args[++i];
                            continue block42;
                        }
                        case 'c': {
                            if (i >= args.length - 1) {
                                System.err.println("error: No config file is specified!");
                                this.exit(1);
                            }
                            this.expressionConfigFile = args[++i];
                            continue block42;
                        }
                        case 'S': {
                            ++i;
                            continue block42;
                        }
                        case 'g': {
                            continue block42;
                        }
                        default: {
                            System.err.println("Unknown option: -" + c);
                            System.err.println("Use -h for help.");
                            this.exit(1);
                        }
                    }
                }
                continue;
            }
            if (s.startsWith("DB:")) {
                this.inFiles.add(s);
                this.inOptions.add("");
                continue;
            }
            String[] ss = MFileFormatUtil.splitFileAndOptions(s);
            this.inFiles.add(ss[0]);
            this.inOptions.add(ss[1] == null ? "" : ss[1]);
            try {
                FileInputStream is = new FileInputStream(s);
                ((InputStream)is).close();
                continue;
            }
            catch (FileNotFoundException ex) {
                continue;
            }
            catch (IOException ex) {
                System.err.println(s.concat(": cannot open"));
                this.exit(1);
            }
        }
        boolean bl = this.listNonHits ? !this.andMultipleQueries : (this.andMultipleQueriesInMolSearch = this.andMultipleQueries);
        if (this.inFiles.size() == 0) {
            this.inFiles.add(System.in);
            this.inOptions.add("");
        }
        if (this.ostream == null) {
            this.ostream = System.out;
        }
    }

    private void init() throws IOException {
        this.inFileIndex = -1;
        this.inMolIndex = -1;
        this.outMolIndex = 0;
        this.hasMoreMols = false;
        this.printwr = new PrintWriter(this.ostream, true);
        this.exporter = new MolExporter(this.ostream, this.outTagName == null ? this.outfmtWithOpts : "smiles");
        this.exporter.setThreadCount(1);
        int size = this.querySources.size();
        if (size == 0) {
            throw new IllegalArgumentException("jcsearch: no query specified.");
        }
        MolSearchOptions mso = this.getSearchOptions();
        int molInSource = 1;
        for (int j = 0; j < size; ++j) {
            String source = null;
            try {
                source = this.querySources.get(j);
                String[] ss = MFileFormatUtil.splitFileAndOptions(source);
                String qstr = ss[0];
                String fmt = ss[1];
                BufferedInputStream qin = null;
                boolean isSmartsQuery = true;
                String path = null;
                if (!qstr.equals("''") && qstr.length() != 0) {
                    if (MFileFormatUtil.isURLOrFileName(qstr)) {
                        String fname = null;
                        File f = new File(qstr);
                        if (!f.exists()) {
                            System.err.println("error: query file " + qstr + " is not available");
                            this.exit(1);
                        }
                        fname = f.getName();
                        if (fmt == null) {
                            fmt = MFileFormatUtil.getUnguessableFormat(fname);
                        }
                        if (fname.endsWith(".smiles") || fname.endsWith(".smi") || fname.endsWith(".cxsmiles") || fname.endsWith("cxsmi")) {
                            isSmartsQuery = false;
                        }
                        path = f.getPath();
                        qin = new BufferedInputStream(new FileInputStream(f));
                    } else {
                        if (mso.getSearchType() == 5 || mso.getSearchType() == 6 || fmt != null && (fmt.startsWith("smi") || fmt.startsWith("cxsmi")) || mso.getTautomerSearch() == 1) {
                            isSmartsQuery = false;
                        }
                        qin = new BufferedInputStream(new ByteArrayInputStream(qstr.getBytes()));
                    }
                    molInSource = 1;
                    MolImporter qmolimp = new MolImporter(new MolInputStream((InputStream)qin, fmt, null, path));
                    if (isSmartsQuery && this.searchType != 3) {
                        qmolimp.setQueryMode(true);
                    }
                    Molecule queryStructure = null;
                    while ((queryStructure = qmolimp.read()) != null) {
                        this.standardize(queryStructure, true);
                        if (queryStructure instanceof RgMolecule) {
                            MolImportUtil.convertRgroupAttachments(queryStructure);
                        }
                        this.queryStructures.add(queryStructure);
                        ++molInSource;
                    }
                    qmolimp.close();
                    continue;
                }
                this.queryStructures.add(new Molecule());
                ++molInSource;
                continue;
            }
            catch (IOException e) {
                String errorMsg = "Error in " + source + " at molecule " + molInSource + ".";
                System.err.println(errorMsg);
                System.err.println(e.getMessage());
                if (this.verbose > 0) {
                    e.printStackTrace(System.err);
                }
                this.exit(1);
            }
        }
        if (this.searchType == 3) {
            int count = this.queryStructures.size();
            this.queryFP = new byte[count][];
            for (int x = 0; x < count; ++x) {
                this.queryFP[x] = new MolHandler(this.queryStructures.get(x)).generateFingerprintInBytes(16, 2, 6);
            }
        }
        try {
            if (this.queryStandardizer != null) {
                this.msearch.setStandardizer(this.queryStandardizer, true, true);
            }
            if (this.expression != null) {
                if (this.expressionConfigFile != null) {
                    this.msearch.setFilterConfig(new File(this.expressionConfigFile));
                }
                this.msearch.setFilter(this.expression);
            }
        }
        catch (SearchException e) {
            e.printStackTrace();
            this.exit(1);
        }
    }

    private void standardize(Molecule m, boolean query) {
        if (this.searchType == 3) {
            if (query) {
                this.nonStardardizedQueryStructures.add(m.cloneMoleculeWithDocument());
            }
            TableInfo.standardize(m, query ? this.queryStandardizer : this.targetStandardizer, false);
        } else if (query) {
            this.nonStardardizedQueryStructures.add(m);
        }
    }

    private String currentFileName() {
        if (this.inFileIndex >= 0 && this.inFileIndex < this.inFiles.size()) {
            Object o = this.inFiles.get(this.inFileIndex);
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof File) {
                return ((File)o).getPath();
            }
            return "file " + (this.inFileIndex + 1);
        }
        return "";
    }

    public synchronized boolean convert() throws IOException, SearchException {
        if (this.hasMoreMols) {
            ++this.inMolIndex;
            this.hasMoreMols = this.convert0();
            if (!this.hasMoreMols) {
                if (this.verbose > 0 && this.inFileIndex >= 0) {
                    if (this.verbose > 1) {
                        System.err.print("... " + this.currentFileName() + ": ");
                    }
                    System.err.println("found/processed = " + this.outMolIndex + "/" + this.inMolIndex);
                }
                this.inMolIndex = -1;
                this.outMolIndex = 0;
                this.mis.close();
            }
        }
        while (!this.hasMoreMols && this.inFileIndex < this.inFiles.size() - 1 && this.totalMolIndex < this.maxResults) {
            block35: {
                String infmt;
                ++this.inFileIndex;
                Object in = this.inFiles.get(this.inFileIndex);
                String format2 = this.inOptions.get(this.inFileIndex);
                if (in instanceof InputStream) {
                    this.mis = in instanceof MolInputStream ? (MolInputStream)in : (!format2.equals("") ? new MolInputStream((InputStream)in, format2) : new MolInputStream((InputStream)in));
                    if (this.verbose > 1) {
                        System.err.println("Reading file " + (this.inFileIndex + 1) + " (" + this.mis.getFormat() + " format) ... ");
                    }
                } else if (in instanceof File) {
                    File f = (File)in;
                    if (format2.equals("")) {
                        format2 = MFileFormatUtil.getUnguessableFormat(f.getName());
                    }
                    this.mis = new MolInputStream((InputStream)new FileInputStream(f), format2, null, f.getPath());
                    if (this.verbose > 1) {
                        System.err.println("Reading file " + (this.inFileIndex + 1) + ": " + f.getPath() + " (" + this.mis.getFormat() + " format) ... ");
                    }
                } else if (in instanceof String) {
                    String s;
                    if (((String)in).startsWith("DB:")) {
                        String sin = (String)in;
                        this.tableName = sin.substring(3, sin.length());
                        SettingsHandler settingsHandler = null;
                        try {
                            settingsHandler = new SettingsHandler();
                            this.props = settingsHandler.getSettings();
                        }
                        catch (IOException exc) {
                            System.err.println("Cannot read properties file ");
                            this.exit(1);
                        }
                        this.conh = new ConnectionHandler();
                        if (!this.conh.loadValuesFromProperties(this.props)) {
                            System.err.println("More properties needed to make the connection.");
                            this.exit(1);
                        }
                        try {
                            this.conh.connect();
                            if (!DatabaseProperties.propertyTableExists(this.conh)) {
                                DatabaseProperties.createPropertyTable(this.conh);
                                System.err.println("Table " + this.conh.getPropertyTable() + " has been created." + lineSep + "It will store information on tables containing structures." + lineSep + "If necessary, please grant read/write access rights on this table to users." + lineSep);
                            }
                        }
                        catch (Exception exc) {
                            System.err.println("Cannot connect:");
                            exc.printStackTrace();
                            this.exit(1);
                        }
                        if (this.conh != null) {
                            this.searchInDatabase();
                        }
                        try {
                            this.conh.close();
                        }
                        catch (Exception e) {
                            System.err.println("Cannot close connection:");
                            e.printStackTrace();
                        }
                        return false;
                    }
                    if (!MFileFormatUtil.isURLOrFileName((String)in)) {
                        s = (String)in;
                        if (format2.equals("")) {
                            format2 = "cxsmiles";
                        }
                        this.mis = new MolInputStream((InputStream)new ByteArrayInputStream(s.getBytes()), format2, null, s);
                    } else {
                        s = (String)in;
                        if (format2.equals("")) {
                            format2 = MFileFormatUtil.getUnguessableFormat(s);
                        }
                        this.mis = format2 == null || !format2.equals("") ? new MolInputStream((InputStream)new FileInputStream(s), format2, null, s) : new MolInputStream((InputStream)new FileInputStream(s), null, null, s);
                        if (this.verbose > 1) {
                            System.err.println("Reading file " + (this.inFileIndex + 1) + " " + s + " (" + this.mis.getFormat() + " format) ... ");
                        }
                    }
                } else {
                    throw new IOException("internal error:bad object type in files vector: " + in.getClass().getName());
                }
                if ((infmt = this.mis.getFormat()).equals("gzip")) {
                    this.mis = new MolInputStream(new GZIPInputStream(this.mis));
                    infmt = this.mis.getFormat();
                }
                if (this.molimp != null) {
                    this.molimp.close();
                }
                this.molimp = null;
                try {
                    this.molimp = new MolImporter(this.mis);
                }
                catch (IOException ex) {
                    if (ex instanceof MolFormatException && this.outfmt.equals(infmt)) break block35;
                    throw ex;
                }
            }
            ++this.inMolIndex;
            this.hasMoreMols = this.convert0();
            if (this.hasMoreMols) continue;
            if (this.verbose > 0) {
                if (this.verbose > 1) {
                    System.err.print("... " + this.currentFileName() + ": ");
                }
                System.err.println("found/processed = " + this.outMolIndex + "/" + this.inMolIndex);
            }
            this.inMolIndex = -1;
            this.outMolIndex = 0;
            this.mis.close();
        }
        return this.hasMoreMols;
    }

    private synchronized boolean convert0() throws IOException, SearchException {
        if (this.molimp != null) {
            Molecule m = this.molbuf;
            m = ConfigTools.readMol(this.molimp, this.ignoreError);
            if (m != null) {
                boolean writeIt;
                if (ConfigTools.isReadErrorMol(m)) {
                    this.printError(ConfigTools.getReadErrorMessage(m));
                    return true;
                }
                boolean bl = writeIt = this.msearch == null || this.containsQuery(m);
                if (this.listNonHits) {
                    boolean bl2 = writeIt = !writeIt;
                }
                if (writeIt) {
                    ++this.outMolIndex;
                    ++this.totalMolIndex;
                    if (this.searchType != 100) {
                        boolean cleanNeeded;
                        int colon;
                        String infmt = m.getProperty("informat");
                        int n = colon = infmt != null ? infmt.indexOf(58) : -1;
                        if (infmt != null && colon >= 0) {
                            infmt = infmt.substring(0, colon);
                        }
                        boolean bl3 = cleanNeeded = this.cleanDim > 0 && infmt != null && MolHandler.isDaylightFormat(infmt) && !MolHandler.isDaylightFormat(this.outfmt);
                        if (this.forceCleaning || cleanNeeded) {
                            m.clean(this.cleanDim, this.cleanOpts);
                        }
                        try {
                            if (!this.outfmt.equals("mrv") || !this.hitColoring && !this.removeUnusedDef && this.align == 0) {
                                this.write(m);
                            } else {
                                this.printColoredHit(m);
                            }
                        }
                        catch (Exception e) {
                            if (this.ignoreError) {
                                String o = "Export error when writing molecule " + this.outMolIndex + ": " + e.getMessage();
                                this.writeObject(o);
                            }
                            throw new SearchException(e.getMessage());
                        }
                        if (this.totalMolIndex >= this.maxResults) {
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void printColoredHit(Molecule m) {
        if (!this.outfmt.equals("mrv") && (this.hitColoring || this.align != 0)) {
            System.err.println("Warning: --align and --hitColoring options works with MRV output only.");
        }
        HitColoringAndAlignmentOptions hco = new HitColoringAndAlignmentOptions();
        hco.coloring = true;
        if (!this.hitColorString.equals("")) {
            hco.hitColor = ColorParser.parseColor(this.hitColorString);
        }
        if (!this.hitHomologyColorString.equals("")) {
            hco.hitHomologyColor = ColorParser.parseColor(this.hitHomologyColorString);
        }
        if (!this.nonHitColorString.equals("")) {
            hco.nonHitColor = ColorParser.parseColor(this.nonHitColorString);
        }
        if (!this.nonHitColor3DString.equals("")) {
            hco.nonHitColor = ColorParser.parseColor(this.nonHitColor3DString);
        }
        hco.alignmentMode = this.align;
        hco.markushDisplayMode = this.markushDisplayMode;
        hco.setRemoveUnusedDefinitions(this.removeUnusedDef);
        MolSearchOptions mso = this.getSearchOptions();
        for (int i = 0; i < this.nonStardardizedQueryStructures.size(); ++i) {
            Molecule query = this.nonStardardizedQueryStructures.get(i);
            HitDisplayTool hdt = new HitDisplayTool(hco, mso, this.queryStandardizer, query);
            try {
                Molecule[] hit = new Molecule[1];
                if (this.allHits) {
                    hit = hdt.getHits(m, (Molecule)null, 0);
                } else {
                    hit[0] = hdt.getHit(m);
                }
                if (hit == null) continue;
                for (Molecule h : hit) {
                    this.write(h);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void write(Molecule m) throws IOException {
        if (this.outTagName == null) {
            this.exporter.write(m);
        } else {
            String tag = m.getProperty(this.outTagName);
            if (tag == null && "name".equalsIgnoreCase(this.outTagName)) {
                tag = m.getName();
            }
            this.writeObject(tag);
        }
    }

    private void searchInDatabase() {
        int noQueries;
        boolean useComplementaryIDs;
        MolSearchOptions mso;
        JChemSearch searcher;
        if (this.verbose > 0) {
            System.out.println("Searching in database table " + this.tableName + "\n");
        }
        JCSObserver observer = null;
        if (this.verbose > 0) {
            observer = JChemSearch.createJCSObserver();
            searcher = new JChemSearch((IncidentsObserver<JCSIncidents>)observer);
        } else {
            searcher = new JChemSearch();
        }
        searcher.setConnectionHandler(this.conh);
        searcher.setStructureTable(this.tableName);
        try {
            mso = this.getSearchOptions();
            DatabaseProperties dbp = new DatabaseProperties(this.conh, false);
            if (dbp.getTableType(TableInfo.getTableNameWithSchema(this.conh.getConnection(), this.tableName)) == 4 && !this.searchTypeSet) {
                mso.setSearchType(6);
                System.out.println("Warning: Superstructure search is the default search type for the query tables.");
            }
        }
        catch (SQLException se) {
            System.err.println(se);
            this.exit(1);
        }
        searcher.setResultTableMode(0);
        if (this.verbose > 1) {
            searcher.setInfoToStdError(true);
        }
        mso = this.getSearchOptions();
        SearchOptions so = new SearchOptions(2);
        mso.clonecopy(so);
        JChemSearchOptions jso = new JChemSearchOptions(2);
        so.clonecopy(jso);
        jso.setCacheRegistrationNeeded(false);
        jso.setDissimilarityThreshold(this.dissimilarityThreshold);
        jso.setAbsoluteStereo(this.DBAbsoluteStereo);
        if (this.expression != null) {
            if (this.expressionConfigFile != null) {
                jso.setChemTermsFilter(this.expression);
                jso.setChemTermsFilterConfig(this.expressionConfigFile);
            } else {
                jso.setChemTermsFilter(this.expression);
            }
        }
        if (this.maxResults != Integer.MAX_VALUE) {
            jso.setMaxResultCount(this.maxResults);
        }
        if (this.filterQuery != null) {
            jso.setFilterQuery(this.filterQuery);
        }
        boolean bl = useComplementaryIDs = (noQueries = this.queryStructures.size()) > 1 && !this.andMultipleQueries;
        if (useComplementaryIDs) {
            jso.setReturnsNonHits(!this.listNonHits);
        } else {
            jso.setReturnsNonHits(this.listNonHits);
        }
        jso.setMarkushScreeningEnabled(this.markushScreening);
        if (this.markushScreening) {
            jso.setMarkushScreeningTypes(this.markushScreeningOptions);
        }
        jso.setHaltOnError(this.haltOnError);
        Molecule query = noQueries > 0 ? this.queryStructures.get(0) : null;
        searcher.setQueryStructure(query);
        searcher.setSearchOptions(jso);
        this.runDBSearch(searcher, observer);
        if (noQueries > 1) {
            for (int i = 1; i < noQueries; ++i) {
                searcher.setQueryStructure(this.queryStructures.get(i));
                searcher.setFilterIDList(searcher.getResults());
                this.runDBSearch(searcher, observer);
            }
        }
        if (useComplementaryIDs) {
            jso.setReturnsNonHits(false);
            searcher.setSearchOptions(jso);
            searcher.setFilterIDList(null);
            searcher.setFilterIDNotList(searcher.getResults());
            searcher.setQueryStructure("");
            this.runDBSearch(searcher, observer);
        }
        try {
            if (this.searchType == 100) {
                this.totalMolIndex = searcher.getResultCount();
            } else if (this.isCd_idTheOnlyOutput()) {
                int[] ids;
                for (int cd_id : ids = searcher.getResults()) {
                    this.writeObject(Integer.toString(cd_id));
                }
            } else {
                if (searcher.getResultCount() != 0) {
                    ArrayList<String> dataFieldNames = new ArrayList<String>();
                    if (this.outTagName != null) {
                        dataFieldNames.add(this.outTagName);
                    } else if (this.outTagNames != null) {
                        for (int i = 0; i < this.outTagNames.length; ++i) {
                            dataFieldNames.add(this.outTagNames[i]);
                        }
                    }
                    HitColoringAndAlignmentOptions options = new HitColoringAndAlignmentOptions();
                    if (!this.outfmt.equals("mrv") && (this.hitColoring || this.align != 0)) {
                        System.err.println("Warning: --align and --hitColoring options works with MRV output only.");
                    }
                    if (this.hitColoring) {
                        options.coloring = true;
                        options.markushDisplayMode = this.markushDisplayMode;
                        if (!this.hitColorString.equals("")) {
                            options.hitColor = ColorParser.parseColor(this.hitColorString);
                        }
                        if (!this.hitHomologyColorString.equals("")) {
                            options.setHitHomologyColor(ColorParser.parseColor(this.hitHomologyColorString));
                        }
                        if (!this.nonHitColorString.equals("")) {
                            options.nonHitColor = ColorParser.parseColor(this.nonHitColorString);
                        }
                        if (!this.nonHitColor3DString.equals("")) {
                            options.nonHitColor = ColorParser.parseColor(this.nonHitColor3DString);
                        }
                    }
                    options.alignmentMode = this.align;
                    options.setRemoveUnusedDefinitions(this.removeUnusedDef);
                    int cells = searcher.getResultCount();
                    int batchNumber = cells % 100 == 0 ? cells / 100 : cells / 100 + 1;
                    for (int j = 0; j < batchNumber; ++j) {
                        int batchSize = cells % 100 != 0 && j + 1 == batchNumber ? cells % 100 : 100;
                        int[] ids = new int[batchSize];
                        for (int k = 0; k < batchSize; ++k) {
                            ids[k] = searcher.getResult(j * 100 + k);
                        }
                        ArrayList dataFieldValues = new ArrayList();
                        Molecule[] mols = searcher.getHitsAsMolecules(ids, options, dataFieldNames, dataFieldValues);
                        for (int i = 0; i < mols.length; ++i) {
                            boolean cleanNeeded;
                            int colon;
                            Object[] dataField;
                            ++this.outMolIndex;
                            if (this.outTagName != null) {
                                dataField = (Object[])dataFieldValues.get(i);
                                mols[i].setProperty(this.outTagName, dataField[0].toString());
                            } else if (this.outTagNames != null) {
                                dataField = (Object[])dataFieldValues.get(i);
                                for (int k = 0; k < this.outTagNames.length; ++k) {
                                    mols[i].setProperty(this.outTagNames[k], dataField[k].toString());
                                }
                            }
                            String infmt = mols[i].getProperty("informat");
                            int n = colon = infmt != null ? infmt.indexOf(58) : -1;
                            if (infmt != null && colon >= 0) {
                                infmt = infmt.substring(0, colon);
                            }
                            boolean bl2 = cleanNeeded = this.cleanDim > 0 && infmt != null && mols[i].getDim() == 0 && !MolHandler.isDaylightFormat(this.outfmt);
                            if (this.forceCleaning || cleanNeeded) {
                                mols[i].clean(this.cleanDim, this.cleanOpts);
                            }
                            try {
                                this.write(mols[i]);
                                continue;
                            }
                            catch (Exception e) {
                                if (this.ignoreError) {
                                    String o = "Export error when writing molecule " + this.outMolIndex + ": " + e.getMessage();
                                    this.writeObject(o);
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                    if (searcher.isMaxResultCountReached()) {
                        System.out.println("(Maximum hits reached)\n");
                    }
                    if (searcher.isMaxTimeReached()) {
                        System.out.println("(Maximum searching time reached)\n");
                    }
                }
                if (this.verbose >= 1) {
                    System.err.println("Found " + searcher.getResultCount() + " hits in table " + this.tableName + ".");
                    Search.printObserverStatus(observer, this.verbose);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exit(1);
        }
        this.hadDB = true;
    }

    private boolean isCd_idTheOnlyOutput() {
        boolean cd_idExportSpecified = false;
        if (this.outfmt.length() > 0) {
            return false;
        }
        if (this.outTagName != null) {
            if (this.outTagName.equalsIgnoreCase("cd_id")) {
                cd_idExportSpecified = true;
            } else {
                return false;
            }
        }
        if (this.outTagNames != null) {
            if (this.outTagNames.length > 1) {
                return false;
            }
            if (this.outTagNames.length == 1) {
                if (this.outTagNames[0].equalsIgnoreCase("cd_id")) {
                    cd_idExportSpecified = true;
                } else {
                    return false;
                }
            }
        }
        return cd_idExportSpecified;
    }

    private static void printObserverStatus(JCSObserver jcsObserver, int verbosityLevel) {
        if (jcsObserver == null) {
            return;
        }
        System.err.println("Search status:");
        System.err.println(jcsObserver.toString(verbosityLevel - 1));
    }

    private void runDBSearch(JChemSearch searcher, JCSObserver jcsObserver) {
        try {
            searcher.run();
        }
        catch (Exception e1) {
            System.err.println("Error during search " + e1.getMessage());
            e1.printStackTrace();
            Search.printObserverStatus(jcsObserver, this.verbose);
            this.exit(1);
        }
    }

    private void writeObject(Object o) throws IOException {
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            String s = (String)o;
            this.printwr.print(s);
            if (!s.endsWith("\n")) {
                this.printwr.print("\n");
            }
            this.printwr.flush();
        } else if (o instanceof byte[]) {
            byte[] d = (byte[])o;
            this.ostream.write(d);
            this.ostream.flush();
        }
    }

    private boolean containsQuery(Molecule m) throws SearchException {
        Molecule m1 = (Molecule)m.clone();
        this.prepareMolSearch(m1);
        MolSearchOptions mso = this.msearch.getSearchOptions();
        boolean undefRMatchingGroup = mso.isUndefinedRAtomMatchingGroup();
        boolean isSuper = mso.isSuperstructureSearch();
        boolean groupHitsRequired = false;
        int qn = this.queryStructures.size();
        if (qn == 0 && this.expression != null) {
            try {
                if (this.evaluator == null) {
                    this.evaluator = new Evaluator();
                    this.context = new MolContext();
                    this.jep = this.evaluator.compile(this.expression, MolContext.class);
                }
                this.context.setMolecule(m1);
                boolean match = this.jep.evaluate_boolean(this.context);
                return match;
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new SearchException(e.getMessage());
            }
        }
        for (int i = 0; i < qn; ++i) {
            boolean match;
            block16: {
                if (this.searchType == 3) {
                    MolHandler mh = new MolHandler(m1);
                    byte[] targetFP = mh.generateFingerprintInBytes(16, 2, 6);
                    double dissim = 1.0 - Similarity.getTanimoto(this.queryFP[i], targetFP);
                    match = dissim <= (double)this.dissimilarityThreshold;
                    m.setProperty("dissimilarity", String.valueOf(dissim));
                } else {
                    if (qn > 1 || this.firstQuery) {
                        Molecule query = this.queryStructures.get(i);
                        this.msearch.setQuery(query);
                        Molecule qRoleMol = isSuper ? this.msearch.getTarget() : query;
                        groupHitsRequired = this.allHits && (undefRMatchingGroup && SearchUtil.hasUndefinedRAtom(qRoleMol) || HomologyConstants.containsHomology(qRoleMol) || this.getSearchOptions().isMarkushEnabled() && this.getSearchOptions().getHitIndexType() == 0);
                        this.firstQuery = false;
                    }
                    if (this.allHits) {
                        int[][] hits = groupHitsRequired ? (int[][])null : this.msearch.findAll();
                        int[][][] groupHits = groupHitsRequired ? this.msearch.findAllGroups() : (int[][][])null;
                        match = hits != null || groupHits != null;
                        try {
                            if (this.searchType == 100) {
                                if (match) {
                                    int hl = groupHitsRequired ? groupHits.length : hits.length;
                                    this.totalMolIndex += hl - 1;
                                    return true;
                                }
                                break block16;
                            }
                            if (!match) break block16;
                            String header = SearchUtil.getHitReportHeader(groupHitsRequired ? groupHits.length : hits.length, qn > 1 ? i : -1);
                            this.writeObject(header);
                            if (groupHitsRequired) {
                                this.printGroupHits(groupHits);
                                break block16;
                            }
                            this.printHits(hits);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            this.exit(1);
                        }
                    } else {
                        match = this.msearch.isMatching();
                    }
                }
            }
            if (this.andMultipleQueriesInMolSearch && !match) {
                return false;
            }
            if (this.andMultipleQueriesInMolSearch || !match) continue;
            return true;
        }
        return this.andMultipleQueriesInMolSearch;
    }

    private void prepareMolSearch(Molecule m) {
        if (this.verbose > 2) {
            this.getSearchOptions().setVerbose(true);
            System.out.println("verbose");
        }
        this.standardize(m, false);
        this.msearch.setTarget(m);
    }

    private void printHits(int[][] hits) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        for (int j = 0; j < hits.length; ++j) {
            sb.setLength(0);
            SearchUtil.sprintHit(hits[j], j, sb);
            this.writeObject(sb.toString());
        }
    }

    private void printGroupHits(int[][][] groupHits) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        for (int j = 0; j < groupHits.length; ++j) {
            sb.setLength(0);
            SearchUtil.sprintGroupHit(groupHits[j], j, sb);
            this.writeObject(sb.toString());
        }
    }

    public long otell() throws IOException {
        if (this.oraf == null) {
            throw new IOException("Search cannot determine output file position");
        }
        return this.oraf.getFilePointer();
    }

    public void close() throws IOException {
        if (this.oraf == null) {
            throw new IOException("Search cannot close file opened by someone else");
        }
        this.oraf.close();
    }

    private void printError(Exception ex) {
        this.printError(ex, ex.getMessage());
    }

    private void printError(String msg) {
        this.printError(null, msg);
    }

    private void printError(Exception ex, String msg) {
        String s = "";
        Object o = this.inFiles.get(this.inFileIndex);
        if (o instanceof String) {
            s = s + (String)o + ":";
        } else if (o instanceof File) {
            s = s + ((File)o).getPath() + ":";
        }
        if (this.errorPrintingLevel < 2 && this.mis != null) {
            s = s + this.mis.getLineCount() + ": error in molecule";
            if (this.inMolIndex > 0) {
                s = s + " " + (this.inMolIndex + 1);
            }
            s = s + ":";
        }
        System.err.println(s + msg);
        if (ex != null && this.errorPrintingLevel == 0) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run() {
        this.hadDB = false;
        int n = 0;
        try {
            while (this.convert()) {
                ++n;
            }
            if (this.molimp != null) {
                this.molimp.close();
            }
            if (this.searchType == 100) {
                this.writeObject(Integer.toString(this.totalMolIndex));
            }
        }
        catch (IOException ex) {
            this.printError(ex);
            int n2 = 1;
            return n2;
        }
        catch (SearchException sex) {
            this.printError(sex);
            int n3 = 1;
            return n3;
        }
        finally {
            try {
                this.exporter.close(2);
            }
            catch (IOException e) {
                this.printError(e);
            }
        }
        if (this.verbose > 0 && !this.hadDB) {
            if (n == 0) {
                System.err.println("No structures found.");
            } else {
                System.err.print(n + " molecule");
                if (n > 1) {
                    System.err.print("s");
                }
                System.err.println(" processed.");
            }
        }
        return 0;
    }

    private void exit(int exitCode) {
        if (this.isExitAllowed) {
            if (exitCode != 0) {
                System.err.println("The program will exit with exit code: " + exitCode);
            }
            System.exit(exitCode);
        } else if (exitCode != 0) {
            throw new RuntimeException("jcsearch exit:" + exitCode);
        }
    }

    private static void runSearch(String[] args, int errorPrintingLevel, boolean isExitAllowed) {
        int ecode = 0;
        Search mc = new Search(errorPrintingLevel, isExitAllowed);
        try {
            mc.setParameters(args);
            mc.init();
            ecode = mc.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ecode = 1;
        }
        mc.exit(ecode);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(strhelp);
            return;
        }
        Search.runSearch(args, 0, true);
    }

    public static void mainWithoutExit(String[] args) {
        Search.mainWithoutExit(args, 1);
    }

    public static void mainWithoutExit(String[] args, int errorPrintingLevel) {
        Search.runSearch(args, errorPrintingLevel, false);
    }
}

