/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.rmi.TableScan;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.util.ArrayList;
import oracle.aurora.memoryManager.Callback;
import oracle.aurora.memoryManager.EndOfCallRegistry;

public class CallCleanUp
implements Callback {
    private static final JCartLogger logger = JCartLogger.getLogger(CallCleanUp.class);
    private static CallCleanUp self;
    private static ArrayList scanResultRefs;

    public static void registerResultRef(TableScan ref) {
        if (logger.isDebugEnabled()) {
            logger.debug("registerResultRef called with " + ref);
        }
        if (scanResultRefs == null) {
            self = new CallCleanUp();
            EndOfCallRegistry.registerCallback((Callback)self);
            scanResultRefs = new ArrayList();
        }
        scanResultRefs.add(ref);
    }

    public void act(Object obj) {
        if (scanResultRefs == null) {
            return;
        }
        self = null;
        if (logger.isDebugEnabled()) {
            logger.debug("act called with " + obj);
        }
        for (TableScan ref : scanResultRefs) {
            if (logger.isDebugEnabled()) {
                logger.debug("Calling dispose on " + ref);
            }
            try {
                ref.dispose();
            }
            catch (Throwable tbl) {
                tbl.printStackTrace();
            }
        }
        scanResultRefs.clear();
        scanResultRefs = null;
    }
}

