/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.JCartDml;
import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.JcSimilarity;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.JavaStoredProcExceptionHandler;
import chemaxon.jchem.cartridge.oresident.util.HTMLTools;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.ARRAY;
import oracle.sql.BLOB;
import sqlj.runtime.RuntimeContext;

public class JCFunctionsBlob {
    private JCFunctionsBlob() {
    }

    public static String execFunction(String sqlOperator, String target, BLOB query, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, String[] result) throws Exception {
        return JFunctions.execFunction(sqlOperator, target, JCFunctionsBlob.blobToString(query), options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag, result);
    }

    public static String execFunction(String sqlOperator, BLOB target, String query, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, String[] result) throws Exception {
        return JFunctions.execFunction(sqlOperator, JCFunctionsBlob.blobToString(target), query, options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag, result);
    }

    public static String execFunction(String sqlOperator, BLOB target, BLOB query, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, String[] result) throws Exception {
        return JFunctions.execFunction(sqlOperator, JCFunctionsBlob.blobToString(target), JCFunctionsBlob.blobToString(query), options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag, result);
    }

    public static String execFunctionB(String sqlOperator, BLOB target, BLOB query, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, BLOB[] result) throws Exception {
        String[] r = new String[1];
        String error = JFunctions.execFunction(sqlOperator, JCFunctionsBlob.blobToString(target), JCFunctionsBlob.blobToString(query), options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag, r);
        if (error == null) {
            result[0] = JCFunctionsBlob.stringToTmpBlob(r[0], null);
        }
        return error;
    }

    public static ARRAY evaluateArr(BLOB target, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        Object[] objArray = (Object[])JFunctions.evaluateToAny("T_EVALUATE", JCFunctionsBlob.blobToString(target), options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, 2004);
        return JFunctions.convertToARRAY(objArray, "BLOB_ARRAY");
    }

    public static ARRAY hitColorAndAlignOptions(String tblSchema, String tblName, String colName, BLOB query, String rowids, String options, String hitColorAlignOptions, long scanId) throws Exception {
        Object[] objArray = JFunctions.hitColorAlignObjecArr(tblSchema, tblName, colName, JCFunctionsBlob.blobToString(query), rowids, options, hitColorAlignOptions, 2004, scanId);
        return JFunctions.convertToARRAY(objArray, "BLOB_ARRAY");
    }

    public static String calcValue(BLOB query, String rid, String params, String method, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcValue(JCFunctionsBlob.blobToString(query), rid, params, method, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static String indexScan(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String optype, String optypeFlavor, String start, String stop, int opFlag, BLOB query, String options, long scanId) throws Exception {
        return JFunctions.indexScan(idxSchema, idxName, idxPartition, tblSchema, tblName, colName, optype, optypeFlavor, start, stop, opFlag, JCFunctionsBlob.blobToString(query), options, scanId);
    }

    public static int getHitCount(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String jpName, String optype, String optypeFlavor, String start, String stop, int opFlag, BLOB query, String options, long scanId) throws Exception {
        return JFunctions.getHitCount(idxSchema, idxName, idxPartition, tblSchema, tblName, colName, jpName, optype, optypeFlavor, start, stop, opFlag, JCFunctionsBlob.blobToString(query), options, scanId);
    }

    public static String getSimilarity(BLOB query, String searchType, String start, String stop, int opFlag, String searchOptions, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, long scanId) throws Exception {
        return JcSimilarity.getSimilarity(JCFunctionsBlob.blobToString(query), searchType, start, stop, opFlag, searchOptions, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId);
    }

    public static String insertMolIntoIndexTable(BLOB str, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String rid) throws Exception {
        if (JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false)) {
            return null;
        }
        try {
            JCartIndexDescriptor idesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
            JCartDml.insertMolIntoIndexTable(JCFunctionsBlob.blobToString(str), idesc, rid);
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    public static String updateMolIndexTable(BLOB oldValue, BLOB newValue, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String rid) throws Exception {
        if (JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false)) {
            return null;
        }
        String oldv = JCFunctionsBlob.blobToString(oldValue);
        String newv = JCFunctionsBlob.blobToString(newValue);
        if (oldv == null || newv == null ? oldv == null && newv == null : oldv.equals(newv)) {
            return null;
        }
        try {
            JCartIndexDescriptor idesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
            JCartDml.updateMolIndexTable(newv, idesc, rid);
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    public static ARRAY insertMol(BLOB str, String tblName, String JCPName, String dupChk, String hod, String options) throws Exception {
        return JCartDml.insertMol(JCFunctionsBlob.blobToString(str), tblName, JCPName, dupChk, hod, options);
    }

    public static int updateMol(BLOB newStr, String tblName, int id, String JCPName, String options) throws Exception {
        return JCartDml.updateMol(JCFunctionsBlob.blobToString(newStr), tblName, id, JCPName, options);
    }

    public static BLOB calcMolProp(BLOB query, String type, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        String prop = JFunctions.calcMolProp(JCFunctionsBlob.blobToString(query), type, rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
        return JCFunctionsBlob.stringToTmpBlob(prop, null);
    }

    public static double calcMolPropNum(BLOB query, String type, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcMolPropNum(JCFunctionsBlob.blobToString(query), type, rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static BLOB calcMolPropFromRowid(String rid, String type, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        String prop = JFunctions.calcMolPropFromRowid(rid, type, idxSchema, idxName, idxPartition, tblSchema, tblName);
        return JCFunctionsBlob.stringToTmpBlob(prop, null);
    }

    public static double calcMolPropNumFromRowid(String rid, String type, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcMolPropNumFromRowid(rid, type, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static double getMolweight(BLOB query, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcMolPropNum(JCFunctionsBlob.blobToString(query), "molweight", rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static String getMolformula(BLOB query, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.calcMolProp(JCFunctionsBlob.blobToString(query), "molformula", rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static String getSqlForFormulaScan(String type, String idxSchema, String idxName, String idxPartition, BLOB query, String predicate) throws Exception {
        return JFunctions.getSqlForFormulaScan(idxSchema, idxName, idxPartition, JCFunctionsBlob.blobToString(query), predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BLOB molconvertb(BLOB query, String inputFormat, String options, String otherOptions, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, BLOB tmpBlob) throws Exception {
        Connection conn = RuntimeContext.getRuntime().getDefaultConnection();
        if (tmpBlob == null) {
            tmpBlob = BLOB.createTemporary((Connection)conn, (boolean)false, (int)10);
        }
        OutputStream os = tmpBlob.getBinaryOutputStream();
        try {
            byte[] bytes = JFunctions.molconvertToBytes(JCFunctionsBlob.blobToByteArray(query), inputFormat, options, otherOptions);
            os.write(bytes);
            BLOB bLOB = tmpBlob;
            return bLOB;
        }
        finally {
            os.close();
        }
    }

    public static BLOB react(BLOB reaction, BLOB reactant1, BLOB reactant2, BLOB reactant3, BLOB reactant4, String options, BLOB tempBlob, String oldJcReact) throws Exception {
        String[] products = JFunctions.react(JCFunctionsBlob.blobToString(reaction), JCFunctionsBlob.blobToString(reactant1), JCFunctionsBlob.blobToString(reactant2), JCFunctionsBlob.blobToString(reactant3), JCFunctionsBlob.blobToString(reactant4), options, oldJcReact, false);
        if (products == null || products.length == 0) {
            return null;
        }
        return JCFunctionsBlob.stringToTmpBlob(products[0], tempBlob);
    }

    public static ARRAY reactArr(BLOB reaction, BLOB reactant1, BLOB reactant2, BLOB reactant3, BLOB reactant4, String options, BLOB tempBlob) throws Exception {
        Object[] objArray = JFunctions.reactObjArr(JCFunctionsBlob.blobToString(reaction), JCFunctionsBlob.blobToString(reactant1), JCFunctionsBlob.blobToString(reactant2), JCFunctionsBlob.blobToString(reactant3), JCFunctionsBlob.blobToString(reactant4), options, "f", true);
        return JFunctions.convertToARRAY(objArray, "BLOB_PRODUCT_ARRAY");
    }

    public static BLOB standardize(BLOB structure, String param, BLOB tempBlob) throws Exception {
        String result = JFunctions.standardize(JCFunctionsBlob.blobToString(structure), param);
        return JCFunctionsBlob.stringToTmpBlob(result, tempBlob);
    }

    public static BLOB sendUserFunc(String name, String delim, BLOB params) throws Exception {
        return JCFunctionsBlob.stringToTmpBlob(JFunctions.sendUserFunc(name, delim, JCFunctionsBlob.blobToString(params)), null);
    }

    public static BLOB convertForJavaScript(BLOB blob) throws Exception {
        return JCFunctionsBlob.convertForJavaScript(blob, null);
    }

    public static BLOB convertForJavaScript(BLOB blob, BLOB tempBlob) throws Exception {
        String js = HTMLTools.convertForJavaScript(JCFunctionsBlob.blobToString(blob));
        return JCFunctionsBlob.stringToTmpBlob(js, tempBlob);
    }

    public static String convertForJavaScriptToStr(BLOB blob) throws Exception {
        return HTMLTools.convertForJavaScript(JCFunctionsBlob.blobToString(blob));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String blobToString(BLOB blob) throws Exception {
        if (blob == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int bufferSize = blob.getBufferSize();
        byte[] buffer = new byte[bufferSize];
        InputStream instream = blob.getBinaryStream();
        try {
            int readCount = instream.read(buffer);
            while (readCount != -1) {
                bout.write(buffer, 0, readCount);
                readCount = instream.read(buffer);
            }
            String string = new String(bout.toByteArray());
            return string;
        }
        finally {
            instream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] blobToByteArray(BLOB blob) throws Exception {
        if (blob == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int bufferSize = blob.getBufferSize();
        byte[] buffer = new byte[bufferSize];
        InputStream instream = blob.getBinaryStream();
        try {
            byte[] result;
            int readCount = instream.read(buffer);
            while (readCount != -1) {
                bout.write(buffer, 0, readCount);
                readCount = instream.read(buffer);
            }
            byte[] byArray = result = bout.toByteArray();
            return byArray;
        }
        finally {
            instream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BLOB stringToTmpBlob(String string, BLOB tempBlob) throws Exception {
        if (string == null) {
            return null;
        }
        if (tempBlob == null) {
            Connection conn = JavaStoredProcSession.instance().getConnection();
            tempBlob = BLOB.createTemporary((Connection)conn, (boolean)true, (int)10);
        }
        OutputStream os = tempBlob.getBinaryOutputStream();
        try {
            os.write(string.getBytes());
            BLOB bLOB = tempBlob;
            return bLOB;
        }
        finally {
            os.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int equals(BLOB b1, BLOB b2) throws Exception {
        if (b1 == null) return 0;
        if (b2 == null) {
            return 0;
        }
        if (b1.equals((Object)b2)) {
            return 1;
        }
        InputStream instream1 = b1.getBinaryStream();
        try {
            InputStream instream2 = b2.getBinaryStream();
            try {
                int readCount1;
                int bufferSize = Math.max(b1.getBufferSize(), b2.getBufferSize());
                byte[] buffer1 = new byte[bufferSize];
                byte[] buffer2 = new byte[bufferSize];
                do {
                    int readCount2;
                    if ((readCount1 = instream1.read(buffer1)) != (readCount2 = instream1.read(buffer2))) {
                        int n = 0;
                        return n;
                    }
                    if (readCount1 != -1) continue;
                    int n = 1;
                    return n;
                } while (JCFunctionsBlob.compare(buffer1, buffer2, readCount1));
                int n = 0;
                return n;
            }
            finally {
                instream2.close();
            }
        }
        finally {
            instream1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadBlobContent(String tableName, String columnName, byte[] structure, String rid) throws Exception {
        String sql = "select " + columnName + " from " + tableName + " where rid = ? for update";
        PreparedStatement psSelect = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            psSelect.setString(1, rid);
            ResultSet rs = psSelect.executeQuery();
            rs.next();
            JCFunctionsBlob.writeStructureToBlob(rs, structure);
        }
        finally {
            JavaStoredProcSession.instance().close(null, psSelect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadBlobContent(String tableName, String columnName, byte[] newStruct, int id) throws Exception {
        StringBuffer sqlBuffer = new StringBuffer("SELECT " + columnName + " FROM ").append(tableName).append(" WHERE cd_id = ? FOR UPDATE");
        PreparedStatement ps1 = JavaStoredProcSession.instance().prepareStatement(sqlBuffer.toString());
        try {
            ps1.setInt(1, id);
            ResultSet rs = ps1.executeQuery();
            if (!rs.next()) {
                JFunctions.trace("No such cd_id: " + id);
                boolean bl = false;
                return bl;
            }
            JCFunctionsBlob.writeStructureToBlob(rs, newStruct);
            boolean bl = true;
            return bl;
        }
        finally {
            JavaStoredProcSession.instance().close(null, ps1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeStructureToBlob(ResultSet rs, byte[] structure) throws Exception {
        Blob blob = rs.getBlob(1);
        BLOB oraBlob = (BLOB)blob;
        OutputStream outstream = oraBlob.getBinaryOutputStream();
        try {
            outstream.write(structure);
        }
        finally {
            outstream.close();
        }
    }

    public static boolean compare(byte[] b1, byte[] b2, int length) {
        for (int ix = 0; ix < length; ++ix) {
            if (b1[ix] == b2[ix]) continue;
            return false;
        }
        return true;
    }

    public static void freeTemporary(BLOB blob) throws Exception {
        BLOB.freeTemporary((BLOB)blob);
    }

    public static void trace(String msg) throws SQLException {
        JFunctions.trace(msg);
    }

    public static int isInsertable(BLOB structure, String schemaName, String tableName, String columnName) throws Exception {
        return JCartDml.isInsertable(JCFunctionsBlob.blobToString(structure), schemaName, tableName, columnName);
    }
}

