/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.JCFunctionsBlob;
import chemaxon.jchem.cartridge.JCFunctionsClob;
import chemaxon.jchem.cartridge.JCartSearch;
import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.dbsession.DbSession;
import chemaxon.jchem.cartridge.dbsession.DbSessionBase;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.JavaStoredProcExceptionHandler;
import chemaxon.jchem.cartridge.oresident.ScanContext;
import chemaxon.jchem.cartridge.oresident.nonidxscan.IdxBasedTarget;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NonIdxScanOperation;
import chemaxon.jchem.cartridge.oresident.nonidxscan.NonIdxScanOperationFactory;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.profiling.OraSearchProfile;
import chemaxon.jchem.cartridge.resultset.CdIdResultSet;
import chemaxon.jchem.cartridge.resultset.EarlyCdIdResultSet;
import chemaxon.jchem.cartridge.resultset.JCCartResultSet;
import chemaxon.jchem.cartridge.resultset.NullResultSet;
import chemaxon.jchem.cartridge.resultset.SearchExInfoSupport;
import chemaxon.jchem.cartridge.rmi.Admin;
import chemaxon.jchem.cartridge.rmi.ErrorCache;
import chemaxon.jchem.cartridge.rmi.EvalTableScanner;
import chemaxon.jchem.cartridge.rmi.JCartProfiler;
import chemaxon.jchem.cartridge.rmi.JcReact;
import chemaxon.jchem.cartridge.rmi.JccSecurityException;
import chemaxon.jchem.cartridge.rmi.JchemSearch;
import chemaxon.jchem.cartridge.rmi.KilledTaskException;
import chemaxon.jchem.cartridge.rmi.Miscellanious;
import chemaxon.jchem.cartridge.rmi.ReactProducts;
import chemaxon.jchem.cartridge.rmi.RmiTunnel;
import chemaxon.jchem.cartridge.rmi.TableScan;
import chemaxon.jchem.cartridge.rmi.UserDefFunc;
import chemaxon.jchem.cartridge.rmi.client.RmiDirectory;
import chemaxon.jchem.cartridge.structs.JCartDefaultProperties;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.EvalChemTermInfo;
import chemaxon.jchem.cartridge.tunnel.ExUserInfo;
import chemaxon.jchem.cartridge.tunnel.GlobalMemoryInfo;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.tunnel.TableOpInfo;
import chemaxon.jchem.cartridge.tunnel.TaskInfo;
import chemaxon.jchem.cartridge.tunnel.UserDefFuncInfo;
import chemaxon.jchem.cartridge.tunnel.UserInfo;
import chemaxon.jchem.cartridge.tunnel.search.ErrorRecord;
import chemaxon.jchem.cartridge.tunnel.search.PredicateInfo;
import chemaxon.jchem.cartridge.tunnel.search.SearchInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import chemaxon.jchem.interop.InteropUtil;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.rmi.NoSuchObjectException;
import java.rmi.ServerException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class JFunctions {
    public static JCartLogger logger = JCartLogger.getLogger(JFunctions.class);
    private static final String ISPECTVIEW_OPTION = "ispectview";
    private static int lastIspectViewId;
    private static Map ispectViewIdxSnc;
    public static Long profileId;
    public static OraSearchProfile searchProfile;
    public static final String NULL_VALUE = "{JCHEMCARTRIDGE_NULL}";
    public static final String EMPTY_STRING = "";
    public static final String CTRL_STRUCTURE_END = "{STRUCTURE_END}";
    public static final int CTRL_STRUCTURE_END_LENGTH;
    public static final String CTRL_FORMULA_END = "{FORMULA_END}";
    public static final int CTRL_FORMULA_END_LENGTH;
    public static final String CTRL_MOLWEIGHT_END = "{MOLWEIGHT_END}";
    public static final int CTRL_MOLWEIGHT_END_LENGTH;
    public static final String HALT_ON_BADFORM_KEY = "haltOnBadFormat";
    public static final String HALT_ON_ERROR_KEY = "haltOnError";
    public static final String ON_ERROR_KEY = "onError";
    public static final String MISC_RECORD_STOP = "{JCARTMIS~CRECORD_STOP}__";
    public static final String[] SEARCH_OPERATORS;
    public static final int DEFAULT_SMILES_COL_LENGTH = 1000;
    public static final SimpleDateFormat sdf;
    public static final int NON_FP_MOLPROPS = 6;
    static String registrationCode;
    private static final Hashtable scanResultMap;
    private static final Map structDescriptorCache;
    private static String JCHEM_VERSION;
    private static Integer JCHEM_TABLE_VERSION;

    public static void memstat(String dir, String name) throws Exception {
    }

    private static Exception throwableToException(Throwable throwable) throws Exception {
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        if (logger.isErrorEnabled()) {
            logger.error(throwable);
        }
        return new RuntimeException(throwable.getMessage());
    }

    public static int trimErrorMessages() {
        return 1;
    }

    public static void init() {
        JavaStoredProcSession.instance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String getJChemVersion(DbSession session) throws Exception {
        if (JCHEM_VERSION != null) return JCHEM_VERSION;
        if (session != null && session instanceof JavaStoredProcSession) {
            String sql = "select " + JavaStoredProcSession.instance().getJccOwner() + ".jchem_core_pkg.getJChemVersion() " + "from dual";
            if (logger.isDebugEnabled()) {
                logger.debug("getJChemVersion executing " + sql + "...");
            }
            Statement stmt = JavaStoredProcSession.instance().getConnection().createStatement();
            try {
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                JCHEM_VERSION = rs.getString(1);
                if (!logger.isDebugEnabled()) return JCHEM_VERSION;
                logger.debug("getJChemVersion found" + JCHEM_VERSION);
                return JCHEM_VERSION;
            }
            finally {
                stmt.close();
            }
        } else {
            Class<?> clazz = Class.forName("chemaxon.jchem.version.VersionInfo");
            JCHEM_VERSION = (String)clazz.getField("JCHEM_VERSION").get(null);
        }
        return JCHEM_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getTableVersion() throws Exception {
        if (JCHEM_TABLE_VERSION == null) {
            String sql = "select " + JavaStoredProcSession.instance().getJccOwner() + ".jchem_core_pkg.getTableVersion() " + "from dual";
            PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(sql);
            try {
                ResultSet rs = ps.executeQuery(sql);
                rs.next();
                JCHEM_TABLE_VERSION = new Integer(rs.getInt(1));
            }
            finally {
                ps.close();
            }
        }
        return JCHEM_TABLE_VERSION;
    }

    public static String getEnvironment(String[] result) throws Exception {
        try {
            UserInfo userInfo = JavaStoredProcSession.instance().getUserInfo();
            result[0] = RmiDirectory.instance().locate().getEnvironment(userInfo);
            return null;
        }
        catch (Exception e) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(e);
        }
    }

    public static void checkMasterTable() throws Exception {
        JcMetaDataFunctions.getJspInstance().checkMasterTable();
    }

    public static void setMasterProperty(String idxSchema, String propertyName, String propertyValue) throws Exception {
        JcMetaDataFunctions.getJspInstance().setMasterProperty(idxSchema, propertyName, propertyValue);
    }

    public static void setDefaultProperty(String name, String value) throws Exception {
        JcMetaDataFunctions.getJspInstance().initMetadataMaybe(null);
        JcMetaDataFunctions.getJspInstance().setDefaultProperty(name, value);
        JCartDefaultProperties.getInstance(JavaStoredProcSession.instance()).reset();
    }

    static void checkTableVersion(DbSession dbSession, String jpName, String idxTblQName) throws Exception {
        JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get(dbSession, idxTblQName, jpName);
        JFunctions.checkTableVersion(idxDesc);
    }

    private static void checkTableVersion(JCartIndexDescriptor idxDesc) throws Exception {
        String objectRef = null;
        objectRef = idxDesc.isJChemTable() ? "Table '" + idxDesc.getIdxTableQName() + "'" : "Index '" + idxDesc.getIndexSchemaName() + "." + idxDesc.getIndexName() + "'";
        if (idxDesc.getIdxCompatibility() < 0) {
            String msg = objectRef + " contains obsolete data.";
            if (idxDesc.isJChemTable()) {
                msg = msg + "Please, drop the index and use " + "JChemManager to upgrade the table " + "(http://www.chemaxon.com/jchem/doc/admin/#regener) " + "before recreating the jc_idxtype type.";
            }
            throw new RuntimeException(msg);
        }
        if (idxDesc.getIdxCompatibility() > 0) {
            throw new RuntimeException(objectRef + " contains " + "newer data version that this program version " + "can handle. Please use a later version of JChem.");
        }
    }

    public static void checkTableVersion(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName) throws Exception {
        if (idxName == null) {
            throw new RuntimeException("Please, create domain index on table '" + tblSchema + "." + tblName + "'");
        }
        JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
        JFunctions.checkTableVersion(idxDesc);
    }

    public static String useDefaultAccount() throws Exception {
        try {
            JavaStoredProcSession.instance().setUserInfo(new SessionInfo(null, null, null));
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    public static String usePassword(String login, String password) throws Exception {
        try {
            String l_login = login;
            String l_password = password;
            JavaStoredProcSession jspSession = JavaStoredProcSession.instance();
            if (login == null) {
                l_login = jspSession.getRealUser();
                if (password == null) {
                    l_password = jspSession.getPassword();
                }
            }
            if (l_password == null) {
                throw new JccSecurityException("No password specified");
            }
            String dbHostName = null;
            String dbIstanceName = null;
            String[] names = JFunctions.getHostAndInstanceName();
            if (names != null) {
                dbHostName = names[0];
                dbIstanceName = names[1];
            }
            ExUserInfo userInfo = new ExUserInfo(l_login, l_password, dbHostName, dbIstanceName);
            RmiTunnel rmiTunnel = JFunctions.getRmiTunnel();
            rmiTunnel.process(userInfo);
            if (login == null) {
                if (password != null) {
                    jspSession.setPassword(password);
                }
                jspSession.setUserInfo(null);
            } else {
                jspSession.setUserInfo(new UserInfo(login, l_password));
            }
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    public static RmiTunnel getRmiTunnel() throws Exception {
        return (RmiTunnel)RmiDirectory.instance().getServer("Tunnel");
    }

    public static String[] getHostAndInstanceName() throws Exception {
        return JcMetaDataFunctions.getJspInstance().getHostAndInstanceName();
    }

    public static String exec(String options, String execPath, String param1, String param2) throws Exception {
        return JFunctions.execRemote(options, execPath, param1, param2);
    }

    public static String execRemote(String options, String execPath, String param1, String param2) throws Exception {
        Miscellanious m = (Miscellanious)RmiDirectory.instance().getServer("MiscellaniousServer");
        try {
            return m.exec(options, new String[]{execPath, param1, param2});
        }
        catch (ServerException serverException) {
            throw new RuntimeException(serverException.detail.getMessage());
        }
    }

    public static String execFunction(String sqlOperator, String target, String query, String optionsString, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag, String[] result) throws Exception {
        try {
            String r;
            result[0] = r = JFunctions.execFunction(sqlOperator, target, query, optionsString, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId, scanFlag);
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String execFunction(String sqlOperator, String target, String query, String optionsString, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, int scanId, int scanFlag) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("execFunction(sqlOperator=" + sqlOperator + ", target=" + target + ", query=" + query + ", optionsString=" + optionsString + ", rid=" + rid + ", idxSchema=" + idxSchema + ", idxName=" + idxName + ", idxPartition=" + idxPartition + ", tblSchema=" + tblSchema + ", tblName=" + tblName + ", scanId=" + scanId + ", scanFlag=" + scanFlag + ")");
        }
        if (scanFlag == 1) {
            ScanContext.releaseSoftData(scanId);
            return null;
        }
        JavaStoredProcSession dbSession = JavaStoredProcSession.instance();
        JCartIndexDescriptor jccIdxDesc = null;
        try {
            ScanContext scanCtx;
            if (idxName != null && !JFunctions.selectedByFilterQuery(rid, (scanCtx = ScanContext.getCreateScanContext(jccIdxDesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName), scanId, null, new Date(), sqlOperator, query, optionsString, null, !sqlOperator.equals("EVALUATE"))).getSoftData())) {
                return null;
            }
            NonIdxScanOperationFactory factory = NonIdxScanOperationFactory.instance();
            NonIdxScanOperation nisOperation = factory.get(scanId, sqlOperator, optionsString);
            byte[] encodedTarget = JFunctions.encodeDbString(target);
            byte[] encodedQuery = JFunctions.encodeDbString(query);
            try {
                String result;
                JavaStoredProcExceptionHandler.setLastError(null);
                if (idxName == null) {
                    JCartDefaultProperties jcp = JCartDefaultProperties.getInstance(dbSession);
                    String string = (String)nisOperation.execute(jcp, encodedTarget, encodedQuery);
                    return string;
                }
                IdxBasedTarget idxBasedTarget = new IdxBasedTarget(jccIdxDesc, encodedTarget, rid);
                String string = result = (String)nisOperation.execute(idxBasedTarget, encodedQuery);
                return string;
            }
            finally {
                factory.release(nisOperation);
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("execFunction: " + JCartLogger.stackTrace(e));
            }
            boolean deferErrorHandling = false;
            if (!sqlOperator.equals("EVALUATE")) {
                CxOptions cxOptions = new CxOptions(optionsString);
                boolean bl = deferErrorHandling = !cxOptions.getBoolValue(HALT_ON_ERROR_KEY, true);
            }
            if (jccIdxDesc == null || !jccIdxDesc.isMarkushIndex()) {
                if (!deferErrorHandling) throw e;
            }
            ((ErrorCache)RmiDirectory.instance().getServer("ErrorCache")).addErrorRecord(dbSession.getSessionInfo().getSessionId(), new ErrorRecord(scanId, rid, 0, JFunctions.stackTrace(e), null));
            if (!logger.isDebugEnabled()) return null;
            logger.debug("execFunction: returning null");
            return null;
        }
    }

    private static boolean selectedByFilterQuery(String rid, ScanContext.SoftData softData) {
        boolean result = true;
        if (softData != null && softData.getFilterQueryResults() != null) {
            result = softData.getFilterQueryResults().contains(rid);
        }
        if (logger.isDebugEnabled()) {
            String filterQueryResultSize = "null";
            if (softData != null && softData.getFilterQueryResults() != null) {
                filterQueryResultSize = EMPTY_STRING + softData.getFilterQueryResults().size();
            }
            logger.debug("Returning " + result + " for " + rid + " after checking among " + filterQueryResultSize + " filterQuery hits");
        }
        return result;
    }

    public static String stackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object evaluateToAny(String sqlFrontEnd, String target, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, int colType) throws Exception {
        JavaStoredProcSession dbSession = JavaStoredProcSession.instance();
        NonIdxScanOperationFactory factory = NonIdxScanOperationFactory.instance();
        NonIdxScanOperation niso = factory.get(-1L, sqlFrontEnd, options);
        try {
            String[] result = null;
            if (idxName != null) {
                JCartIndexDescriptor jccIdxDesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, null);
                IdxBasedTarget idxBasedTarget = new IdxBasedTarget(jccIdxDesc, JFunctions.encodeDbString(target), rid);
                String[] stringArray = result = (String[])niso.execute(idxBasedTarget, null);
                return stringArray;
            }
            JCartDefaultProperties jcp = JCartDefaultProperties.getInstance(dbSession);
            result = (String[])niso.execute(jcp, JFunctions.encodeDbString(target), null);
            Object[] objectArray = JFunctions.stringArrToTmpLobArr(result, colType);
            return objectArray;
        }
        finally {
            factory.release(niso);
        }
    }

    public static ARRAY evaluateArr(String target, String options, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        Object[] objArray = (Object[])JFunctions.evaluateToAny("T_EVALUATE", target, options, rid, idxSchema, idxName, idxPartition, tblSchema, tblName, 12);
        return JFunctions.convertToARRAY(objArray, "CHAR_ARRAY");
    }

    public static Object[] stringArrToTmpLobArr(String[] stringArr, int colType) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String elem = null;
        for (int i = 0; i < stringArr.length; ++i) {
            String r = stringArr[i];
            switch (colType) {
                case 12: {
                    elem = r;
                    break;
                }
                case 2005: {
                    elem = JCFunctionsClob.stringToTmpClob(r, null);
                    break;
                }
                case 2004: {
                    elem = JCFunctionsBlob.stringToTmpBlob(r, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Uknown structColType: " + colType);
                }
            }
            list.add(elem);
        }
        switch (colType) {
            case 12: {
                return list.toArray(new String[list.size()]);
            }
            case 2005: {
                return list.toArray(new CLOB[list.size()]);
            }
            case 2004: {
                return list.toArray(new BLOB[list.size()]);
            }
        }
        throw new IllegalArgumentException("Uknown structColType: " + colType);
    }

    public static boolean isLobCol(int structColType) {
        return structColType == 2005 || structColType == 2004;
    }

    public static String calcValue(String query, String rid, String params, String method, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static String react(String reaction, String reactant1, String reactant2, String reactant3, String reactant4, String options, String oldJcReactStr) throws Exception {
        if (options == null) {
            options = EMPTY_STRING;
        }
        String[] reactantArray = new String[]{reactant1, reactant2, reactant3, reactant4};
        boolean oldJcReact = oldJcReactStr != null && oldJcReactStr.toLowerCase().startsWith("t");
        SessionInfo sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
        JcReact jcReact = (JcReact)RmiDirectory.instance().getServer("Reactor");
        return jcReact.reactSimple(reaction, reactantArray, options, oldJcReact, sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] react(String reaction, String reactant1, String reactant2, String reactant3, String reactant4, String options, String oldJcReactStr, boolean separateOutMols) throws Exception {
        if (options == null) {
            options = EMPTY_STRING;
        }
        String[] reactantArray = new String[]{reactant1, reactant2, reactant3, reactant4};
        SessionInfo sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
        boolean oldJcReact = oldJcReactStr != null && oldJcReactStr.toLowerCase().startsWith("t");
        JcReact jcReact = (JcReact)RmiDirectory.instance().getServer("Reactor");
        ReactProducts reactProducts = null;
        try {
            reactProducts = jcReact.react(reaction, reactantArray, options, oldJcReact, separateOutMols, sessionInfo, Integer.MAX_VALUE);
            String[] p = reactProducts.getNextProducts();
            if (p == null) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] stringArray = p;
            return stringArray;
        }
        finally {
            if (reactProducts != null) {
                reactProducts.dispose();
            }
        }
    }

    public static Object[] reactObjArr(String reaction, String reactant1, String reactant2, String reactant3, String reactant4, String options, String oldJcReact, boolean blob) throws Exception {
        String[] products = JFunctions.react(reaction, reactant1, reactant2, reactant3, reactant4, options, oldJcReact, true);
        ArrayList<STRUCT> list = new ArrayList<STRUCT>();
        STRUCT record = null;
        for (int i = 0; i < products.length; ++i) {
            String molStringObj;
            String p = products[i];
            int molStringStop = p.indexOf("{molprop}");
            String molString = null;
            String synthCode = null;
            if (molStringStop != -1) {
                molString = p.substring(0, molStringStop);
                int synthCodeStart = molStringStop + "{molprop}".length();
                synthCode = p.substring(synthCodeStart);
            } else {
                molString = p;
            }
            if (blob) {
                molStringObj = JCFunctionsBlob.stringToTmpBlob(molString, null);
                record = JFunctions.createSqlStruct("BLOB_PRODUCT_RECORD", new Object[]{molStringObj, synthCode});
            } else {
                molStringObj = molString;
                record = JFunctions.createSqlStruct("CHAR_PRODUCT_RECORD", new Object[]{molStringObj, synthCode});
            }
            list.add(record);
        }
        return list.toArray(new STRUCT[list.size()]);
    }

    public static ARRAY reactArr(String reaction, String reactant1, String reactant2, String reactant3, String reactant4, String options, String oldJcReact) throws Exception {
        Object[] objArray = JFunctions.reactObjArr(reaction, reactant1, reactant2, reactant3, reactant4, options, oldJcReact, false);
        ARRAY arr = JFunctions.convertToARRAY(objArray, "CHAR_PRODUCT_ARRAY");
        return arr;
    }

    public static ARRAY convertToARRAY(Object[] objArray, String arrayTypeInJccOwnerSchema) throws SQLException {
        String installSchema = JavaStoredProcSession.instance().getJccOwner();
        Connection conn = JavaStoredProcSession.instance().getConnection();
        ArrayDescriptor arraydesc = ArrayDescriptor.createDescriptor((String)(installSchema + "." + arrayTypeInJccOwnerSchema), (Connection)conn);
        return new ARRAY(arraydesc, conn, (Object)objArray);
    }

    public static STRUCT createGMemUtilRecord(String name, long value) throws Exception {
        return JFunctions.createSqlStruct("GMEM_UTIL_RECORD", new Object[]{name, new Long(value)});
    }

    public static STRUCT createSqlStruct(String typeName, Object[] attribValues) throws Exception {
        return new STRUCT(JFunctions.getStructDescriptor(typeName), JavaStoredProcSession.instance().getConnection(), attribValues);
    }

    public static ARRAY getGlobalMemUtil() throws Exception {
        Admin admin = (Admin)RmiDirectory.instance().getServer("AdminServer");
        GlobalMemoryInfo gmeminfo = admin.getGlobalMemoryInfo();
        ArrayList<STRUCT> l = new ArrayList<STRUCT>();
        l.add(JFunctions.createGMemUtilRecord("Total JVM memory", gmeminfo.totalJvmMemory));
        l.add(JFunctions.createGMemUtilRecord("Free JVM memory", gmeminfo.freeJvmMemory));
        l.add(JFunctions.createGMemUtilRecord("Max JVM memory", gmeminfo.maxJvmMemory));
        for (int ix = 0; ix < gmeminfo.cachedTables.length; ++ix) {
            l.add(JFunctions.createGMemUtilRecord(gmeminfo.cachedTables[ix][0], Long.parseLong(gmeminfo.cachedTables[ix][1])));
        }
        Object[] arr = new STRUCT[l.size()];
        l.toArray(arr);
        return JFunctions.convertToARRAY(arr, "GMEM_UTIL_ARRAY");
    }

    public static STRUCT createTaskInfoRecord(TaskInfo taskInfo) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating record from " + taskInfo);
        }
        Object[] attribs = new Object[]{new Long(taskInfo.id), taskInfo.userName, taskInfo.description, taskInfo.memoryUsed, taskInfo.timeout, taskInfo.jccSessionId, taskInfo.userAssignedOpId, JFunctions.toTimestamp(taskInfo.startTime), JFunctions.toTimestamp(taskInfo.lastRescheduled)};
        return JFunctions.createSqlStruct("TASKINFO_RECORD", attribs);
    }

    public static Object toTimestamp(Date utilDate) throws SQLException {
        if (utilDate == null) {
            return null;
        }
        return new Timestamp(utilDate.getTime());
    }

    public static StructDescriptor getStructDescriptor(String typeName) throws Exception {
        String installSchema = JavaStoredProcSession.instance().getJccOwner();
        StructDescriptor sd = (StructDescriptor)structDescriptorCache.get(typeName);
        if (sd == null) {
            sd = StructDescriptor.createDescriptor((String)(installSchema + "." + typeName), (Connection)JavaStoredProcSession.instance().getConnection());
            structDescriptorCache.put(typeName, sd);
        }
        return sd;
    }

    public static ARRAY getTaskInfos() throws Exception {
        String cartOwner;
        Admin admin = (Admin)RmiDirectory.instance().getServer("AdminServer");
        String realUser = JavaStoredProcSession.instance().getRealUser();
        String userSelector = realUser.equals(cartOwner = JavaStoredProcSession.instance().getJccOwner()) ? null : realUser;
        TaskInfo[] taskInfoArray = admin.getTaskInfos(userSelector);
        ArrayList<STRUCT> l = new ArrayList<STRUCT>();
        for (int ix = 0; ix < taskInfoArray.length; ++ix) {
            l.add(JFunctions.createTaskInfoRecord(taskInfoArray[ix]));
        }
        Object[] arr = new STRUCT[l.size()];
        l.toArray(arr);
        return JFunctions.convertToARRAY(arr, "TASKINFO_ARRAY");
    }

    public static String calcValueFromRowid(String rid, String params, String method, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static final String getUserAssignedOpId(CxOptions cxOptions) {
        return cxOptions.getStringValue("usrOpId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JCCartResultSet indexScanUc(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String jccOperator, String optypeFlavor, String start, String stop, int opFlag, String query, String options, long scanId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("JFunctions.sendBatch BEGIN");
        }
        if (query == null) {
            return new NullResultSet();
        }
        if (options == null) {
            options = EMPTY_STRING;
        }
        CxOptions cxOptions = new CxOptions(options);
        if (options != null && options.indexOf(ISPECTVIEW_OPTION) != -1) {
            int id = cxOptions.getIntValue(ISPECTVIEW_OPTION, -1);
            ispectViewIdxSnc.put(new Integer(id), new String[]{idxSchema, idxName, colName});
            return new NullResultSet();
        }
        JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
        ScanContext.getCreateScanContext(idxDesc, scanId, null, new Date(), jccOperator, query, options, null, false);
        long termTime = JFunctions.getTermTime(cxOptions);
        PreparedStatement ps = null;
        String jpName = "JChemProperties";
        if (idxName != null) {
            jpName = JcMetaDataFunctions.getJspInstance().getPropertyTableName(idxSchema, idxName, idxPartition);
        }
        SessionInfo userInfo = JFunctions.createSessionInfo();
        int threadCount = cxOptions.getIntValue("threadCnt", 0);
        if (JFunctions.isSearchOperator(jccOperator)) {
            boolean earlyResults = true;
            int earlyResultsInc = cxOptions.getIntValue("earlyResults", 100);
            earlyResults = earlyResultsInc != 0;
            SearchInfo searchInfo = new SearchInfo(scanId, idxDesc, userInfo, JFunctions.getUserAssignedOpId(cxOptions), threadCount, new PredicateInfo(start, stop, opFlag), query, jccOperator, options, earlyResults, profileId, JFunctions.getOldVsn(idxSchema, idxName, idxPartition));
            boolean inTxPerfectSearch = false;
            String searchType = cxOptions.getStringValue("t");
            if (searchType != null && (searchType.equalsIgnoreCase("p") || searchType.equalsIgnoreCase("d"))) {
                boolean bl = inTxPerfectSearch = !cxOptions.getBoolValue("requireCommit", true);
            }
            if (inTxPerfectSearch) {
                return JCartSearch.perfectSearchInTx(searchInfo, termTime);
            }
            return JFunctions.sendSearchInfo(searchInfo, termTime, cxOptions.getStringValue("usrOpId"));
        }
        if (jccOperator.startsWith("JC_EVALUATE")) {
            EvalChemTermInfo info = new EvalChemTermInfo(scanId, idxDesc, userInfo, JFunctions.getUserAssignedOpId(cxOptions), threadCount, new PredicateInfo(start, stop, opFlag), query, options);
            return JFunctions.sendEvalInfo(info);
        }
        String stmt = "SELECT * FROM " + idxSchema + ".jc_idx_udop WHERE " + "op_name = ?";
        String className = null;
        String delim = null;
        String plist = null;
        ResultSet rset = null;
        ps = JavaStoredProcSession.instance().prepareStatement(stmt);
        try {
            ps.setString(1, options);
            rset = ps.executeQuery();
            if (!rset.next()) {
                throw new Exception("Operator not registered: " + options);
            }
            className = rset.getString(2);
            delim = rset.getString(3);
            plist = rset.getString(4);
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rset, ps);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rset, ps);
        UserDefFuncInfo info = new UserDefFuncInfo(scanId, idxDesc, userInfo, JFunctions.getUserAssignedOpId(cxOptions), new PredicateInfo(start, stop, opFlag), className, query, delim);
        return new EarlyCdIdResultSet(info, Long.MAX_VALUE);
    }

    private static boolean isSearchOperator(String jccOperator) {
        for (int i = 0; i < SEARCH_OPERATORS.length; ++i) {
            if (!jccOperator.startsWith(SEARCH_OPERATORS[i])) continue;
            return true;
        }
        return false;
    }

    private static SessionInfo createSessionInfo() throws SQLException {
        return JavaStoredProcSession.instance().getSessionInfo();
    }

    public static String indexScan(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String jccOperator, String optypeFlavor, String start, String stop, int opFlag, String query, String options, long scanId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("JFunctions.sendBatch outer BEGIN");
        }
        try {
            JCCartResultSet jcCartResultSet = JFunctions.indexScanUc(idxSchema, idxName, idxPartition, tblSchema, tblName, colName, jccOperator, optypeFlavor, start, stop, opFlag, query, options, scanId);
            JFunctions.addScanResult(scanId, jcCartResultSet);
            if (logger.isDebugEnabled()) {
                logger.debug("JFunctions.sendBatch outer END");
            }
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchObjectException) {
                return JavaStoredProcExceptionHandler.handleTopLevelError(new KilledTaskException("No such object"));
            }
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    public static String[] hitColorAlign(String tblSchema, String tblName, String colName, String query, String rowids, String options, String hitColorAlignOptions, long scanId) throws Exception {
        if (tblSchema == null) {
            tblSchema = JavaStoredProcSession.instance().getRealUser();
        }
        String[] idxSnc = JFunctions.getIdxSchemaIdxNameIdxCol(tblSchema, tblName, colName);
        String idxSchema = idxSnc[0];
        String idxName = idxSnc[1];
        String idxColName = idxSnc[2];
        String idxPartition = null;
        JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, null, null, idxColName);
        SessionInfo userInfo = JFunctions.createSessionInfo();
        CxOptions jcOpts = new CxOptions(options);
        int threadCount = jcOpts.getIntValue("threadCnt", 0);
        SearchInfo searchInfo = new SearchInfo(scanId, idxDesc, userInfo, JFunctions.getUserAssignedOpId(jcOpts), threadCount, null, query, null, options, false, profileId, JFunctions.getOldVsn(idxSchema, idxName, idxPartition));
        JchemSearch js = (JchemSearch)RmiDirectory.instance().getServer("JchemSearchServer");
        return js.hitColorAndAlign(searchInfo, rowids, hitColorAlignOptions);
    }

    public static Object[] hitColorAlignObjecArr(String tblSchema, String tblName, String colName, String query, String rowids, String options, String hitColorAlignOptions, int colType, long scanId) throws Exception {
        String[] stringArr = JFunctions.hitColorAlign(tblSchema, tblName, colName, query, rowids, options, hitColorAlignOptions, scanId);
        return JFunctions.stringArrToTmpLobArr(stringArr, colType);
    }

    public static int getHitCount(String tblSchema, String tblName, String colName, String query, String options) throws Exception {
        String idxPartition = null;
        String jccOperator = "JC_COMPARE";
        String optypeFlavor = null;
        String[] idxSchemaIdxNameIdxCol = JFunctions.getIdxSchemaIdxNameIdxCol(tblSchema, tblName, colName);
        String idxSchema = idxSchemaIdxNameIdxCol[0];
        String idxName = idxSchemaIdxNameIdxCol[1];
        String idxCol = idxSchemaIdxNameIdxCol[2];
        String jpName = JcMetaDataFunctions.getJspInstance().getPropertyTableName(idxSchema, idxName, idxPartition);
        return JFunctions.getHitCount(idxSchema, idxName, idxPartition, tblSchema, tblName, colName, jpName, jccOperator, optypeFlavor, "1", "1", 13, query, options, JFunctions.generateScanId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long generateScanId() throws SQLException {
        String sql = "select jchem_defright_pkg.get_next_scanId from dual";
        ResultSet rs = null;
        JavaStoredProcSession dbSession = JavaStoredProcSession.instance();
        PreparedStatement pstmt = dbSession.prepareStatement(sql);
        try {
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("Baj van koepecen!!!");
            }
            long l = rs.getLong(1);
            return l;
        }
        finally {
            dbSession.close(rs, pstmt);
        }
    }

    public static String getIdxTableQName(String idxSchema, String idxName, String idxPartition, int evenIfJChemTable) throws Exception {
        return JcMetaDataFunctions.getJspInstance().getIdxTableQName(idxSchema, idxName, idxPartition, evenIfJChemTable);
    }

    private static String[] getIdxSchemaIdxNameIdxCol(String tblSchema, String tblName, String colName) throws SQLException, Exception {
        if (JFunctions.isTable(tblSchema, tblName)) {
            String[] sn = JcMetaDataFunctions.getJspInstance().getIdxSchemaAndName(tblSchema, tblName, colName, JavaStoredProcSession.instance().getJccOwner());
            return new String[]{sn[0], sn[1], colName};
        }
        return JFunctions.getIdxSchemaIdxNameIdxColFromView(tblSchema, tblName, colName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTable(String tblSchema, String tblName) throws SQLException {
        boolean bl;
        String sql = "select count(*) from all_tables where owner = ? and table_name = ?";
        ResultSet rs = null;
        PreparedStatement pstmt = JavaStoredProcSession.instance().prepareStatement(sql);
        try {
            boolean isTable;
            pstmt.setString(1, tblSchema.toUpperCase());
            pstmt.setString(2, tblName.toUpperCase());
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new RuntimeException("No rows returned.");
            }
            boolean bl2 = isTable = rs.getInt(1) > 0;
            if (rs.next()) {
                throw new RuntimeException("Too many rows returned");
            }
            bl = isTable;
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rs, pstmt);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rs, pstmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getIdxSchemaIdxNameIdxColFromView(String tblSchema, String tblName, String colName) throws Exception {
        int id = lastIspectViewId++;
        String sql = "select count(*) from " + tblSchema + "." + tblName + " where jc_compare(" + colName + ", 'c', 't:s " + ISPECTVIEW_OPTION + ":" + id + "') = 1";
        ResultSet rs = null;
        PreparedStatement pstmt = JavaStoredProcSession.instance().getConnection().prepareStatement(sql);
        try {
            rs = pstmt.executeQuery();
            rs.next();
            String[] stringArray = (String[])ispectViewIdxSnc.remove(new Integer(id));
            return stringArray;
        }
        finally {
            pstmt.close();
        }
    }

    public static int getHitCount(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, String jpName, String jccOperator, String optypeFlavor, String start, String stop, int opFlag, String query, String options, long scanId) throws Exception {
        int hitCount = -1;
        JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
        SessionInfo userInfo = JFunctions.createSessionInfo();
        CxOptions jcOpts = new CxOptions(options);
        int threadCount = jcOpts.getIntValue("threadCnt", 0);
        if (JFunctions.isSearchOperator(jccOperator)) {
            boolean earlyResults = true;
            if (options != null && options.toLowerCase().indexOf("earlyResults:0".toLowerCase()) != -1) {
                earlyResults = false;
            }
            SearchInfo searchInfo = new SearchInfo(scanId, idxDesc, userInfo, JFunctions.getUserAssignedOpId(jcOpts), threadCount, new PredicateInfo(start, stop, opFlag), query, jccOperator, options, earlyResults, profileId, JFunctions.getOldVsn(idxSchema, idxName, idxPartition));
            JchemSearch jcsearch = (JchemSearch)RmiDirectory.instance().getServer("JchemSearchServer");
            hitCount = jcsearch.getHitCount(searchInfo);
        } else if (jccOperator.startsWith("JC_EVALUATE")) {
            EvalChemTermInfo info = new EvalChemTermInfo(scanId, idxDesc, userInfo, JFunctions.getUserAssignedOpId(jcOpts), threadCount, new PredicateInfo(start, stop, opFlag), query, options);
            EvalTableScanner evalScanner = (EvalTableScanner)RmiDirectory.instance().getServer("EvalTableScanner");
            hitCount = evalScanner.getHitCount(info);
        } else {
            throw new IllegalArgumentException(jccOperator);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getHitCount: hitCount=" + hitCount);
        }
        return hitCount;
    }

    public static ARRAY prepareCdIdArray(Connection conn, int[] data, String idxTblQName, boolean isJChemTable) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static boolean isNullString(byte[] data) throws Exception {
        String s;
        return data.length == 4 && (s = new String(data, "US-ASCII")).equals("null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JCCartResultSet sendSearchInfo(SearchInfo searchInfo, long termTime, String usrOpId) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("JFunctions.sendQueryForCached BEGIN");
        }
        JCCartResultSet r = null;
        if (JFunctions.isProfiling()) {
            JFunctions.searchProfile.sentFromOracle = System.currentTimeMillis();
        }
        if (searchInfo.isEarlyResults()) {
            r = new EarlyCdIdResultSet(searchInfo, termTime, usrOpId);
        } else {
            int[] hits = null;
            JchemSearch jchemSearch = (JchemSearch)RmiDirectory.instance().getServer("JchemSearchServer");
            if (logger.isDebugEnabled()) {
                logger.debug("About to sending search request to server...");
            }
            TableScan scanResult = jchemSearch.search(searchInfo);
            if (logger.isDebugEnabled()) {
                logger.debug("Hits received from server.");
            }
            try {
                hits = scanResult.getNextHits();
                if (hits == null) {
                    hits = new int[]{};
                }
                r = CdIdResultSet.createCdIdResultSet((TableOpInfo)searchInfo, hits, termTime);
            }
            finally {
                if (usrOpId != null) {
                    SearchExInfoSupport.instance.map(usrOpId, scanResult.getSearchId());
                }
                scanResult.dispose();
            }
            if (JFunctions.isProfiling()) {
                JFunctions.searchProfile.receivedByOracle = System.currentTimeMillis();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("JFunctions.sendQueryForCached END");
        }
        return r;
    }

    private static JCCartResultSet sendEvalInfo(EvalChemTermInfo evalInfo) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("JFunctions.sendEvalInfo BEGIN");
        }
        EarlyCdIdResultSet jcrs = new EarlyCdIdResultSet(evalInfo, Long.MAX_VALUE);
        if (logger.isDebugEnabled()) {
            logger.debug("JFunctions.sendEvalInfo END");
        }
        return jcrs;
    }

    static long getTermTime(CxOptions cxOptions) {
        long startTime = System.currentTimeMillis();
        long timeLimit = 0L;
        String sval = cxOptions.getStringValue("maxTime");
        if (sval != null) {
            timeLimit = Long.parseLong(sval);
        }
        if (timeLimit == 0L) {
            return Long.MAX_VALUE;
        }
        return startTime + timeLimit;
    }

    public static String standardize(String structure, String param) throws Exception {
        String stdrConfig = null;
        String cleaningTemplate = null;
        String outFormat = null;
        String[] allowedOptions = new String[]{"config", "sql", "cleaningTemplate", "outFormat", ON_ERROR_KEY};
        CxOptions jcOptions = new CxOptions(allowedOptions, param);
        String onErrorConfig = jcOptions.getStringValue(ON_ERROR_KEY, "halt");
        if (!(onErrorConfig.equalsIgnoreCase("halt") || onErrorConfig.equalsIgnoreCase("null") || onErrorConfig.equalsIgnoreCase("inputStructure"))) {
            throw new IllegalArgumentException("Not allowed option for onError: " + onErrorConfig);
        }
        try {
            String sql;
            stdrConfig = jcOptions.getStringValue("config");
            if (stdrConfig == null) {
                sql = jcOptions.getStringValue("sql");
                if (sql == null) {
                    throw new IllegalArgumentException("Either the 'config' or the 'sql' option must be specified");
                }
                stdrConfig = JFunctions.getFirstStringResult(sql);
            }
            if ((sql = jcOptions.getStringValue("cleaningTemplate")) != null) {
                cleaningTemplate = JFunctions.getFirstStringResult(sql);
            }
            outFormat = jcOptions.getStringValue("outFormat");
            Miscellanious m = (Miscellanious)RmiDirectory.instance().getServer("MiscellaniousServer");
            return m.standardize(structure, stdrConfig, cleaningTemplate, outFormat);
        }
        catch (Exception e) {
            if (onErrorConfig.equalsIgnoreCase("null")) {
                if (logger.isWarningEnabled()) {
                    logger.warning("Standardize error, returning null");
                }
                ((ErrorCache)RmiDirectory.instance().getServer("ErrorCache")).addErrorRecord(JavaStoredProcSession.instance().getJccSessionId(), new ErrorRecord(-1L, null, 0, JFunctions.stackTrace(e), null));
                return null;
            }
            if (onErrorConfig.equalsIgnoreCase("inputStructure")) {
                if (logger.isWarningEnabled()) {
                    logger.warning("Standardize error, returning i");
                }
                ((ErrorCache)RmiDirectory.instance().getServer("ErrorCache")).addErrorRecord(JavaStoredProcSession.instance().getJccSessionId(), new ErrorRecord(-1L, null, 0, JFunctions.stackTrace(e), null));
                return structure;
            }
            throw e;
        }
    }

    public static String getFirstStringResult(String sql) throws Exception {
        PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(sql);
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = new String(JFunctions.readBytes(rs, 1));
                return string;
            }
            throw new IllegalArgumentException("Nothing was returned from '" + sql + "'");
        }
        finally {
            JavaStoredProcSession.instance().close(rs, ps);
        }
    }

    public static String isJChemTable(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false) ? "true" : "false";
    }

    static boolean isJChemTable(String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, boolean doubleCheck) throws Exception {
        String idxTableQName = JcMetaDataFunctions.getJspInstance().getIdxTableQName(idxSchema, idxName, idxPartition);
        if (idxTableQName != null) {
            return false;
        }
        if (doubleCheck) {
            block5: {
                boolean bl;
                PreparedStatement ps = null;
                ResultSet rset = null;
                StringBuilder stringBuilder = new StringBuilder().append("SELECT prop_value FROM ");
                JcMetaDataFunctions.getJspInstance();
                String stmt = stringBuilder.append(JcMetaDataFunctions.getJspInstance().getMasterIdxTableName(idxSchema)).append(" WHERE prop_name = ?").toString();
                try {
                    String idxQName = JcMetaDataFunctions.getJspInstance().getIdxQName(idxSchema, idxName, idxPartition);
                    ps = JavaStoredProcSession.instance().prepareStatement(stmt);
                    ps.setString(1, idxQName.toUpperCase() + ".JChemProperties");
                    rset = ps.executeQuery();
                    if (!rset.next()) break block5;
                    bl = true;
                }
                catch (Throwable throwable) {
                    JavaStoredProcSession.instance().close(rset, ps);
                    throw throwable;
                }
                JavaStoredProcSession.instance().close(rset, ps);
                return bl;
            }
            throw new Exception("There is no index defined on " + tblSchema + "." + tblName);
        }
        return true;
    }

    public static String getSqlForFormulaScan(String idxSchema, String idxName, String idxPartition, String query, String predicate) throws Exception {
        predicate = Integer.parseInt(predicate) == 0 ? " cd_formula != '" + query + "'" : " cd_formula = '" + query + "'";
        return JFunctions.getSqlForIndexScan(idxSchema, idxName, idxPartition, predicate);
    }

    public static String getSqlForMolweightScan(String idxSchema, String idxName, String idxPartition, String start, String stop, int opFlag) throws Exception {
        String columnToScan = "cd_molweight";
        String predicate = null;
        predicate = start == null ? (opFlag == 8 ? columnToScan + " <= " + stop : columnToScan + " < " + stop) : (stop == null ? (opFlag == 4 ? columnToScan + " >= " + start : columnToScan + " > " + start) : (opFlag == 13 ? columnToScan + " = " + start : (opFlag == 12 ? columnToScan + " <= " + stop + " AND " + columnToScan + " >= " + start : (opFlag == 8 ? columnToScan + " <= " + stop + " AND " + columnToScan + " > " + start : (opFlag == 4 ? columnToScan + " < " + stop + " AND " + columnToScan + " >= " + start : columnToScan + " < " + stop + " AND " + columnToScan + " > " + start)))));
        return JFunctions.getSqlForIndexScan(idxSchema, idxName, idxPartition, predicate);
    }

    private static String getSqlForIndexScan(String idxSchema, String idxName, String idxPartition, String predicate) throws Exception {
        JCartIndexDescriptor idxDescriptor = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition);
        String ridColName = idxDescriptor.isJChemTable() ? "rowid" : "rid";
        String sql = "select " + ridColName + " from " + idxDescriptor.getIdxTableQName() + " where " + predicate;
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlForIndexScan is returning sql=" + sql + "...");
        }
        return sql;
    }

    public static String calcMolProp(String query, String type, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        String colName = null;
        if (!type.equals("molformula")) {
            throw new IllegalArgumentException("Not a property of string type: " + type);
        }
        colName = "cd_formula";
        return (String)JFunctions.calcMolPropObj(query, colName, rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static double calcMolPropNum(String query, String type, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        String colName = null;
        if (!type.equals("molweight")) {
            throw new IllegalArgumentException("Unexpected property type: " + type);
        }
        colName = "cd_molweight";
        Object retval = JFunctions.calcMolPropObj(query, colName, rid, idxSchema, idxName, idxPartition, tblSchema, tblName);
        if (retval == null) {
            return Double.NaN;
        }
        if (retval instanceof BigDecimal) {
            return ((BigDecimal)retval).doubleValue();
        }
        return (Double)retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object calcMolPropObj(String query, String colName, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        JavaStoredProcSession dbSession = JavaStoredProcSession.instance();
        String fromTable = tblSchema + "." + tblName;
        String keyName = "ROWID";
        if (rid != null) {
            Object object;
            boolean isJChemTable = JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false);
            if (!isJChemTable) {
                fromTable = JcMetaDataFunctions.getJspInstance().getIdxTableQName(idxSchema, idxName, idxPartition);
                keyName = "rid";
            }
            Object retval = null;
            StringBuffer stmt = new StringBuffer("SELECT ");
            stmt.append(colName).append(" FROM ").append(fromTable);
            stmt.append(" WHERE ").append(keyName).append(" = ?");
            PreparedStatement ps = null;
            ResultSet rset = null;
            ps = JavaStoredProcSession.instance().prepareStatement(stmt.toString());
            try {
                ps.setString(1, rid);
                rset = ps.executeQuery();
                rset.next();
                retval = rset.getObject(1);
                if (logger.isDebugEnabled()) {
                    logger.debug("calcMolProp: molProp=" + colName + ", retval=" + retval);
                }
                object = retval;
            }
            catch (Throwable throwable) {
                JavaStoredProcSession.instance().close(rset, ps);
                ps = null;
                throw throwable;
            }
            JavaStoredProcSession.instance().close(rset, ps);
            ps = null;
            return object;
        }
        String stdrConfig = JCartDefaultProperties.getInstance(dbSession).getStandardizerConfig();
        Miscellanious m = (Miscellanious)RmiDirectory.instance().getServer("MiscellaniousServer");
        Object retval = m.getMolProperty(query, stdrConfig, colName);
        if (logger.isDebugEnabled()) {
            logger.debug("calcMolProp: retval=" + retval);
        }
        return retval;
    }

    public static String calcMolPropFromRowid(String rid, String type, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        return (String)JFunctions.calcMolPropObjFromRowid(rid, type, idxSchema, idxName, idxPartition, tblSchema, tblName);
    }

    public static double calcMolPropNumFromRowid(String rid, String type, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        BigDecimal bd = (BigDecimal)JFunctions.calcMolPropObjFromRowid(rid, type, idxSchema, idxName, idxPartition, tblSchema, tblName);
        return bd.doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object calcMolPropObjFromRowid(String rid, String type, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        Object object;
        boolean isJChemTable = JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false);
        if (!isJChemTable) {
            return null;
        }
        String stmt = "SELECT " + (type.equals("molformula") ? "cd_formula" : "cd_molweight") + " FROM " + tblSchema + "." + tblName + " WHERE ROWID = ?" + rid;
        PreparedStatement ps = null;
        ResultSet rset = null;
        ps = JavaStoredProcSession.instance().prepareStatement(stmt);
        try {
            ps.setString(1, rid);
            rset = ps.executeQuery();
            rset.next();
            object = rset.getObject(1);
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rset, ps);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rset, ps);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String molconvertFromRowid(String rid, String format2, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        String string;
        boolean isJChemTable = JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false);
        if (!isJChemTable) {
            return null;
        }
        String stmt = "SELECT cd_structure FROM " + tblSchema + "." + tblName + " WHERE ROWID = ?";
        PreparedStatement ps = null;
        ResultSet rset = null;
        ps = JavaStoredProcSession.instance().prepareStatement(stmt);
        try {
            ps.setString(1, rid);
            rset = ps.executeQuery();
            rset.next();
            byte[] ba = JFunctions.readBytes(rset, "cd_structure");
            byte[] result = JFunctions.molconvertToBytes(ba, null, format2, null);
            string = result == null ? null : new String(result);
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rset, ps);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rset, ps);
        return string;
    }

    public static String molconvert(String query, String inputFormat, String options, String otherOptions, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName) throws Exception {
        byte[] result = JFunctions.molconvertToBytes(query.getBytes(), inputFormat, options, otherOptions);
        return result == null ? null : new String(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BLOB molconvertBFromRowid(String rid, String format2, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, BLOB tmp) throws Exception {
        BLOB bLOB;
        boolean isJChemTable = JFunctions.isJChemTable(idxSchema, idxName, idxPartition, tblSchema, tblName, false);
        if (!isJChemTable) {
            return null;
        }
        String stmt = "SELECT cd_structure FROM " + tblSchema + "." + tblName + " WHERE ROWID = ?";
        PreparedStatement ps = null;
        ResultSet rset = null;
        ps = JavaStoredProcSession.instance().prepareStatement(stmt);
        try {
            ps.setString(1, rid);
            rset = ps.executeQuery();
            rset.next();
            byte[] ba = JFunctions.readBytes(rset, "cd_structure");
            bLOB = JFunctions.molconvertb(new String(ba), null, format2, null, null, null, null, null, null, null, tmp);
        }
        catch (Throwable throwable) {
            JavaStoredProcSession.instance().close(rset, ps);
            throw throwable;
        }
        JavaStoredProcSession.instance().close(rset, ps);
        return bLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BLOB molconvertb(String query, String inputFormat, String options, String otherOptions, String rid, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, BLOB blob) throws Exception {
        if (blob == null) {
            blob = JFunctions.createTemporaryBlob();
        }
        OutputStream os = blob.getBinaryOutputStream();
        try {
            byte[] result = JFunctions.molconvertToBytes(query.getBytes(), inputFormat, options, otherOptions);
            if (result == null) {
                BLOB bLOB = null;
                return bLOB;
            }
            os.write(result);
            BLOB bLOB = blob;
            return bLOB;
        }
        finally {
            os.close();
        }
    }

    public static BLOB createTemporaryBlob() throws Exception {
        return BLOB.createTemporary((Connection)JavaStoredProcSession.instance().getConnection(), (boolean)false, (int)10);
    }

    public static byte[] molconvertToBytes(byte[] query, String inputFormat, String options, String otherOptions) throws Exception {
        try {
            Miscellanious m = (Miscellanious)RmiDirectory.instance().getServer("MiscellaniousServer");
            if (logger.isDebugEnabled()) {
                logger.debug("molconvertToBytes sending " + query.length + " bytes...");
            }
            byte[] result = m.molconvertb(query, inputFormat, options);
            if (logger.isDebugEnabled()) {
                logger.debug("molconvertToBytes received " + result.length + " bytes");
            }
            return result;
        }
        catch (Exception e) {
            boolean deferErrorHandling;
            CxOptions cxOptions = new CxOptions(otherOptions);
            boolean bl = deferErrorHandling = !cxOptions.getBoolValue(HALT_ON_ERROR_KEY, true);
            if (deferErrorHandling) {
                ((ErrorCache)RmiDirectory.instance().getServer("ErrorCache")).addErrorRecord(JavaStoredProcSession.instance().getSessionInfo().getSessionId(), new ErrorRecord(-1L, null, 0, JFunctions.stackTrace(e), null));
                if (logger.isDebugEnabled()) {
                    logger.debug("execFunction: returning null");
                }
                return null;
            }
            throw e;
        }
    }

    public static String sendUserFunc(String name, String delim, String params) throws Exception {
        UserDefFunc u = (UserDefFunc)RmiDirectory.instance().getServer("UserDefFuncServer");
        return u.single(name, delim, params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getRowids(long scanId, int nrows, ResultSet[] resultSetHolder) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("getRowids: scanId=" + scanId);
        }
        try {
            boolean hasError = false;
            try {
                resultSetHolder[0] = JFunctions.getScanResult(scanId).getRowids(nrows);
                String string = null;
                return string;
            }
            catch (Exception e) {
                hasError = true;
                throw e;
            }
            catch (Throwable throwable) {
                hasError = true;
                throw new Exception(throwable.getMessage());
            }
            finally {
                if (hasError) {
                    JFunctions.closeScanResultSet(scanId);
                }
            }
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String nrRemainingRowids(long scanId, long[] nr) throws Exception {
        NoSuchObjectException error = null;
        try {
            String string;
            block11: {
                JCCartResultSet jcrs;
                block9: {
                    String string2;
                    block10: {
                        jcrs = JFunctions.getScanResult(scanId);
                        if (jcrs != null) break block9;
                        nr[0] = 0L;
                        string2 = null;
                        if (error == null) break block10;
                        JFunctions.closeScanResultSet(scanId, !(error instanceof NoSuchObjectException));
                    }
                    return string2;
                }
                try {
                    int l_nr = jcrs.getNrRemainingRowids();
                    if (l_nr == 0) {
                        jcrs.cleanup();
                    }
                    nr[0] = l_nr;
                    string = null;
                    if (error == null) break block11;
                }
                catch (NoSuchObjectException nsoe) {
                    try {
                        error = nsoe;
                        throw new NoSuchObjectException("Results are no more available due to idle timeout");
                    }
                    catch (Throwable throwable) {
                        if (error != null) {
                            JFunctions.closeScanResultSet(scanId, !(error instanceof NoSuchObjectException));
                        }
                        throw throwable;
                    }
                }
                JFunctions.closeScanResultSet(scanId, !(error instanceof NoSuchObjectException));
            }
            return string;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    public static void addScanResult(long scanId, JCCartResultSet resultSet) {
        if (logger.isDebugEnabled()) {
            logger.debug("JFunctions.addScanResult: scanId=" + scanId);
        }
        scanResultMap.put(new Long(scanId), resultSet);
    }

    public static JCCartResultSet getScanResult(long scanId) {
        if (logger.isDebugEnabled()) {
            logger.debug("JFunctions.getScanResult: scanId=" + scanId);
        }
        return (JCCartResultSet)scanResultMap.get(new Long(scanId));
    }

    public static String closeScanResultSet(long scanId) throws Exception {
        try {
            JFunctions.closeScanResultSet(scanId, true);
            return null;
        }
        catch (Exception exception) {
            return JavaStoredProcExceptionHandler.handleTopLevelError(exception);
        }
    }

    private static void closeScanResultSet(long scanId, boolean dispose) throws Exception {
        JCCartResultSet jcResultSet = (JCCartResultSet)scanResultMap.remove(new Long(scanId));
        if (logger.isDebugEnabled()) {
            String s = null;
            if (jcResultSet != null) {
                s = "[" + jcResultSet.getClass().getName() + "]" + jcResultSet;
            }
            logger.debug("JFunctions.closeScanResult: scanId=" + scanId + ", jcResultSet=" + s);
        }
        if (jcResultSet != null && dispose) {
            jcResultSet.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getOldVsn(String idxSchema, String idxName, String idxPartition) throws Exception {
        PreparedStatement ps = null;
        ResultSet rset = null;
        String regCode = null;
        JcMetaDataFunctions.getJspInstance();
        String jcPropTableName = JcMetaDataFunctions.getJspInstance().getPropertyTableName(idxSchema, idxName, idxPartition);
        String stmt = "SELECT prop_value FROM " + jcPropTableName + " WHERE prop_name = ?";
        ps = JavaStoredProcSession.instance().prepareStatement(stmt);
        try {
            ps.setString(1, "registration.code.cartridge");
            rset = ps.executeQuery();
            rset.next();
            regCode = rset.getString(1);
        }
        catch (Exception ex) {
            String string;
            try {
                string = null;
            }
            catch (Throwable throwable) {
                JavaStoredProcSession.instance().close(rset, ps);
                ps = null;
                throw throwable;
            }
            JavaStoredProcSession.instance().close(rset, ps);
            ps = null;
            return string;
        }
        JavaStoredProcSession.instance().close(rset, ps);
        ps = null;
        return regCode;
    }

    public static void putTime() {
        Calendar cal = Calendar.getInstance();
        System.err.println(cal.get(10) + "." + cal.get(12) + "." + cal.get(13) + ":" + cal.get(14));
    }

    public static String getTime() {
        Calendar cal = Calendar.getInstance();
        return new String(cal.get(10) + "." + cal.get(12) + "." + cal.get(13) + ":" + cal.get(14));
    }

    public static long getTimeDiff(String time_b) {
        Calendar cal = Calendar.getInstance();
        StringTokenizer st = new StringTokenizer(time_b, ".");
        int hour_b = new Integer(st.nextToken());
        int min_b = new Integer(st.nextToken());
        StringTokenizer st_ = new StringTokenizer(st.nextToken(), ":");
        int sec_b = new Integer(st_.nextToken());
        int millsec_b = new Integer(st_.nextToken());
        int hour = cal.get(10);
        int min = cal.get(12);
        int sec = cal.get(13);
        int millsec = cal.get(14);
        return 3600000 * hour + 60000 * min + 1000 * sec + millsec - (3600000 * hour_b + 60000 * min_b + 1000 * sec_b + millsec_b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementUpdateCounter(String qualifTblName, String jcptName, boolean isJChemTable) throws SQLException {
        String incUpdateSequence = qualifTblName + "_USQ.nextval";
        String stmt = "UPDATE " + jcptName + " SET prop_value = " + incUpdateSequence + " WHERE prop_name = ?";
        String prefix = "idxtable.";
        if (isJChemTable) {
            prefix = "table.";
        }
        PreparedStatement ps = JavaStoredProcSession.instance().prepareStatement(stmt);
        try {
            ps.setString(1, prefix + qualifTblName.toUpperCase() + ".updateCounter");
            ps.execute();
        }
        finally {
            JavaStoredProcSession.instance().close(null, ps);
        }
    }

    public static void purgeConnectionCache() throws Exception {
        String cartOwner;
        RmiTunnel t = (RmiTunnel)RmiDirectory.instance().getServer("Tunnel");
        String realUser = JavaStoredProcSession.instance().getRealUser();
        String userSelector = realUser.equals(cartOwner = JavaStoredProcSession.instance().getJccOwner()) ? null : realUser;
        t.purgeConnectionCache(userSelector);
    }

    public static void checkMemory(String checkPoint) {
        Runtime.getRuntime().gc();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        System.err.println("At '" + checkPoint + "': totalMemory=" + totalMemory + ", freeMemory=" + freeMemory);
    }

    public static void trace(String msg) throws SQLException {
        DbSession session = DbSessionBase.getCurrent();
        StringBuffer sb = new StringBuffer(EMPTY_STRING);
        sb.append("[");
        sb.append(session.getOracleSessionId()).append(", ");
        sb.append(session.getRealUser()).append(", ");
        sb.append(session.getImpersonatedUser()).append("]: ").append(msg);
        JFunctions.traceKarg(sb.toString());
    }

    public static void traceKarg(String msg) {
        System.err.println(sdf.format(new Date()) + " " + msg);
        System.err.flush();
    }

    public static boolean isProfiling() {
        return profileId != null;
    }

    public static long startSearchProfiling() throws Exception {
        if (profileId != null) {
            throw new IllegalStateException("Profiling has already been started");
        }
        JCartProfiler pref = (JCartProfiler)RmiDirectory.instance().getServer("Profiler");
        long pid = pref.startSearchProfiling();
        profileId = new Long(pid);
        searchProfile = new OraSearchProfile();
        JFunctions.searchProfile.profileId = pid;
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopSearchProfiling() throws Exception {
        if (profileId == null) {
            throw new IllegalStateException("Profiling not started");
        }
        try {
            JCartProfiler pref = (JCartProfiler)RmiDirectory.instance().getServer("Profiler");
            pref.stopSearchProfiling(profileId, searchProfile);
        }
        finally {
            profileId = null;
            searchProfile = null;
        }
    }

    public static OraSearchProfile getSearchProfile() {
        return searchProfile;
    }

    public static String oracleObjectBaseName(String objName) {
        int idx = objName.lastIndexOf(46);
        if (idx != -1) {
            return objName.substring(idx + 1);
        }
        return objName;
    }

    public static boolean isSpace(byte[] barr) throws UnsupportedEncodingException {
        return barr.length == 1 && JFunctions.decodeDbString(barr).equals(" ");
    }

    public static byte[] encodeDbString(String s) throws UnsupportedEncodingException {
        if (s == null) {
            return null;
        }
        return s.getBytes("US-ASCII");
    }

    public static String decodeDbString(byte[] barr) throws UnsupportedEncodingException {
        if (barr == null) {
            return null;
        }
        return new String(barr, "US-ASCII");
    }

    public static String toString(byte[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(a[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static byte[] readBytes(ResultSet rs, int idx) throws SQLException {
        return JFunctions.readBytes(rs, idx, null);
    }

    public static byte[] readBytes(ResultSet rs, String columnName) throws SQLException {
        return JFunctions.readBytes(rs, 0, columnName);
    }

    private static byte[] readBytes(ResultSet rs, int idx, String columnName) throws SQLException {
        byte[] bytes = null;
        Object result = JFunctions.readBytesOrString(rs, idx, columnName);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            try {
                bytes = JFunctions.encodeDbString((String)result);
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            bytes = (byte[])result;
        }
        return bytes;
    }

    public static String readString(ResultSet rs, int idx) throws SQLException {
        if (idx < 1) {
            throw new IllegalArgumentException("Column index must be 1 or higher (\"" + idx + "\")");
        }
        Object result = JFunctions.readBytesOrString(rs, idx, null);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        try {
            return new String((byte[])result, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object readBytesOrString(ResultSet rs, int idx, String columnName) throws SQLException {
        Object o = null;
        o = idx > 0 ? rs.getObject(idx) : rs.getObject(columnName);
        if (o == null) {
            return null;
        }
        if (o instanceof Blob) {
            Blob blob = (Blob)o;
            return blob.getBytes(1L, (int)blob.length());
        }
        if (o instanceof Clob) {
            Clob clob = (Clob)o;
            return clob.getSubString(1L, (int)clob.length());
        }
        if (o instanceof byte[]) {
            return o;
        }
        if (o instanceof String) {
            return o;
        }
        String fName = null;
        fName = idx > 0 ? rs.getMetaData().getColumnName(idx) : columnName;
        throw new SQLException("Cannot handle type in field \"" + fName + "\": " + o.getClass().getName());
    }

    public static int translateBitCountToIntCount(int bitCount) {
        return bitCount % 32 == 0 ? bitCount / 32 : bitCount / 32 + 1;
    }

    public static int getFingerprintInInt(byte[] fingerprint, int position) {
        int part = 0;
        int m = 1;
        for (int j = 3; j >= 0; --j) {
            int b = fingerprint[4 * position + j];
            int i = b < 0 && j > 0 ? b + 256 : b;
            part += i * m;
            m *= 256;
        }
        return part;
    }

    public static void main(String[] args) throws Exception {
    }

    public static boolean mayBeLobSeed(String str) {
        return str == null ? false : str.length() == 0;
    }

    public static boolean isEmptyMol(String str) {
        return str == null || str.length() == 0 || str.equals("null") || str.equals(" ");
    }

    public static JCCartResultSet sendSearchInfo(SearchInfo searchInfo, String usrOpId) throws Exception {
        return JFunctions.sendSearchInfo(searchInfo, Long.MAX_VALUE, usrOpId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringResult(Connection connection, String sql) throws SQLException {
        String retval = null;
        PreparedStatement pstmt = connection.prepareStatement(sql);
        try {
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw new IllegalArgumentException("SQL return no result: " + sql);
            }
            Object obj = JFunctions.readBytesOrString(rs, 1, null);
            retval = obj instanceof String ? (String)obj : new String((byte[])obj);
            if (rs.next()) {
                throw new IllegalArgumentException("SQL returns more than one result: " + sql);
            }
            String string = retval;
            return string;
        }
        finally {
            pstmt.close();
        }
    }

    public static String toString(int[] a) {
        if (a == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        for (int ix = 0; ix < a.length; ++ix) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(a[ix]);
        }
        return sb.toString();
    }

    public static String toString(String[] a) {
        return InteropUtil.flattenStringArray(a);
    }

    static {
        ispectViewIdxSnc = new HashMap();
        CTRL_STRUCTURE_END_LENGTH = CTRL_STRUCTURE_END.length();
        CTRL_FORMULA_END_LENGTH = CTRL_FORMULA_END.length();
        CTRL_MOLWEIGHT_END_LENGTH = CTRL_MOLWEIGHT_END.length();
        SEARCH_OPERATORS = new String[]{"JC_CONTAINS", "JC_EQUALS", "JC_MATCHCOUNT", "JC_COMPARE"};
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        registrationCode = "0";
        scanResultMap = new Hashtable();
        structDescriptorCache = new HashMap();
    }
}

