/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.JavaStoredProcExceptionHandler;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.resultset.JCCartResultSet;
import chemaxon.jchem.cartridge.rmi.KilledTaskException;
import chemaxon.jchem.cartridge.rmi.Miscellanious;
import chemaxon.jchem.cartridge.structs.JCartIndexDescriptor;
import chemaxon.jchem.cartridge.tunnel.SessionInfo;
import chemaxon.jchem.cartridge.tunnel.search.DissimilaritySearchInfo;
import chemaxon.jchem.cartridge.tunnel.search.PredicateInfo;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.rmi.NoSuchObjectException;

public class JcSimilarity {
    private static final JCartLogger logger = JCartLogger.getLogger(JcSimilarity.class);
    public static final int SIM_TYPE_TANI_SIM = 0;
    public static final int SIM_TYPE_TANI_DISSIM = 1;
    public static final int SIM_TYPE_REACT_SIM = 2;
    public static final int SIM_TYPE_MD_SIM = 3;
    public static final int SIM_TYPE_TVERSKY_SIM = 4;
    public static final int SIM_TYPE_TVERSKY_DISSIM = 5;
    private static Miscellanious misc;

    public static String getSimilarity(String query, String jccOperator, String start, String stop, int opFlag, String searchOptions, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, long scanId) throws Exception {
        try {
            JcSimilarity.getSimilarityUc(query, jccOperator, new PredicateInfo(start, stop, opFlag), searchOptions, idxSchema, idxName, idxPartition, tblSchema, tblName, colName, scanId);
            return null;
        }
        catch (Exception e) {
            if (e instanceof NoSuchObjectException) {
                return JavaStoredProcExceptionHandler.handleTopLevelError(new KilledTaskException("No such object"));
            }
            return JavaStoredProcExceptionHandler.handleTopLevelError(e);
        }
    }

    private static void getSimilarityUc(String query, String jccOperator, PredicateInfo predInfo, String searchOptions, String idxSchema, String idxName, String idxPartition, String tblSchema, String tblName, String colName, long scanId) throws Exception {
        JCartIndexDescriptor idxDesc = JCartIndexDescriptor.get(JavaStoredProcSession.instance(), idxSchema, idxName, idxPartition, tblSchema, tblName, colName);
        if (logger.isDebugEnabled()) {
            logger.debug(idxDesc.toString());
        }
        SessionInfo sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
        CxOptions jcOpts = new CxOptions(searchOptions);
        int threadCount = jcOpts.getIntValue("threadCnt", 0);
        DissimilaritySearchInfo searchInfo = new DissimilaritySearchInfo(scanId, idxDesc, sessionInfo, jcOpts.getStringValue("usrOpId"), threadCount, predInfo, query, jccOperator, searchOptions, true, JFunctions.profileId, JFunctions.getOldVsn(idxSchema, idxName, idxPartition));
        JCCartResultSet rset = JFunctions.sendSearchInfo(searchInfo, jcOpts.getStringValue("usrOpId"));
        JFunctions.addScanResult(scanId, rset);
    }
}

