/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge;

import chemaxon.jchem.cartridge.JFunctions;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.tunnel.JcTableInfo;
import java.util.ArrayList;
import oracle.sql.ARRAY;

public class JcTableFunctions
extends JFunctions {
    public static void createJChemTable(String tableName, String jcPropTable, int numberOfInts, int numberOfOnes, int numberOfEdges, String colDefs, String standardizerConfig, int absStereo, String options) throws Exception {
        if (colDefs == null) {
            colDefs = "";
        }
        boolean absoluteStereo = absStereo != 0;
        int[] fpProps = new int[]{numberOfInts * 32, numberOfOnes, numberOfEdges};
        if (numberOfEdges == -1 || numberOfOnes == -1 || numberOfInts == -1) {
            fpProps = null;
        }
        JcTableInfo jcTableInfo = new JcTableInfo();
        jcTableInfo.jcPropTableName = jcPropTable;
        jcTableInfo.tableName = tableName;
        jcTableInfo.fpProps = fpProps;
        jcTableInfo.colDefs = colDefs;
        jcTableInfo.standardizerConfig = standardizerConfig;
        jcTableInfo.absoluteStereo = absoluteStereo;
        jcTableInfo.options = options;
        jcTableInfo.sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
        jcTableInfo.operation = 1;
        JcTableFunctions.getRmiTunnel().process(jcTableInfo);
    }

    public static void dropJChemTable(String tableName, String jcPropTable) throws Exception {
        JcTableInfo jcTableInfo = new JcTableInfo();
        jcTableInfo.jcPropTableName = jcPropTable;
        jcTableInfo.tableName = tableName;
        jcTableInfo.sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
        jcTableInfo.operation = 3;
        JcTableFunctions.getRmiTunnel().process(jcTableInfo);
    }

    public static ARRAY listJChemTablesArr(String jcPropTable) throws Exception {
        JcTableInfo jcTableInfo = new JcTableInfo();
        jcTableInfo.jcPropTableName = jcPropTable;
        jcTableInfo.sessionInfo = JavaStoredProcSession.instance().getSessionInfo();
        jcTableInfo.operation = 4;
        String resp = (String)JcTableFunctions.getRmiTunnel().process(jcTableInfo);
        ArrayList<String> list = new ArrayList<String>();
        String sep = "{sep}";
        int idxStart = 0;
        int idxEnd = resp.indexOf("{sep}", idxStart);
        while (idxEnd != -1) {
            list.add(resp.substring(idxStart, idxEnd));
            idxStart = idxEnd + "{sep}".length();
            idxEnd = resp.indexOf("{sep}", idxStart);
        }
        Object[] objArray = new Object[list.size()];
        objArray = list.toArray(objArray);
        return JcTableFunctions.convertToARRAY(objArray, "CHAR_ARRAY");
    }
}

