/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.batch;

import chemaxon.jchem.cartridge.batch.BatchResultProcessor;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.util.ArrayList;

public class BatchInsertProcessor
extends BatchResultProcessor {
    public static JCartLogger logger = JCartLogger.getLogger(BatchInsertProcessor.class);
    protected String tblSchema;
    protected String tblName;
    protected boolean blob;
    protected int fpCount;
    protected String flags;
    protected ArrayList arrayList = new ArrayList();
    final int ARRAY_SIZE = 4096;
    int[] intArray = new int[4096];
    int arrayIx = 0;

    public BatchInsertProcessor(String tblSchema, String tblName, boolean blob, int fpCount, String flags) {
        if (logger.isDebugEnabled()) {
            logger.debug("tblSchema" + tblSchema + ", tblName=" + tblName + ", blob=" + blob + ", fpCount=" + fpCount + ", flags" + flags);
        }
        this.tblSchema = tblSchema;
        this.tblName = tblName;
        this.blob = blob;
        this.fpCount = fpCount;
        this.flags = flags;
    }

    @Override
    public void process(byte[] byteArray) throws Exception {
        byte[] text = new String("{MOLPROPS_END}").getBytes("US-ASCII");
        int textLength = text.length;
        byte[] buffer = byteArray;
        int size = buffer.length;
        int endOfLastEntry = 0;
        for (int buffIx = 0; buffIx < size; ++buffIx) {
            boolean match = true;
            for (int testIx = 0; testIx < textLength && buffIx + testIx < size; ++testIx) {
                if (buffer[buffIx + testIx] == text[testIx]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            String entry = new String(buffer, endOfLastEntry, buffIx - endOfLastEntry, "US-ASCII");
            this.processEntry(entry);
            endOfLastEntry = buffIx += textLength;
        }
    }

    protected void processEntry(String entry) throws Exception {
        int idxMolpropsStart = 0;
        int rowidEndPos = entry.indexOf("{ROWID_END}");
        if (rowidEndPos != -1) {
            idxMolpropsStart = rowidEndPos + "{ROWID_END}".length();
        }
        String molpropsString = entry.substring(idxMolpropsStart);
    }

    protected void processJCEntry(String[] molProps) throws Exception {
        if (this.arrayIx == 4096) {
            this.arrayList.add(this.intArray);
            this.intArray = new int[4096];
            this.arrayIx = 0;
        }
    }

    public int[] getCdIdArray() {
        int fullArrayCount = this.arrayList.size();
        int[] buf = new int[fullArrayCount * 4096 + this.arrayIx];
        for (int ix = 0; ix < fullArrayCount; ++ix) {
            int[] source = (int[])this.arrayList.get(ix);
            System.arraycopy(source, 0, buf, ix * 4096, 4096);
        }
        System.arraycopy(this.intArray, 0, buf, fullArrayCount * 4096, this.arrayIx);
        return buf;
    }
}

