/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim;

import chemaxon.jchem.cartridge.JcMetaDataFunctions;
import chemaxon.jchem.cartridge.costestim.CostFactors;
import chemaxon.jchem.cartridge.costestim.OperatorCostFactors;
import chemaxon.jchem.cartridge.costestim.SloppyOperatorName;
import chemaxon.jchem.cartridge.dbsession.JavaStoredProcSession;
import chemaxon.jchem.cartridge.oresident.util.CxOptions;
import chemaxon.jchem.cartridge.util.JCartLogger;
import java.util.HashMap;
import java.util.Map;

public class JcOptCosts {
    public static final String[] COST_TYPE_STRINGS = new String[]{"index", "func"};
    public static final int COST_TYPE_INDEX = 0;
    public static final int COST_TYPE_FUNC = 1;
    public static final String[] RESOURCE_STRINGS = new String[]{"cpu", "io", "net"};
    public static final int RESOURCE_CPU = 0;
    public static final int RESOURCE_IO = 1;
    public static final int RESOURCE_NETWORK = 2;
    private static final JCartLogger logger = JCartLogger.getLogger(JcOptCosts.class);
    public static final OperatorCostFactors[] defaultCostEstimations = new OperatorCostFactors[]{new OperatorCostFactors("COMPARE", new CostFactors(1500000.0, 0.5, -1.0), new CostFactors(1.0E7, 0.0, 0.0))};
    private static final Map costEstimationCache = new HashMap();

    private JcOptCosts() {
    }

    private static void cache(OperatorCostFactors ocf) {
        String opName = ocf.getOpName().getSloppyName();
        costEstimationCache.put(opName, ocf);
        if (logger.isDebugEnabled()) {
            logger.debug("costEstimation set for " + opName);
        }
    }

    public static void setVolatileCostEstimation(String opName, double idxCpuCost, double idxIoCost, double idxNetCost, double funcCpuCost, double funcIoCost, double funcNetCost) {
        if (logger.isDebugEnabled()) {
            logger.debug("setVolatileCostEstimation(opName=" + opName + ", " + idxCpuCost + ", " + idxIoCost + ", " + idxNetCost + ", " + funcCpuCost + ", " + funcIoCost + ", " + funcNetCost + ")");
        }
        OperatorCostFactors ocf = new OperatorCostFactors(opName, new CostFactors(idxCpuCost, idxIoCost, idxNetCost), new CostFactors(funcCpuCost, funcIoCost, funcNetCost));
        JcOptCosts.cache(ocf);
    }

    private static double getCostFactor(CostFactors c, String resource) {
        if (resource.equals(RESOURCE_STRINGS[0])) {
            return c.getCpuCost();
        }
        if (resource.equals(RESOURCE_STRINGS[1])) {
            return c.getIoCost();
        }
        if (resource.equals(RESOURCE_STRINGS[2])) {
            return c.getNetworkCost();
        }
        throw new IllegalArgumentException("Unknown resource type: " + resource);
    }

    public static double getCostFactor(String costType, String opName, String options, String resource, String idxSchema, String idxName) throws Exception {
        String sloppy;
        if (logger.isDebugEnabled()) {
            logger.debug("getCostFactor(costType=" + costType + ", opName=" + opName + ", options=" + options + ", resource=" + resource + ", idxSchema=" + idxSchema + ", idxName=" + idxName + ")");
        }
        if ((sloppy = SloppyOperatorName.getMatchingSloppy(opName)).equals("EQUALS")) {
            opName = "JC_COMPARE";
            options = "t:p";
        }
        double cf = -1.0;
        OperatorCostFactors ocf = JcOptCosts.getCostFactorsFromCache(opName);
        if (ocf == null) {
            ocf = JcOptCosts.getStoredCostFactorFrom(opName, idxSchema, idxName);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Found cached cost factors");
        }
        if (ocf == null) {
            cf = -1.0;
        } else {
            if (costType.equals(COST_TYPE_STRINGS[0])) {
                cf = JcOptCosts.getCostFactor(ocf.getIndexCosts(), resource);
            } else if (costType.equals(COST_TYPE_STRINGS[1])) {
                cf = JcOptCosts.getCostFactor(ocf.getFuncCosts(), resource);
            } else {
                String errMsg = "Uknown cost type: " + costType;
                if (logger.isErrorEnabled()) {
                    logger.error(errMsg);
                }
                throw new IllegalArgumentException(errMsg);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Found persistent cost factor: " + cf);
            }
        }
        if (cf != -1.0 && options != null) {
            String costOptString;
            String searchType;
            CxOptions jcOptions = new CxOptions(options);
            if (costType.equals("index") && (searchType = jcOptions.getStringValue("t")).equalsIgnoreCase("p")) {
                cf = 0.75 * cf;
            }
            if ((costOptString = jcOptions.getStringValue(costType + "Cost")) != null) {
                double costOption = Double.parseDouble(costOptString);
                cf *= costOption;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getCostFactor(...) returning " + cf + "...");
        }
        return cf;
    }

    private static OperatorCostFactors getCostFactorsFromCache(String opName) {
        String sloppy = SloppyOperatorName.getMatchingSloppy(opName);
        return (OperatorCostFactors)costEstimationCache.get(sloppy);
    }

    private static OperatorCostFactors getStoredCostFactorFrom(String opName, String idxSchema, String idxName) throws Exception {
        String keyRoot = JcOptCosts.getKeyRoot(opName);
        String idxSpecKey = keyRoot + "." + idxSchema + "." + idxName;
        String costFactorsStr = JcMetaDataFunctions.getJspInstance().getMasterProperty(idxSchema, idxSpecKey);
        if (costFactorsStr == null) {
            String defaultKey = keyRoot + ".default";
            costFactorsStr = JcMetaDataFunctions.getJspInstance().getMasterProperty(JavaStoredProcSession.instance().getJccOwner(), defaultKey);
        }
        if (costFactorsStr == null) {
            if (logger.isInfoEnabled()) {
                logger.info("No cost factor at all for " + keyRoot);
            }
            return null;
        }
        return new OperatorCostFactors(opName, costFactorsStr);
    }

    public static void storeDefaultCostFactors() throws Exception {
        for (int i = 0; i < defaultCostEstimations.length; ++i) {
            OperatorCostFactors ocf = defaultCostEstimations[i];
            String key = JcOptCosts.getKeyRoot(ocf.getOpName().getSloppyName()) + ".default";
            String value = ocf.toString();
            JcMetaDataFunctions.getJspInstance().setMasterProperty(JavaStoredProcSession.instance().getJccOwner(), key, value);
        }
    }

    private static String getKeyRoot(String opName) {
        return "cost.factors." + SloppyOperatorName.getMatchingSloppy(opName);
    }

    public static void main(String[] args) {
        System.out.println(Double.parseDouble("1.0E7") / 1000.0);
    }
}

