/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.jchem.cartridge.costestim.calibra;

import chemaxon.jchem.cartridge.costestim.calibra.TuningData;
import chemaxon.jchem.cartridge.costestim.calibra.TuningDataTester;
import chemaxon.jchem.cartridge.costestim.calibra.TuningTarget;
import chemaxon.jchem.cartridge.util.JCartLogger;

public class FineTuner {
    private static JCartLogger logger = JCartLogger.getLogger(FineTuner.class);
    private TuningTarget tuningTarget;
    private TuningData current;
    private TuningData upper;
    private TuningData lower;
    private TuningDataTester tuningDataTester;

    public FineTuner(TuningTarget tuningTarget, TuningData startData, TuningDataTester tuningDataTester) {
        this.tuningTarget = tuningTarget;
        this.current = startData;
        this.tuningDataTester = tuningDataTester;
    }

    public TuningData tune() throws Exception {
        TuningData tp = null;
        this.tuningDataTester.test(this.current);
        while (this.needsMoreTuning()) {
            tp = this.calcTuningParam();
            this.tuningDataTester.test(tp);
        }
        if (tp == null) {
            tp = this.current;
        }
        return tp;
    }

    private int currentResultDelta() {
        int d = this.tuningTarget.targetResult - this.current.result;
        return d;
    }

    private TuningData calcTuningParam() throws Exception {
        if (this.isCurrentOvershot()) {
            this.upper = this.initReplCandidate(this.upper);
            this.upper = this.replace(this.upper);
        } else {
            this.lower = this.initReplCandidate(this.lower);
            this.lower = this.replace(this.lower);
        }
        return this.current;
    }

    private TuningData initReplCandidate(TuningData replCandidate) {
        if (replCandidate == null) {
            replCandidate = (TuningData)this.current.clone();
        }
        return replCandidate;
    }

    private boolean isCurrentOvershot() {
        return this.currentResultDelta() < 0;
    }

    private TuningData replace(TuningData replCandidate) throws Exception {
        int replResultDelta = this.tuningTarget.targetResult - replCandidate.result;
        if (!((double)Math.abs(this.currentResultDelta()) <= (double)Math.abs(replResultDelta) * 1.3)) {
            throw new Exception("currentDelta is significantly worse than replacementDelta: " + this.currentResultDelta() + ", " + replResultDelta);
        }
        replCandidate = this.calcNewParam(replCandidate);
        return replCandidate;
    }

    private TuningData calcNewParam(TuningData replCandidate) {
        TuningData oldCurrent = (TuningData)this.current.clone();
        double newDelta = -1.0;
        TuningData opposite = this.getOpposite(replCandidate);
        if (logger.isDebugEnabled()) {
            logger.debug("opposite=" + opposite);
        }
        if (opposite == null) {
            int cd = this.currentResultDelta();
            newDelta = (double)(Math.abs(cd) / cd) * this.current.param / 2.0;
        } else {
            newDelta = (opposite.param - this.current.param) / 2.0;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("current.param=" + this.current.param + ", newDelta=" + newDelta);
        }
        this.current.param += newDelta;
        return oldCurrent;
    }

    private TuningData getOpposite(TuningData bound) {
        if (bound == null) {
            throw new IllegalArgumentException("bound is null");
        }
        if (bound == this.upper) {
            return this.lower;
        }
        return this.upper;
    }

    private boolean needsMoreTuning() {
        return Math.abs(this.current.result - this.tuningTarget.targetResult) > this.tuningTarget.targetResultDelta;
    }

    public String toString() {
        return "FineTuner[tuningTarget=" + this.tuningTarget + ",current=" + this.current + ",upper=" + this.upper + ",lower=" + this.lower + "]";
    }

    public static void main(String[] args) {
        JCartLogger.setLevel("chemaxon", 3);
        try {
            TuningTarget tt = new TuningTarget(10, 1);
            TuningData sd = new TuningData(600.0, -1);
            TuningDataTester tdt = new TuningDataTester(){

                @Override
                public void test(TuningData tuningData) throws Exception {
                    tuningData.result = (int)tuningData.param / 4;
                    System.err.println("param=" + tuningData.param + ", result=" + tuningData.result);
                }
            };
            FineTuner ft = new FineTuner(tt, sd, tdt);
            ft.tune();
        }
        catch (Throwable tbl) {
            tbl.printStackTrace();
        }
    }
}

